/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.sybase;

import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IFromItem;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.visitor.framework.HierarchyVisitor;
import com.metamatrix.data.visitor.util.CollectorVisitor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Sybase11JoinCriteriaCollectorVisitor
extends HierarchyVisitor {
    private LinkedList criteriaList;
    private LinkedList groupSymbolsToDecorate;
    private ILanguageFactory languageFactory;

    public Sybase11JoinCriteriaCollectorVisitor(ILanguageFactory languageFactory) {
        this.languageFactory = languageFactory;
        this.criteriaList = new LinkedList();
        this.groupSymbolsToDecorate = new LinkedList();
    }

    public void visit(IJoin joinPredicate) {
        super.visit(joinPredicate);
        int joinType = joinPredicate.getJoinType();
        IFromItem innerFromClause = null;
        if (joinType == 2) {
            innerFromClause = joinPredicate.getRightItem();
        } else if (joinType == 3) {
            innerFromClause = joinPredicate.getLeftItem();
        }
        if (innerFromClause instanceof IGroup) {
            this.groupSymbolsToDecorate.add(innerFromClause);
        }
        List criteria = joinPredicate.getCriteria();
        Iterator criteriaIterator = criteria.iterator();
        LinkedList<ICompareCriteria> newCriteria = new LinkedList<ICompareCriteria>();
        while (criteriaIterator.hasNext()) {
            IGroup leftSymbol;
            ICriteria joinCriteria = (ICriteria)criteriaIterator.next();
            if (!(joinCriteria instanceof ICompareCriteria)) continue;
            ICompareCriteria compareCriteria = (ICompareCriteria)joinCriteria;
            if (joinType == 2) {
                IFromItem innerClauseOfLeftOuterJoin = joinPredicate.getRightItem();
                IGroup innerGroupSymbol = (IGroup)innerClauseOfLeftOuterJoin;
                leftSymbol = (IGroup)CollectorVisitor.collectGroupsUsedByElements((ILanguageObject)compareCriteria.getLeftExpression()).iterator().next();
                if (leftSymbol.equals(innerGroupSymbol)) {
                    newCriteria.add(this.createSybaseCompare(compareCriteria, 101));
                    continue;
                }
                newCriteria.add(this.createSybaseCompare(compareCriteria, 100));
                continue;
            }
            if (joinType == 3) {
                IFromItem outerClauseOfRightOuterJoin = joinPredicate.getRightItem();
                IGroup outerGroupSymbol = (IGroup)outerClauseOfRightOuterJoin;
                leftSymbol = (IGroup)CollectorVisitor.collectGroupsUsedByElements((ILanguageObject)compareCriteria.getLeftExpression()).iterator().next();
                if (!leftSymbol.equals(outerGroupSymbol)) {
                    newCriteria.add(this.createSybaseCompare(compareCriteria, 101));
                    continue;
                }
                newCriteria.add(this.createSybaseCompare(compareCriteria, 100));
                continue;
            }
            if (joinType != 0) continue;
            newCriteria.add(compareCriteria);
        }
        this.criteriaList.addAll(newCriteria);
    }

    private ICompareCriteria createSybaseCompare(ICompareCriteria crit, int sybaseOperator) {
        return this.languageFactory.createCompareCriteria(sybaseOperator, crit.getLeftExpression(), crit.getRightExpression());
    }

    public LinkedList getCriteriaList() {
        return this.criteriaList;
    }

    public LinkedList getGroupSymbolsToDecorate() {
        return this.groupSymbolsToDecorate;
    }
}

