/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.ssl;

import com.ddtek.jdbc.extensions.ExtEmbeddedConnection;
import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.ConnectionQueryStrategy;
import com.metamatrix.connector.jdbc.ConnectionStrategy;
import com.metamatrix.connector.jdbc.JDBCSingleIdentityConnectionFactory;
import com.metamatrix.connector.jdbc.JDBCSourceConnection;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.SourceConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCSequeLinkSingleIdentityConnectionFactory
extends JDBCSingleIdentityConnectionFactory {
    private static final String OEM_ID = "mm";
    private static final String JDBC_CAPABILITIES = "com.metamatrix.connector.jdbc.JDBCCapabilities";
    private static final String ORACLE_CAPABILITIES = "com.metamatrix.connector.jdbc.oracle.OracleCapabilities";
    private static final String DB2_CAPABILITIES = "com.metamatrix.connector.jdbc.db2.DB2Capabilities";
    private static final String SYBASE_CAPABILITIES = "com.metamatrix.connector.jdbc.sybase.SybaseCapabilities";
    private static final String SQLSERVER_CAPABILITIES = "com.metamatrix.connector.jdbc.sqlserver.SqlServerCapabilities";

    protected ConnectionStrategy createConnectionStrategy() {
        String capabilityClass = this.getConnectorEnvironment().getProperties().getProperty("ExtensionCapabilityClass", JDBC_CAPABILITIES);
        String queryTest = null;
        if (capabilityClass.equals(ORACLE_CAPABILITIES)) {
            queryTest = "Select 'x' from DUAL";
        } else if (capabilityClass.equals(DB2_CAPABILITIES)) {
            queryTest = "Select 'x' from sysibm.systables where 1 = 2";
        } else if (capabilityClass.equals(SYBASE_CAPABILITIES)) {
            queryTest = "Select 'x'";
        } else if (capabilityClass.equals(SQLSERVER_CAPABILITIES)) {
            queryTest = "Select 'x'";
        } else {
            return null;
        }
        return new ConnectionQueryStrategy(queryTest, this.sourceConnectionTestInterval);
    }

    protected SourceConnection createJDBCConnection(Driver driver, String url, int transactionIsolationLevel, Properties userProps) throws ConnectorException {
        Connection connection = null;
        try {
            connection = driver.connect(url, userProps);
            if (connection instanceof ExtEmbeddedConnection) {
                ((ExtEmbeddedConnection)connection).unlock(OEM_ID);
            }
            if (transactionIsolationLevel != Integer.MIN_VALUE) {
                connection.setTransactionIsolation(transactionIsolationLevel);
            }
        }
        catch (SQLException e) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
        }
        return new JDBCSourceConnection(connection, this.getConnectorEnvironment(), this.createConnectionStrategy(), this.getConnectionListener());
    }
}

