/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.postgresql;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.impl.AliasModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicSQLTranslator;
import com.metamatrix.connector.jdbc.extension.impl.Concat2FunctionModifier;
import com.metamatrix.connector.jdbc.oracle.MonthOrDayNameFunctionModifier;
import com.metamatrix.connector.jdbc.postgresql.DatePartFunctionModifier;
import com.metamatrix.connector.jdbc.postgresql.ModifiedDatePartFunctionModifier;
import com.metamatrix.connector.jdbc.postgresql.PostgreSQLConversionVisitor;
import com.metamatrix.connector.jdbc.postgresql.PostgreSQLConvertModifier;
import com.metamatrix.connector.jdbc.postgresql.SubstringFunctionModifier;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PostgreSQLTranslator
extends BasicSQLTranslator {
    private Map functionModifiers;
    private Properties connectorProperties;
    private ILanguageFactory languageFactory;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        super.initialize(env, metadata);
        ConnectorEnvironment connEnv = this.getConnectorEnvironment();
        this.connectorProperties = connEnv.getProperties();
        this.languageFactory = connEnv.getLanguageFactory();
        this.initializeFunctionModifiers();
    }

    private void initializeFunctionModifiers() {
        this.functionModifiers = new HashMap();
        this.functionModifiers.putAll(super.getFunctionModifiers());
        this.functionModifiers.put("log", new AliasModifier("ln"));
        this.functionModifiers.put("log10", new AliasModifier("log"));
        this.functionModifiers.put("char", new AliasModifier("chr"));
        this.functionModifiers.put("concat", new AliasModifier("||"));
        this.functionModifiers.put("concat2", new Concat2FunctionModifier(this.languageFactory, "||", "coalesce"));
        this.functionModifiers.put("lcase", new AliasModifier("lower"));
        this.functionModifiers.put("left", new SubstringFunctionModifier(this.languageFactory, true));
        this.functionModifiers.put("right", new SubstringFunctionModifier(this.languageFactory, false));
        this.functionModifiers.put("substring", new AliasModifier("substr"));
        this.functionModifiers.put("ucase", new AliasModifier("upper"));
        this.functionModifiers.put("dayname", new MonthOrDayNameFunctionModifier(this.languageFactory, "Day"));
        this.functionModifiers.put("dayofweek", new ModifiedDatePartFunctionModifier(this.languageFactory, "dow", "+", new Integer(1)));
        this.functionModifiers.put("dayofmonth", new DatePartFunctionModifier(this.languageFactory, "day"));
        this.functionModifiers.put("dayofyear", new DatePartFunctionModifier(this.languageFactory, "doy"));
        this.functionModifiers.put("hour", new DatePartFunctionModifier(this.languageFactory, "hour"));
        this.functionModifiers.put("minute", new DatePartFunctionModifier(this.languageFactory, "minute"));
        this.functionModifiers.put("month", new DatePartFunctionModifier(this.languageFactory, "month"));
        this.functionModifiers.put("monthname", new MonthOrDayNameFunctionModifier(this.languageFactory, "Month"));
        this.functionModifiers.put("quarter", new DatePartFunctionModifier(this.languageFactory, "quarter"));
        this.functionModifiers.put("second", new DatePartFunctionModifier(this.languageFactory, "second"));
        this.functionModifiers.put("week", new DatePartFunctionModifier(this.languageFactory, "week"));
        this.functionModifiers.put("year", new DatePartFunctionModifier(this.languageFactory, "year"));
        this.functionModifiers.put("ifnull", new AliasModifier("coalesce"));
        this.functionModifiers.put("nvl", new AliasModifier("coalesce"));
        this.functionModifiers.put("convert", new PostgreSQLConvertModifier(this.languageFactory));
        this.functionModifiers.put("cast", new PostgreSQLConvertModifier(this.languageFactory));
    }

    public SQLConversionVisitor getTranslationVisitor() {
        PostgreSQLConversionVisitor visitor = new PostgreSQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.functionModifiers);
        visitor.setProperties(this.connectorProperties);
        visitor.setLanguageFactory(this.languageFactory);
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }
}

