/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.connector.jdbc.ConnectionListener;
import com.metamatrix.connector.jdbc.ConnectionQueryStrategy;
import com.metamatrix.connector.jdbc.ConnectionStrategy;
import com.metamatrix.connector.jdbc.DefaultConnectionListener;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.JDBCSingleIdentityConnectionFactory;
import com.metamatrix.data.api.ConnectorEnvironment;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleSingleIdentityConnectionFactory
extends JDBCSingleIdentityConnectionFactory {
    private String queryTest = "Select 'x' from DUAL";
    private ConnectionListener connectionListener = new OracleConnectionListener();

    protected ConnectionStrategy createConnectionStrategy() {
        return new ConnectionQueryStrategy(this.queryTest, this.sourceConnectionTestInterval);
    }

    protected ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    private static class OracleConnectionListener
    extends DefaultConnectionListener {
        boolean alreadyReportedDetails = false;

        private OracleConnectionListener() {
        }

        public void afterConnectionCreation(Connection connection, ConnectorEnvironment env) {
            super.afterConnectionCreation(connection, env);
            if (this.alreadyReportedDetails) {
                return;
            }
            this.alreadyReportedDetails = true;
            String errorStr = JDBCPlugin.Util.getString("ConnectionListener.failed_to_report_oracle_connection_details");
            this.executeSQL(connection, env, "select * from v$instance", errorStr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void executeSQL(Connection connection, ConnectorEnvironment env, String sql, String errorStr) {
            block16: {
                ResultSet rs = null;
                Statement stmt = null;
                stmt = connection.createStatement();
                rs = stmt.executeQuery(sql);
                int columnCount = rs.getMetaData().getColumnCount();
                while (rs.next()) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 1; i <= columnCount; ++i) {
                        sb.append(rs.getMetaData().getColumnName(i)).append("=").append(rs.getString(i)).append(";");
                    }
                    env.getLogger().logInfo(sb.toString());
                }
                Object var11_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block16;
                }
                catch (SQLException e1) {
                    env.getLogger().logInfo(errorStr);
                }
                break block16;
                {
                    catch (SQLException e) {
                        env.getLogger().logInfo(errorStr);
                        Object var11_12 = null;
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (stmt != null) {
                                stmt.close();
                            }
                            break block16;
                        }
                        catch (SQLException e1) {
                            env.getLogger().logInfo(errorStr);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e1) {
                        env.getLogger().logInfo(errorStr);
                    }
                    throw throwable;
                }
            }
        }
    }
}

