/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.derby;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.connector.jdbc.extension.FunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicFunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.DropFunctionModifier;
import com.metamatrix.data.api.TypeFacility;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILiteral;
import java.util.ArrayList;
import java.util.List;

public class DerbyConvertModifier
extends BasicFunctionModifier
implements FunctionModifier {
    private static DropFunctionModifier DROP_MODIFIER = new DropFunctionModifier();
    private ILanguageFactory langFactory;

    public DerbyConvertModifier(ILanguageFactory langFactory) {
        this.langFactory = langFactory;
    }

    public List translate(IFunction function) {
        ArrayList<Object> parts = new ArrayList<Object>();
        parts.add("cast(");
        parts.add(function.getParameters()[0]);
        parts.add(" as ");
        ILiteral type = (ILiteral)function.getParameters()[1];
        parts.add(type.getValue());
        parts.add(")");
        return parts;
    }

    public IExpression modify(IFunction function) {
        IExpression[] args = function.getParameters();
        Class sourceType = args[0].getType();
        String targetTypeString = this.getTargetType(args[1]);
        Class targetType = DataTypeManager.getDataTypeClass((String)targetTypeString);
        IExpression returnExpr = null;
        if (targetType != null) {
            if (targetType.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
                returnExpr = this.convertToString(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.TIMESTAMP)) {
                returnExpr = this.convertToTimestamp(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.DATE)) {
                returnExpr = this.convertToDate(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.TIME)) {
                returnExpr = this.convertToTime(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN) || targetType.equals(TypeFacility.RUNTIME_TYPES.BYTE) || targetType.equals(TypeFacility.RUNTIME_TYPES.SHORT)) {
                returnExpr = this.convertToSmallInt(args[0], sourceType, targetType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.INTEGER)) {
                returnExpr = this.convertToInteger(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.LONG) || targetType.equals(TypeFacility.RUNTIME_TYPES.BIG_INTEGER)) {
                returnExpr = this.convertToBigInt(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.FLOAT)) {
                returnExpr = this.convertToFloat(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.DOUBLE)) {
                returnExpr = this.convertToDouble(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)) {
                returnExpr = this.convertToBigDecimal(args[0], sourceType);
            } else if (targetType.equals(TypeFacility.RUNTIME_TYPES.CHAR)) {
                returnExpr = this.convertToChar(args[0], sourceType);
            }
            if (returnExpr != null) {
                return returnExpr;
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private String getTargetType(IExpression expression) {
        if (expression != null && expression instanceof ILiteral) {
            String target = (String)((ILiteral)expression).getValue();
            return target.toLowerCase();
        }
        return null;
    }

    private IExpression convertToString(IExpression expression, Class sourceType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN)) {
            ILiteral literalZero = this.langFactory.createLiteral((Object)new Integer(0), TypeFacility.RUNTIME_TYPES.INTEGER);
            ICompareCriteria when = this.langFactory.createCompareCriteria(0, expression, (IExpression)literalZero);
            ArrayList<ICompareCriteria> whens = new ArrayList<ICompareCriteria>(1);
            whens.add(when);
            ILiteral literalFalse = this.langFactory.createLiteral((Object)"false", TypeFacility.RUNTIME_TYPES.STRING);
            ArrayList<ILiteral> thens = new ArrayList<ILiteral>(1);
            thens.add(literalFalse);
            ILiteral literalTrue = this.langFactory.createLiteral((Object)"true", TypeFacility.RUNTIME_TYPES.STRING);
            return this.langFactory.createSearchedCaseExpression(whens, thens, (IExpression)literalTrue, TypeFacility.RUNTIME_TYPES.STRING);
        }
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.CHAR)) {
            return null;
        }
        return this.wrapNewFunction(expression, "char", TypeFacility.RUNTIME_TYPES.STRING);
    }

    private IExpression convertToChar(IExpression expression, Class sourceType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            ILiteral literalOne = this.langFactory.createLiteral((Object)new Integer(1), TypeFacility.RUNTIME_TYPES.INTEGER);
            return this.langFactory.createFunction("char", new IExpression[]{expression, literalOne}, TypeFacility.RUNTIME_TYPES.CHAR);
        }
        return null;
    }

    private IExpression convertToSmallInt(IExpression expression, Class sourceType, Class targetType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.STRING) && targetType.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN)) {
            ILiteral literalTrue = this.langFactory.createLiteral((Object)"true", TypeFacility.RUNTIME_TYPES.STRING);
            ICompareCriteria when = this.langFactory.createCompareCriteria(0, expression, (IExpression)literalTrue);
            ArrayList<ICompareCriteria> whens = new ArrayList<ICompareCriteria>(1);
            whens.add(when);
            ILiteral literalOne = this.langFactory.createLiteral((Object)new Integer(1), TypeFacility.RUNTIME_TYPES.INTEGER);
            ArrayList<ILiteral> thens = new ArrayList<ILiteral>(1);
            thens.add(literalOne);
            ILiteral literalZero = this.langFactory.createLiteral((Object)new Integer(0), TypeFacility.RUNTIME_TYPES.INTEGER);
            return this.langFactory.createSearchedCaseExpression(whens, thens, (IExpression)literalZero, TypeFacility.RUNTIME_TYPES.STRING);
        }
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN) || sourceType.equals(TypeFacility.RUNTIME_TYPES.BYTE) || sourceType.equals(TypeFacility.RUNTIME_TYPES.SHORT)) {
            return null;
        }
        return this.wrapNewFunction(expression, "smallint", targetType);
    }

    private IExpression convertToInteger(IExpression expression, Class sourceType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.BOOLEAN) || sourceType.equals(TypeFacility.RUNTIME_TYPES.BYTE) || sourceType.equals(TypeFacility.RUNTIME_TYPES.SHORT)) {
            return null;
        }
        return this.wrapNewFunction(expression, "integer", TypeFacility.RUNTIME_TYPES.INTEGER);
    }

    private IExpression convertToBigInt(IExpression expression, Class sourceType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.STRING) || sourceType.equals(TypeFacility.RUNTIME_TYPES.FLOAT) || sourceType.equals(TypeFacility.RUNTIME_TYPES.DOUBLE) || sourceType.equals(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)) {
            return this.wrapNewFunction(expression, "bigint", TypeFacility.RUNTIME_TYPES.LONG);
        }
        return null;
    }

    private IExpression convertToFloat(IExpression expression, Class sourceType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            IFunction inner = this.langFactory.createFunction("convert", new IExpression[]{expression, this.langFactory.createLiteral((Object)"decimal", TypeFacility.RUNTIME_TYPES.STRING)}, TypeFacility.RUNTIME_TYPES.BIG_DECIMAL);
            IFunction outer = this.langFactory.createFunction("convert", new IExpression[]{inner, this.langFactory.createLiteral((Object)"float", TypeFacility.RUNTIME_TYPES.STRING)}, TypeFacility.RUNTIME_TYPES.FLOAT);
            return outer;
        }
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.DOUBLE) || sourceType.equals(TypeFacility.RUNTIME_TYPES.BIG_DECIMAL)) {
            return this.langFactory.createFunction("convert", new IExpression[]{expression, this.langFactory.createLiteral((Object)"float", TypeFacility.RUNTIME_TYPES.STRING)}, TypeFacility.RUNTIME_TYPES.FLOAT);
        }
        return null;
    }

    private IExpression convertToDouble(IExpression expression, Class sourceType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            IFunction inner = this.langFactory.createFunction("convert", new IExpression[]{expression, this.langFactory.createLiteral((Object)"decimal", TypeFacility.RUNTIME_TYPES.STRING)}, TypeFacility.RUNTIME_TYPES.BIG_DECIMAL);
            return this.langFactory.createFunction("convert", new IExpression[]{inner, this.langFactory.createLiteral((Object)"double", TypeFacility.RUNTIME_TYPES.STRING)}, TypeFacility.RUNTIME_TYPES.DOUBLE);
        }
        return null;
    }

    private IExpression convertToBigDecimal(IExpression expression, Class sourceType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            return this.langFactory.createFunction("convert", new IExpression[]{expression, this.langFactory.createLiteral((Object)"decimal", TypeFacility.RUNTIME_TYPES.STRING)}, TypeFacility.RUNTIME_TYPES.BIG_DECIMAL);
        }
        return null;
    }

    private IExpression convertToDate(IExpression expression, Class sourceType) {
        return this.wrapNewFunction(expression, "date", TypeFacility.RUNTIME_TYPES.DATE);
    }

    private IExpression convertToTime(IExpression expression, Class sourceType) {
        return this.wrapNewFunction(expression, "time", TypeFacility.RUNTIME_TYPES.DATE);
    }

    private IExpression convertToTimestamp(IExpression expression, Class sourceType) {
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.STRING)) {
            return this.wrapNewFunction(expression, "timestamp", TypeFacility.RUNTIME_TYPES.TIMESTAMP);
        }
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.DATE)) {
            ILiteral timeString = this.langFactory.createLiteral((Object)"00:00:00", TypeFacility.RUNTIME_TYPES.STRING);
            return this.langFactory.createFunction("timestamp", new IExpression[]{expression, timeString}, TypeFacility.RUNTIME_TYPES.TIMESTAMP);
        }
        if (sourceType.equals(TypeFacility.RUNTIME_TYPES.TIME)) {
            ILiteral dateString = this.langFactory.createLiteral((Object)"1970-01-01", TypeFacility.RUNTIME_TYPES.STRING);
            return this.langFactory.createFunction("timestamp", new IExpression[]{dateString, expression}, TypeFacility.RUNTIME_TYPES.TIMESTAMP);
        }
        return null;
    }

    private IFunction wrapNewFunction(IExpression expression, String functionName, Class outputType) {
        return this.langFactory.createFunction(functionName, new IExpression[]{expression}, outputType);
    }
}

