/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.db2;

import com.metamatrix.connector.jdbc.db2.DB2ConvertModifier;
import com.metamatrix.connector.jdbc.db2.DB2SQLConversionVisitor;
import com.metamatrix.connector.jdbc.db2.DB2SQLModificationVisitor;
import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.impl.AliasModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicSQLTranslator;
import com.metamatrix.connector.jdbc.extension.impl.Concat2FunctionModifier;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IFromItem;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.LanguageUtil;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;
import com.metamatrix.data.visitor.util.CollectorVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DB2SQLTranslator
extends BasicSQLTranslator {
    private Map functionModifiers;
    private ILanguageFactory languageFactory;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        super.initialize(env, metadata);
        this.languageFactory = this.getConnectorEnvironment().getLanguageFactory();
        this.initializeFunctionModifiers();
    }

    private void initializeFunctionModifiers() {
        this.functionModifiers = new HashMap();
        this.functionModifiers.putAll(super.getFunctionModifiers());
        this.functionModifiers.put("cast", new DB2ConvertModifier(this.languageFactory));
        this.functionModifiers.put("char", new AliasModifier("chr"));
        this.functionModifiers.put("concat2", new Concat2FunctionModifier(this.languageFactory, "concat", "coalesce"));
        this.functionModifiers.put("convert", new DB2ConvertModifier(this.languageFactory));
        this.functionModifiers.put("dayofmonth", new AliasModifier("day"));
        this.functionModifiers.put("ifnull", new AliasModifier("coalesce"));
        this.functionModifiers.put("nvl", new AliasModifier("coalesce"));
        this.functionModifiers.put("substring", new AliasModifier("substr"));
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }

    public ICommand modifyCommand(ICommand command, ExecutionContext context) throws ConnectorException {
        command = this.moveCriteria(command);
        DB2SQLModificationVisitor visitor = new DB2SQLModificationVisitor(this.getConnectorEnvironment().getLanguageFactory());
        command.acceptVisitor((LanguageObjectVisitor)visitor);
        return command;
    }

    public SQLConversionVisitor getTranslationVisitor() {
        DB2SQLConversionVisitor visitor = new DB2SQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.functionModifiers);
        visitor.setProperties(super.getConnectorEnvironment().getProperties());
        visitor.setLanguageFactory(this.languageFactory);
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }

    ICommand moveCriteria(ICommand command) throws ConnectorException {
        IQuery query;
        IFrom from;
        if (command instanceof IQuery && (from = (query = (IQuery)command).getFrom()).getItems().size() == 1 && query.getWhere() != null) {
            IFromItem singleClause = (IFromItem)from.getItems().get(0);
            HashSet groups = new HashSet();
            this.collectInnerGroups(singleClause, groups);
            if (groups.size() > 0) {
                LinkedList predicates = new LinkedList();
                query.setWhere(this.replaceCriteria(query.getWhere(), groups, predicates));
                this.updateFrom(singleClause, predicates);
            }
        }
        return command;
    }

    void collectInnerGroups(IFromItem clause, Set groups) {
        if (clause instanceof IJoin) {
            IJoin jp = (IJoin)clause;
            int type = jp.getJoinType();
            if (type == 2) {
                groups.addAll(CollectorVisitor.collectGroups((ILanguageObject)jp.getRightItem()));
                this.collectInnerGroups(jp.getLeftItem(), groups);
            } else if (type == 3) {
                groups.addAll(CollectorVisitor.collectGroups((ILanguageObject)jp.getLeftItem()));
                this.collectInnerGroups(jp.getRightItem(), groups);
            } else if (type == 0) {
                this.collectInnerGroups(jp.getLeftItem(), groups);
                this.collectInnerGroups(jp.getRightItem(), groups);
            }
        }
    }

    ICriteria replaceCriteria(ICriteria criteria, Set innerGroups, List predicates) {
        List conjuncts = LanguageUtil.separateCriteriaByAnd((ICriteria)criteria);
        ICriteria newCriteria = null;
        Iterator iter = conjuncts.iterator();
        while (iter.hasNext()) {
            ICriteria conjunct = (ICriteria)iter.next();
            if (this.shouldRemove(conjunct, innerGroups)) {
                predicates.add(conjunct);
                continue;
            }
            newCriteria = LanguageUtil.combineCriteria(newCriteria, (ICriteria)conjunct, (ILanguageFactory)this.getConnectorEnvironment().getLanguageFactory());
        }
        return newCriteria;
    }

    boolean shouldRemove(ICriteria crit, Set innerGroups) {
        Set groups = CollectorVisitor.collectGroupsUsedByElements((ILanguageObject)crit);
        Iterator groupIter = groups.iterator();
        while (groupIter.hasNext()) {
            if (!innerGroups.contains(groupIter.next())) continue;
            return true;
        }
        return false;
    }

    void updateFrom(IFromItem clause, List predicates) {
        if (clause instanceof IJoin) {
            IJoin jp = (IJoin)clause;
            this.updateFrom(jp.getLeftItem(), predicates);
            this.updateFrom(jp.getRightItem(), predicates);
            if (predicates.size() > 0) {
                Collection predGroups = CollectorVisitor.collectGroups((ILanguageObject)jp);
                Iterator predIter = predicates.iterator();
                while (predIter.hasNext()) {
                    ICriteria crit = (ICriteria)predIter.next();
                    Set critGroups = CollectorVisitor.collectGroupsUsedByElements((ILanguageObject)crit);
                    if (!predGroups.containsAll(critGroups)) continue;
                    predIter.remove();
                    jp.getCriteria().add(crit);
                }
            }
        }
    }
}

