/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.JDBCQueryExecution;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.connector.jdbc.util.JDBCExecutionHelper;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class JDBCProcedureExecution
extends JDBCQueryExecution
implements ProcedureExecution {
    private Map parameterIndexMap;
    private RuntimeMetadata metadata;

    public JDBCProcedureExecution(Connection connection, SQLTranslator sqlTranslator, ResultsTranslator resultsTranslator, ConnectorLogger logger, Properties props, RuntimeMetadata metadata, ExecutionContext context) {
        super(connection, sqlTranslator, resultsTranslator, logger, props, context);
        this.metadata = metadata;
    }

    public void execute(IProcedure procedure, int maxBatchSize) throws ConnectorException {
        block4: {
            this.maxBatchSize = maxBatchSize;
            this.columnDataTypes = JDBCExecutionHelper.getColumnDataTypes(procedure.getParameters(), this.metadata);
            TranslatedCommand translatedComm = this.translateCommand((ICommand)procedure);
            String sql = translatedComm.getSql();
            try {
                if (translatedComm.getStatementType() == 2) {
                    this.parameterIndexMap = JDBCExecutionHelper.createParameterIndexMap(procedure.getParameters(), sql);
                    CallableStatement cstmt = this.getCallableStatement(sql);
                    this.results = this.resultsTranslator.executeStoredProcedure(cstmt, translatedComm);
                    if (cstmt.getWarnings() != null) {
                        this.logger.logDetail(StringUtil.getStackTrace((Throwable)cstmt.getWarnings()));
                    }
                    break block4;
                }
                throw new ConnectorException(JDBCPlugin.Util.getString("JDBCSynchExecution.Statement_type_not_support_for_command_1", (Object)new Integer(translatedComm.getStatementType()), (Object)sql));
            }
            catch (SQLException e) {
                this.close();
                this.logger.logError(JDBCPlugin.Util.getString("JDBCQueryExecution.Error_executing_query__1", (Object)sql));
                throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
            }
        }
    }

    public Batch nextBatch() throws ConnectorException {
        return JDBCExecutionHelper.createBatch(this.results, this.columnDataTypes, this.maxBatchSize, this.trimString, this.resultsTranslator, this.context, this.getCalendar());
    }

    public Object getOutputValue(IParameter parameter) throws ConnectorException {
        if (parameter.getDirection() != 1 && parameter.getDirection() != 2 && parameter.getDirection() != 3) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCProcedureExecution.The_parameter_direction_must_be_out_or_inout_1"));
        }
        Integer index = (Integer)this.parameterIndexMap.get(parameter);
        if (index == null) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCProcedureExecution.Unexpected_exception_1"));
        }
        try {
            Object value = ((CallableStatement)this.statement).getObject(index);
            if (value == null) {
                return null;
            }
            return JDBCExecutionHelper.convertValue(value, parameter.getType(), this.resultsTranslator.getValueTranslators(), this.trimString, this.context);
        }
        catch (SQLException e) {
            throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e));
        }
    }
}

