/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.permissionadmin;

public class PermissionInfo {
    private String type;
    private String name;
    private String actions;

    public PermissionInfo(String type, String name, String actions) {
        this.type = type;
        this.name = name;
        this.actions = actions;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (name == null && actions != null) {
            throw new IllegalArgumentException("name missing");
        }
    }

    public PermissionInfo(String encodedPermission) {
        if (encodedPermission == null) {
            throw new NullPointerException("missing encoded permission");
        }
        if (encodedPermission.length() == 0) {
            throw new IllegalArgumentException("empty encoded permission");
        }
        try {
            int end;
            char[] encoded = encodedPermission.toCharArray();
            if (encoded[0] != '(') {
                throw new IllegalArgumentException("first character not open parenthesis");
            }
            int begin = end = 1;
            while (encoded[end] != ' ' && encoded[end] != ')') {
                ++end;
            }
            if (end == begin) {
                throw new IllegalArgumentException("expecting type");
            }
            this.type = new String(encoded, begin, end - begin);
            if (encoded[end] == ' ') {
                if (encoded[++end] != '\"') {
                    throw new IllegalArgumentException("expecting quoted name");
                }
                begin = ++end;
                while (encoded[end] != '\"') {
                    if (encoded[end] == '\\') {
                        ++end;
                    }
                    ++end;
                }
                this.name = PermissionInfo.decodeString(encoded, begin, end);
                if (encoded[++end] == ' ') {
                    if (encoded[++end] != '\"') {
                        throw new IllegalArgumentException("expecting quoted actions");
                    }
                    begin = ++end;
                    while (encoded[end] != '\"') {
                        if (encoded[end] == '\\') {
                            ++end;
                        }
                        ++end;
                    }
                    this.actions = PermissionInfo.decodeString(encoded, begin, end);
                    ++end;
                }
            }
            if (encoded[end] != ')' || end + 1 != encoded.length) {
                throw new IllegalArgumentException("last character not close parenthesis");
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new IllegalArgumentException("parsing terminated abruptly");
        }
    }

    public final String getEncoded() {
        StringBuffer output = new StringBuffer(8 + this.type.length() + ((this.name == null ? 0 : this.name.length()) + (this.actions == null ? 0 : this.actions.length()) << 1));
        output.append('(');
        output.append(this.type);
        if (this.name != null) {
            output.append(" \"");
            PermissionInfo.encodeString(this.name, output);
            if (this.actions != null) {
                output.append("\" \"");
                PermissionInfo.encodeString(this.actions, output);
            }
            output.append('\"');
        }
        output.append(')');
        return output.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final String getActions() {
        return this.actions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PermissionInfo)) {
            return false;
        }
        PermissionInfo other = (PermissionInfo)obj;
        if (!this.type.equals(other.type) || this.name == null ^ other.name == null || this.actions == null ^ other.actions == null) {
            return false;
        }
        if (this.name != null) {
            if (this.actions != null) {
                return this.name.equals(other.name) && this.actions.equals(other.actions);
            }
            return this.name.equals(other.name);
        }
        return true;
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        if (this.name != null) {
            hash ^= this.name.hashCode();
            if (this.actions != null) {
                hash ^= this.actions.hashCode();
            }
        }
        return hash;
    }

    private static void encodeString(String str, StringBuffer output) {
        int len = str.length();
        block5: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    output.append('\\');
                    output.append(c2);
                    continue block5;
                }
                case '\r': {
                    output.append("\\r");
                    continue block5;
                }
                case '\n': {
                    output.append("\\n");
                    continue block5;
                }
                default: {
                    output.append(c2);
                }
            }
        }
    }

    private static String decodeString(char[] str, int begin, int end) {
        StringBuffer output = new StringBuffer(end - begin);
        for (int i2 = begin; i2 < end; ++i2) {
            int c2 = str[i2];
            if (c2 == 92 && ++i2 < end) {
                c2 = str[i2];
                if (c2 == 110) {
                    c2 = 10;
                } else if (c2 == 114) {
                    c2 = 13;
                }
            }
            output.append((char)c2);
        }
        return output.toString();
    }
}

