/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.ServicePermissionCollection;

public final class ServicePermission
extends BasicPermission {
    static final long serialVersionUID = -7662148639076511574L;
    public static final String GET = "get";
    public static final String REGISTER = "register";
    private static final int ACTION_GET = 1;
    private static final int ACTION_REGISTER = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_ERROR = Integer.MIN_VALUE;
    private transient int action_mask = 0;
    private String actions = null;

    public ServicePermission(String name, String actions) {
        this(name, ServicePermission.getMask(actions));
    }

    ServicePermission(String name, int mask) {
        super(name);
        this.init(mask);
    }

    private void init(int mask) {
        if (mask == 0 || (mask & 3) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMask(String actions) {
        boolean seencomma = false;
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a2 = actions.toCharArray();
        int i2 = a2.length - 1;
        if (i2 < 0) {
            return mask;
        }
        while (i2 != -1) {
            void var6_6;
            int matchlen;
            char c2;
            while (i2 != -1 && ((c2 = a2[i2]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --i2;
            }
            if (!(i2 < 2 || a2[i2 - 2] != 'g' && a2[i2 - 2] != 'G' || a2[i2 - 1] != 'e' && a2[i2 - 1] != 'E' || a2[i2] != 't' && a2[i2] != 'T')) {
                matchlen = 3;
                mask |= 1;
            } else if (!(i2 < 7 || a2[i2 - 7] != 'r' && a2[i2 - 7] != 'R' || a2[i2 - 6] != 'e' && a2[i2 - 6] != 'E' || a2[i2 - 5] != 'g' && a2[i2 - 5] != 'G' || a2[i2 - 4] != 'i' && a2[i2 - 4] != 'I' || a2[i2 - 3] != 's' && a2[i2 - 3] != 'S' || a2[i2 - 2] != 't' && a2[i2 - 2] != 'T' || a2[i2 - 1] != 'e' && a2[i2 - 1] != 'E' || a2[i2] != 'r' && a2[i2] != 'R')) {
                matchlen = 8;
                mask |= 2;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            seencomma = false;
            while (i2 >= var6_6 && !seencomma) {
                switch (a2[i2 - var6_6]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i2;
            }
            i2 -= var6_6;
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    public boolean implies(Permission p2) {
        if (p2 instanceof ServicePermission) {
            ServicePermission target = (ServicePermission)p2;
            return (this.action_mask & target.action_mask) == target.action_mask && super.implies(p2);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            if ((this.action_mask & 1) == 1) {
                sb.append(GET);
                comma = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(REGISTER);
            }
            this.actions = sb.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new ServicePermissionCollection();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServicePermission)) {
            return false;
        }
        ServicePermission p2 = (ServicePermission)obj;
        return this.action_mask == p2.action_mask && this.getName().equals(p2.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream s2) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s2.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.init(ServicePermission.getMask(this.actions));
    }
}

