/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.BundlePermissionCollection;

public final class BundlePermission
extends BasicPermission {
    private static final long serialVersionUID = 3257846601685873716L;
    public static final String PROVIDE = "provide";
    public static final String REQUIRE = "require";
    public static final String HOST = "host";
    public static final String FRAGMENT = "fragment";
    private static final int ACTION_PROVIDE = 1;
    private static final int ACTION_REQUIRE = 2;
    private static final int ACTION_HOST = 4;
    private static final int ACTION_FRAGMENT = 8;
    private static final int ACTION_ALL = 15;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_ERROR = Integer.MIN_VALUE;
    private transient int action_mask = 0;
    private String actions = null;

    public BundlePermission(String symbolicName, String actions) {
        this(symbolicName, BundlePermission.getMask(actions));
    }

    BundlePermission(String symbolicName, int mask) {
        super(symbolicName);
        this.init(mask);
    }

    private void init(int mask) {
        if (mask == 0 || (mask & 0xF) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMask(String actions) {
        boolean seencomma = false;
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a2 = actions.toCharArray();
        int i2 = a2.length - 1;
        if (i2 < 0) {
            return mask;
        }
        while (i2 != -1) {
            void var6_6;
            int matchlen;
            char c2;
            while (i2 != -1 && ((c2 = a2[i2]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --i2;
            }
            if (!(i2 < 6 || a2[i2 - 6] != 'p' && a2[i2 - 6] != 'P' || a2[i2 - 5] != 'r' && a2[i2 - 5] != 'R' || a2[i2 - 4] != 'o' && a2[i2 - 4] != 'O' || a2[i2 - 3] != 'v' && a2[i2 - 3] != 'V' || a2[i2 - 2] != 'i' && a2[i2 - 2] != 'I' || a2[i2 - 1] != 'd' && a2[i2 - 1] != 'D' || a2[i2] != 'e' && a2[i2] != 'E')) {
                matchlen = 7;
                mask |= 3;
            } else if (!(i2 < 6 || a2[i2 - 6] != 'r' && a2[i2 - 6] != 'R' || a2[i2 - 5] != 'e' && a2[i2 - 5] != 'E' || a2[i2 - 4] != 'q' && a2[i2 - 4] != 'Q' || a2[i2 - 3] != 'u' && a2[i2 - 3] != 'U' || a2[i2 - 2] != 'i' && a2[i2 - 2] != 'I' || a2[i2 - 1] != 'r' && a2[i2 - 1] != 'R' || a2[i2] != 'e' && a2[i2] != 'E')) {
                matchlen = 7;
                mask |= 2;
            } else if (!(i2 < 3 || a2[i2 - 3] != 'h' && a2[i2 - 3] != 'H' || a2[i2 - 2] != 'o' && a2[i2 - 2] != 'O' || a2[i2 - 1] != 's' && a2[i2 - 1] != 'S' || a2[i2] != 't' && a2[i2] != 'T')) {
                matchlen = 4;
                mask |= 4;
            } else if (!(i2 < 7 || a2[i2 - 7] != 'f' && a2[i2 - 7] != 'F' || a2[i2 - 6] != 'r' && a2[i2 - 6] != 'R' || a2[i2 - 5] != 'a' && a2[i2 - 5] != 'A' || a2[i2 - 4] != 'g' && a2[i2 - 4] != 'G' || a2[i2 - 3] != 'm' && a2[i2 - 3] != 'M' || a2[i2 - 2] != 'e' && a2[i2 - 2] != 'E' || a2[i2 - 1] != 'n' && a2[i2 - 1] != 'N' || a2[i2] != 't' && a2[i2] != 'T')) {
                matchlen = 8;
                mask |= 8;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            seencomma = false;
            while (i2 >= var6_6 && !seencomma) {
                switch (a2[i2 - var6_6]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i2;
            }
            i2 -= var6_6;
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    public boolean implies(Permission p2) {
        if (p2 instanceof BundlePermission) {
            BundlePermission target = (BundlePermission)p2;
            return (this.action_mask & target.action_mask) == target.action_mask && super.implies(p2);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            if ((this.action_mask & 1) == 1) {
                sb.append(PROVIDE);
                comma = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(REQUIRE);
                comma = true;
            }
            if ((this.action_mask & 4) == 4) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(HOST);
            }
            if ((this.action_mask & 8) == 8) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(FRAGMENT);
            }
            this.actions = sb.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new BundlePermissionCollection();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BundlePermission)) {
            return false;
        }
        BundlePermission p2 = (BundlePermission)obj;
        return this.action_mask == p2.action_mask && this.getName().equals(p2.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream s2) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s2.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.init(BundlePermission.getMask(this.actions));
    }
}

