/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XSDParser
extends DefaultHandler
implements LexicalHandler {
    protected static final Map userDataMap = Collections.synchronizedMap(new WeakHashMap());
    protected XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    protected XSDSchema xsdSchema;
    protected List xsdDiagnostics = new ArrayList();
    protected SAXParser saxParser;
    protected Document document;
    protected Stack stack = new Stack();
    protected Element element;
    protected Locator locator;
    protected int line;
    protected int column;
    protected String encoding;

    public static Map getUserData(Node node) {
        HashMap result = (HashMap)userDataMap.get(node);
        if (result == null) {
            result = new HashMap();
            userDataMap.put(node, result);
        }
        return result;
    }

    public static int getStartLine(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("startLine");
        return result == null ? 1 : result;
    }

    public static int getStartColumn(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("startColumn");
        return result == null ? 1 : result;
    }

    public static int getEndLine(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("endLine");
        return result == null ? 1 : result;
    }

    public static int getEndColumn(Node node) {
        Integer result = (Integer)XSDParser.getUserData(node).get("endColumn");
        return result == null ? 1 : result;
    }

    public XSDParser() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(false);
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.saxParser = saxParserFactory.newSAXParser();
            this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException exception) {
            this.fatalError(exception);
        }
        catch (ParserConfigurationException exception) {
            this.fatalError(exception);
        }
    }

    public void parse(String uri) {
        block3: {
            try {
                this.saxParser.parse(new InputSource(uri), (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
            }
            catch (SAXException exception) {
                if (!this.xsdDiagnostics.isEmpty()) break block3;
                this.fatalError(exception);
            }
        }
    }

    public void parseString(String input) {
        this.parse(new InputSource(new StringReader(input)));
    }

    public void parse(InputSource inputSource) {
        block3: {
            try {
                this.saxParser.parse(inputSource, (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
            }
            catch (SAXException exception) {
                if (!this.xsdDiagnostics.isEmpty()) break block3;
                this.fatalError(exception);
            }
        }
    }

    public void parse(InputStream inputStream) {
        block3: {
            try {
                this.saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
            }
            catch (SAXException exception) {
                if (!this.xsdDiagnostics.isEmpty()) break block3;
                this.fatalError(exception);
            }
        }
    }

    public String getEncoding() {
        if (this.locator != null) {
            try {
                Method getEncodingMethod = this.locator.getClass().getMethod("getEncoding", new Class[0]);
                if (getEncodingMethod != null) {
                    this.encoding = (String)getEncodingMethod.invoke((Object)this.locator, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.encoding;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setSchema(XSDSchema xsdSchema) {
        if (this.document != null) {
            this.xsdSchema = xsdSchema;
            Element element = this.document.getDocumentElement();
            if (element != null) {
                xsdSchema.setElement(element);
            }
            xsdSchema.clearDiagnostics();
            XSDResourceImpl.assignDiagnostics(xsdSchema, this.xsdDiagnostics);
            XSDResourceImpl resource = (XSDResourceImpl)xsdSchema.eResource();
            if (resource != null && this.getEncoding() != null) {
                resource.getDefaultSaveOptions().put(XSDResourceImpl.XSD_ENCODING, this.getEncoding());
            }
        }
    }

    public XSDSchema getSchema() {
        if (this.xsdSchema == null && this.document != null) {
            Element element = this.document.getDocumentElement();
            this.xsdSchema = element == null ? this.xsdFactory.createXSDSchema() : XSDSchemaImpl.createSchema(element);
            XSDResourceImpl.assignDiagnostics(this.xsdSchema, this.xsdDiagnostics);
        }
        return this.xsdSchema;
    }

    public Collection getDiagnostics() {
        return this.xsdDiagnostics;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element newElement = this.document.createElementNS(uri, qName);
        int length = attributes.getLength();
        for (int i2 = 0; i2 < length; ++i2) {
            String attributeURI = attributes.getURI(i2);
            String attributeQName = attributes.getQName(i2);
            String attributeValue = attributes.getValue(i2);
            if (attributeQName.equals("xmlns") || attributeQName.startsWith("xmlns:")) {
                attributeURI = "http://www.w3.org/2000/xmlns/";
            } else if ("".equals(attributeURI)) {
                attributeURI = null;
            }
            newElement.setAttributeNS(attributeURI, attributeQName, attributeValue);
        }
        if (this.stack.isEmpty()) {
            this.document.appendChild(newElement);
        } else {
            this.element.appendChild(newElement);
        }
        this.stack.push(this.element);
        this.element = newElement;
        Map extendedAttributes = XSDParser.getUserData(this.element);
        extendedAttributes.put("startLine", new Integer(this.line));
        extendedAttributes.put("startColumn", new Integer(this.column));
        this.saveLocation();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.saveLocation();
        Map extendedAttributes = XSDParser.getUserData(this.element);
        extendedAttributes.put("endLine", new Integer(this.line));
        extendedAttributes.put("endColumn", new Integer(this.column));
        this.element = (Element)this.stack.pop();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void startDocument() {
        this.saveLocation();
        this.document = XSDParser.createDocument();
        this.xsdSchema = null;
        this.getEncoding();
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException exception) {
            XSDPlugin.INSTANCE.log(exception);
            return null;
        }
    }

    public void endDocument() {
        this.element = null;
        this.saveLocation();
        this.locator = null;
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        Text textNode = this.document.createTextNode(new String(characters, start, length));
        this.element.appendChild(textNode);
        this.saveLocation();
    }

    public void comment(char[] characters, int start, int length) throws SAXException {
        Comment commentNode = this.document.createComment(new String(characters, start, length));
        if (this.element == null) {
            this.document.appendChild(commentNode);
        } else {
            this.element.appendChild(commentNode);
        }
        this.saveLocation();
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startDTD(String name, String publicId, String systemId) {
    }

    public void endDTD() {
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void processingInstruction(String target, String data) {
        ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(target, data);
        if (this.stack.isEmpty()) {
            this.document.appendChild(processingInstruction);
        } else {
            this.element.appendChild(processingInstruction);
        }
    }

    protected void fatalError(IOException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_IOError_message", new Object[]{exception.getLocalizedMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    protected void fatalError(ParserConfigurationException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getLocalizedMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void fatalError(SAXException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void fatalError(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void error(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void warning(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.WARNING_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    protected void saveLocation() {
        this.line = this.locator.getLineNumber();
        this.column = this.locator.getColumnNumber();
        if (this.column == -1) {
            this.column = 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        void var3_3;
        InputSource inputSource;
        if ("-//W3C//DTD XMLSCHEMA 200102//EN".equalsIgnoreCase(publicId)) {
            inputSource = new InputSource(XSDPlugin.INSTANCE.getBaseURL() + "cache/www.w3.org/2001/XMLSchema.dtd");
            inputSource.setPublicId(publicId);
        } else if (systemId != null && systemId.startsWith("file://bundleentry:")) {
            inputSource = new InputSource(systemId.substring(7));
            inputSource.setPublicId(publicId);
        } else {
            try {
                inputSource = super.resolveEntity(publicId, systemId);
            }
            catch (IOException exception) {
                throw new SAXException(exception);
            }
        }
        return var3_3;
    }
}

