/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class VersionHashMap {
    private HashMap internal = new HashMap();

    Object put(VersionSupplier versionSupplier) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(versionSupplier.getName());
        if (existing == null) {
            VersionSupplier[] vss = new VersionSupplier[]{versionSupplier};
            this.internal.put(versionSupplier.getName(), vss);
        } else {
            for (int i2 = 0; i2 < existing.length; ++i2) {
                VersionSupplier e2 = existing[i2];
                if (e2 == versionSupplier) {
                    return e2;
                }
                if (versionSupplier.getBundle().isResolved() && !e2.getBundle().isResolved()) {
                    this.internal.put(versionSupplier.getName(), this.add(i2, versionSupplier, existing));
                    return null;
                }
                if (versionSupplier.getBundle().isResolved() != e2.getBundle().isResolved()) continue;
                if (versionSupplier.getVersion().compareTo(e2.getVersion()) > 0) {
                    this.internal.put(versionSupplier.getName(), this.add(i2, versionSupplier, existing));
                    return null;
                }
                if (!e2.getVersion().equals(versionSupplier.getVersion()) || versionSupplier.getBundle().getBundleId() >= e2.getBundle().getBundleId()) continue;
                this.internal.put(versionSupplier.getName(), this.add(i2, versionSupplier, existing));
                return e2;
            }
            this.internal.put(versionSupplier.getName(), this.add(existing.length, versionSupplier, existing));
        }
        return null;
    }

    void put(VersionSupplier[] versionSuppliers) {
        for (int i2 = 0; i2 < versionSuppliers.length; ++i2) {
            this.put(versionSuppliers[i2]);
        }
    }

    private VersionSupplier[] add(int index, VersionSupplier versionSupplier, VersionSupplier[] existing) {
        int i2;
        VersionSupplier[] newVS = new VersionSupplier[existing.length + 1];
        for (i2 = 0; i2 < index; ++i2) {
            newVS[i2] = existing[i2];
        }
        newVS[index] = versionSupplier;
        for (i2 = index + 1; i2 < newVS.length; ++i2) {
            newVS[i2] = existing[i2 - 1];
        }
        return newVS;
    }

    VersionSupplier[] getArray(String supplierName) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(supplierName);
        if (existing != null) {
            return existing;
        }
        return new VersionSupplier[0];
    }

    boolean contains(VersionSupplier vs) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(vs.getName());
        if (existing == null) {
            return false;
        }
        for (int i2 = 0; i2 < existing.length; ++i2) {
            if (existing[i2] != vs) continue;
            return true;
        }
        return false;
    }

    private void remove(VersionSupplier[] existing, String name, int index) {
        if (existing.length == 1) {
            this.internal.remove(name);
        } else {
            int i2;
            VersionSupplier[] newVS = new VersionSupplier[existing.length - 1];
            for (i2 = 0; i2 < index; ++i2) {
                newVS[i2] = existing[i2];
            }
            for (i2 = index + 1; i2 < existing.length; ++i2) {
                newVS[i2 - 1] = existing[i2];
            }
            this.internal.put(name, newVS);
        }
    }

    Object remove(VersionSupplier toBeRemoved) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(toBeRemoved.getName());
        if (existing != null) {
            for (int i2 = 0; i2 < existing.length; ++i2) {
                if (toBeRemoved != existing[i2]) continue;
                this.remove(existing, toBeRemoved.getName(), i2);
                return toBeRemoved;
            }
        }
        return null;
    }

    void remove(VersionSupplier[] versionSuppliers) {
        for (int i2 = 0; i2 < versionSuppliers.length; ++i2) {
            this.remove(versionSuppliers[i2]);
        }
    }

    void reorder() {
        Iterator it = this.internal.values().iterator();
        while (it.hasNext()) {
            int i2;
            ArrayList<VersionSupplier> toBeReordered = new ArrayList<VersionSupplier>();
            VersionSupplier[] existing = (VersionSupplier[])it.next();
            if (existing == null || existing.length <= 1) continue;
            VersionSupplier vs1 = existing[0];
            for (i2 = 1; i2 < existing.length; ++i2) {
                int versionDiff;
                VersionSupplier vs2 = existing[i2];
                BundleDescription b1 = vs1.getBundle();
                BundleDescription b2 = vs2.getBundle();
                if (b2.isResolved() && !b1.isResolved()) {
                    toBeReordered.add(vs2);
                } else if (b2.isResolved() == b1.isResolved() && ((versionDiff = vs2.getVersion().compareTo(vs1.getVersion())) > 0 || b2.getBundleId() < b1.getBundleId() && versionDiff == 0)) {
                    toBeReordered.add(vs2);
                }
                vs1 = vs2;
            }
            for (i2 = 0; i2 < toBeReordered.size(); ++i2) {
                VersionSupplier vs = (VersionSupplier)toBeReordered.get(i2);
                this.remove(vs);
                this.put(vs);
            }
        }
    }
}

