/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.Version;

public class ResolverBundle
implements VersionSupplier {
    public static final int UNRESOLVED = 0;
    public static final int RESOLVING = 1;
    public static final int RESOLVED = 2;
    private BundleDescription bundle;
    private Long bundleID;
    private BundleConstraint host;
    private ResolverImport[] imports;
    private ResolverExport[] exports;
    private BundleConstraint[] requires;
    private ArrayList fragments;
    private HashMap fragmentExports;
    private HashMap fragmentImports;
    private HashMap fragmentRequires;
    private boolean resolvable = true;
    private int state = 0;
    private ArrayList cyclicDependencies = new ArrayList();
    private ResolverImpl resolver;
    private boolean newFragmentExports;

    ResolverBundle(BundleDescription bundle, ResolverImpl resolver) {
        this.bundle = bundle;
        this.bundleID = new Long(bundle.getBundleId());
        this.resolver = resolver;
        this.initialize(bundle.isResolved());
    }

    void initialize(boolean useSelectedExports) {
        if (this.bundle.getHost() != null) {
            this.host = new BundleConstraint(this, this.bundle.getHost());
            this.exports = new ResolverExport[0];
            this.imports = new ResolverImport[0];
            this.requires = new BundleConstraint[0];
            return;
        }
        ImportPackageSpecification[] actualImports = this.bundle.getImportPackages();
        ArrayList<ResolverImport> importList = new ArrayList<ResolverImport>(actualImports.length);
        for (int i2 = actualImports.length - 1; i2 >= 0; --i2) {
            if ("optional".equals(actualImports[i2].getDirective("resolution"))) {
                importList.add(new ResolverImport(this, actualImports[i2]));
                continue;
            }
            importList.add(0, new ResolverImport(this, actualImports[i2]));
        }
        this.imports = importList.toArray(new ResolverImport[importList.size()]);
        ExportPackageDescription[] actualExports = useSelectedExports ? this.bundle.getSelectedExports() : this.bundle.getExportPackages();
        this.exports = new ResolverExport[actualExports.length];
        for (int i3 = 0; i3 < actualExports.length; ++i3) {
            this.exports[i3] = new ResolverExport(this, actualExports[i3]);
        }
        BundleSpecification[] actualRequires = this.bundle.getRequiredBundles();
        this.requires = new BundleConstraint[actualRequires.length];
        for (int i4 = 0; i4 < this.requires.length; ++i4) {
            this.requires[i4] = new BundleConstraint(this, actualRequires[i4]);
        }
        this.fragments = null;
        this.fragmentExports = null;
        this.fragmentImports = null;
        this.fragmentRequires = null;
    }

    boolean isExported(ResolverExport exp) {
        ResolverExport[] exports = this.getExportPackages();
        for (int i2 = 0; i2 < exports.length; ++i2) {
            if (exp != exports[i2]) continue;
            return true;
        }
        return false;
    }

    ResolverImport getImport(ResolverExport exp) {
        ResolverImport[] imports = this.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            if (!exp.getName().equals(imports[i2].getName())) continue;
            return imports[i2];
        }
        return null;
    }

    ResolverExport getExport(ResolverImport imp) {
        ResolverExport[] exports = this.getExportPackages();
        for (int i2 = 0; i2 < exports.length; ++i2) {
            if (!imp.getName().equals(exports[i2].getName()) || !exports[i2].getExportPackageDescription().isRoot()) continue;
            return exports[i2];
        }
        return null;
    }

    ResolverExport getExport(String name) {
        ResolverExport[] exports = this.getExportPackages();
        for (int i2 = 0; i2 < exports.length; ++i2) {
            if (!name.equals(exports[i2].getName())) continue;
            return exports[i2];
        }
        return null;
    }

    boolean isFullyWired() {
        if (this.host != null && this.host.foundMatchingBundles()) {
            return false;
        }
        ResolverImport[] imports = this.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            if (imports[i2].getMatchingExport() != null || imports[i2].isOptional() || imports[i2].isDynamic()) continue;
            return false;
        }
        BundleConstraint[] requires = this.getRequires();
        for (int i3 = 0; i3 < requires.length; ++i3) {
            if (requires[i3].getMatchingBundle() != null || requires[i3].isOptional()) continue;
            return false;
        }
        return true;
    }

    void clearWires() {
        ResolverImport[] allImports = this.getImportPackages();
        for (int i2 = 0; i2 < allImports.length; ++i2) {
            allImports[i2].setMatchingExport(null);
        }
        if (this.host != null) {
            this.host.removeAllMatchingBundles();
        }
        BundleConstraint[] allRequires = this.getRequires();
        for (int i3 = 0; i3 < allRequires.length; ++i3) {
            allRequires[i3].setMatchingBundle(null);
        }
    }

    boolean isResolved() {
        return this.getState() == 2;
    }

    boolean isFragment() {
        return this.host != null;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    ResolverImport[] getImportPackages() {
        if (this.isFragment()) {
            return new ResolverImport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.imports;
        }
        ArrayList<ResolverImport> resultList = new ArrayList<ResolverImport>(this.imports.length);
        for (int i2 = 0; i2 < this.imports.length; ++i2) {
            resultList.add(this.imports[i2]);
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragImports = (ArrayList)this.fragmentImports.get(fragment.bundleID);
            if (fragImports == null) continue;
            resultList.addAll(fragImports);
        }
        return resultList.toArray(new ResolverImport[resultList.size()]);
    }

    ResolverExport[] getExportPackages() {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.exports;
        }
        ArrayList<ResolverExport> resultList = new ArrayList<ResolverExport>(this.exports.length);
        for (int i2 = 0; i2 < this.exports.length; ++i2) {
            resultList.add(this.exports[i2]);
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragExports = (ArrayList)this.fragmentExports.get(fragment.bundleID);
            if (fragExports == null) continue;
            resultList.addAll(fragExports);
        }
        return resultList.toArray(new ResolverExport[resultList.size()]);
    }

    ResolverExport[] getSelectedExports() {
        ResolverExport[] exports = this.getExportPackages();
        ArrayList<ResolverExport> removedList = null;
        for (int i2 = 0; i2 < exports.length; ++i2) {
            ResolverImport imp = this.getImport(exports[i2].getName());
            if (imp == null || imp.getMatchingExport() == exports[i2] || !exports[i2].getExportPackageDescription().isRoot()) continue;
            if (removedList == null) {
                removedList = new ArrayList<ResolverExport>(1);
            }
            removedList.add(exports[i2]);
        }
        if (removedList == null) {
            return exports;
        }
        ResolverExport[] selectedExports = new ResolverExport[exports.length - removedList.size()];
        ResolverExport[] removedExports = removedList.toArray(new ResolverExport[removedList.size()]);
        int index = 0;
        for (int i3 = 0; i3 < exports.length; ++i3) {
            boolean removed = false;
            for (int j2 = 0; j2 < removedExports.length; ++j2) {
                if (exports[i3] != removedExports[j2]) continue;
                removed = true;
                break;
            }
            if (removed) continue;
            selectedExports[index] = exports[i3];
            ++index;
        }
        return selectedExports;
    }

    BundleConstraint getHost() {
        return this.host;
    }

    BundleConstraint[] getRequires() {
        if (this.isFragment()) {
            return new BundleConstraint[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.requires;
        }
        ArrayList<BundleConstraint> resultList = new ArrayList<BundleConstraint>(this.requires.length);
        for (int i2 = 0; i2 < this.requires.length; ++i2) {
            resultList.add(this.requires[i2]);
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragRequires = (ArrayList)this.fragmentRequires.get(fragment.bundleID);
            if (fragRequires == null) continue;
            resultList.addAll(fragRequires);
        }
        return resultList.toArray(new BundleConstraint[resultList.size()]);
    }

    BundleConstraint getRequire(String name) {
        BundleConstraint[] requires = this.getRequires();
        for (int i2 = 0; i2 < requires.length; ++i2) {
            if (!requires[i2].getVersionConstraint().getName().equals(name)) continue;
            return requires[i2];
        }
        return null;
    }

    boolean isDependentOnCycle() {
        return this.cyclicDependencies.size() > 0;
    }

    void recordCyclicDependency(ResolverBundle dependentOn) {
        if (!this.cyclicDependencies.contains(dependentOn)) {
            this.cyclicDependencies.add(dependentOn);
        }
    }

    ArrayList getCyclicDependencies() {
        return this.cyclicDependencies;
    }

    boolean cyclicDependencyResolved(ResolverBundle dependentOn) {
        for (int i2 = 0; i2 < this.cyclicDependencies.size(); ++i2) {
            if (dependentOn != this.cyclicDependencies.get(i2)) continue;
            this.cyclicDependencies.remove(i2);
        }
        return !this.isDependentOnCycle();
    }

    void cyclicDependencyFailed(ResolverBundle dependentOn) {
        this.cyclicDependencies = new ArrayList();
        this.detachAllFragments();
        ResolverImport[] imports = this.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            imports[i2].clearUnresolvableWirings();
        }
    }

    public BundleDescription getBundle() {
        return this.bundle;
    }

    ResolverImport getImport(String name) {
        ResolverImport[] imports = this.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            if (!imports[i2].getName().equals(name)) continue;
            return imports[i2];
        }
        return null;
    }

    public String toString() {
        return "[" + this.bundle + "]";
    }

    public Version getVersion() {
        return this.bundle.getVersion();
    }

    public String getName() {
        return this.bundle.getName();
    }

    private void initFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList(1);
        }
        if (this.fragmentExports == null) {
            this.fragmentExports = new HashMap(1);
        }
        if (this.fragmentImports == null) {
            this.fragmentImports = new HashMap(1);
        }
        if (this.fragmentRequires == null) {
            this.fragmentRequires = new HashMap(1);
        }
    }

    private boolean isImported(String packageName) {
        ResolverImport[] imports = this.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            if (!packageName.equals(imports[i2].getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isExported(String packageName) {
        ResolverExport[] exports = this.getExportPackages();
        for (int i2 = 0; i2 < exports.length; ++i2) {
            if (!packageName.equals(exports[i2].getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isRequired(String bundleName) {
        BundleConstraint[] requires = this.getRequires();
        for (int i2 = 0; i2 < requires.length; ++i2) {
            if (!bundleName.equals(requires[i2].getVersionConstraint().getName())) continue;
            return true;
        }
        return false;
    }

    ResolverExport[] attachFragment(ResolverBundle fragment, boolean addExports) {
        int i2;
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (!this.bundle.attachFragments() || this.isResolved() && !this.bundle.dynamicFragments()) {
            return new ResolverExport[0];
        }
        if (fragment.getHost().getMatchingBundles() != null && !((HostSpecification)fragment.getHost().getVersionConstraint()).isMultiHost()) {
            return new ResolverExport[0];
        }
        ImportPackageSpecification[] newImports = fragment.getBundle().getImportPackages();
        BundleSpecification[] newRequires = fragment.getBundle().getRequiredBundles();
        ExportPackageDescription[] newExports = fragment.getBundle().getExportPackages();
        if (this.constraintsConflict(newImports, newRequires)) {
            return new ResolverExport[0];
        }
        if (this.isResolved() && newExports.length > 0) {
            fragment.setNewFragmentExports(true);
        }
        this.initFragments();
        if (this.fragments.contains(fragment)) {
            return new ResolverExport[0];
        }
        this.fragments.add(fragment);
        fragment.getHost().addMatchingBundle(this);
        if (newImports.length > 0) {
            ArrayList<ResolverImport> hostImports = new ArrayList<ResolverImport>(newImports.length);
            for (i2 = 0; i2 < newImports.length; ++i2) {
                if (this.isImported(newImports[i2].getName())) continue;
                hostImports.add(new ResolverImport(this, newImports[i2]));
            }
            this.fragmentImports.put(fragment.bundleID, hostImports);
        }
        if (newRequires.length > 0) {
            ArrayList<BundleConstraint> hostRequires = new ArrayList<BundleConstraint>(newRequires.length);
            for (i2 = 0; i2 < newRequires.length; ++i2) {
                if (this.isRequired(newRequires[i2].getName())) continue;
                hostRequires.add(new BundleConstraint(this, newRequires[i2]));
            }
            this.fragmentRequires.put(fragment.bundleID, hostRequires);
        }
        ArrayList<ResolverExport> hostExports = new ArrayList<ResolverExport>(newExports.length);
        if (newExports.length > 0 && addExports) {
            StateObjectFactory factory = this.resolver.getState().getFactory();
            for (int i3 = 0; i3 < newExports.length; ++i3) {
                if (this.isExported(newExports[i3].getName())) continue;
                ExportPackageDescription hostExport = factory.createExportPackageDescription(newExports[i3].getName(), newExports[i3].getVersion(), newExports[i3].getDirectives(), newExports[i3].getAttributes(), newExports[i3].isRoot(), this.bundle);
                hostExports.add(new ResolverExport(this, hostExport));
            }
            this.fragmentExports.put(fragment.bundleID, hostExports);
        }
        return hostExports.toArray(new ResolverExport[hostExports.size()]);
    }

    private boolean constraintsConflict(ImportPackageSpecification[] newImports, BundleSpecification[] newRequires) {
        int i2;
        for (i2 = 0; i2 < newImports.length; ++i2) {
            ResolverImport importPkg = this.getImport(newImports[i2].getName());
            if (importPkg == null && this.isResolved()) {
                return true;
            }
            if (importPkg == null || newImports[i2].getVersionRange().equals(importPkg.getImportPackageSpecification().getVersionRange())) continue;
            return true;
        }
        for (i2 = 0; i2 < newRequires.length; ++i2) {
            BundleConstraint constraint = this.getRequire(newRequires[i2].getName());
            if (constraint == null && this.isResolved()) {
                return true;
            }
            if (constraint == null || newRequires[i2].getVersionRange().equals(constraint.getVersionConstraint().getVersionRange())) continue;
            return true;
        }
        return false;
    }

    private void setNewFragmentExports(boolean newFragmentExports) {
        this.newFragmentExports = newFragmentExports;
    }

    boolean isNewFragmentExports() {
        return this.newFragmentExports;
    }

    ResolverExport[] detachFragment(ResolverBundle fragment) {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        this.initFragments();
        if (!this.fragments.remove(fragment)) {
            return new ResolverExport[0];
        }
        fragment.getHost().removeMatchingBundle(this);
        this.fragmentImports.remove(fragment.bundleID);
        this.fragmentRequires.remove(fragment.bundleID);
        ArrayList removedExports = (ArrayList)this.fragmentExports.remove(fragment.bundleID);
        return removedExports == null ? new ResolverExport[]{} : removedExports.toArray(new ResolverExport[removedExports.size()]);
    }

    void detachAllFragments() {
        if (this.fragments == null) {
            return;
        }
        ResolverBundle[] allFragments = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
        for (int i2 = 0; i2 < allFragments.length; ++i2) {
            this.detachFragment(allFragments[i2]);
        }
    }

    boolean isDependentOnUnresolvedFragment(ResolverBundle dependent) {
        ResolverImport[] imports = dependent.getImportPackages();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            ResolverExport exp = imports[i2].getMatchingExport();
            if (exp == null || exp.getExporter() != this || this.isExported(exp)) continue;
            return true;
        }
        return false;
    }

    boolean isResolvable() {
        return this.resolvable;
    }

    void setResolvable(boolean resolvable) {
        this.resolvable = resolvable;
    }

    void addExport(ResolverExport re) {
        ResolverExport[] newExports = new ResolverExport[this.exports.length + 1];
        for (int i2 = 0; i2 < this.exports.length; ++i2) {
            newExports[i2] = this.exports[i2];
        }
        newExports[this.exports.length] = re;
        this.exports = newExports;
    }

    ResolverImpl getResolver() {
        return this.resolver;
    }
}

