/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.protocol.ProtocolActivator;
import org.eclipse.osgi.framework.internal.protocol.URLStreamHandlerProxy;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class StreamHandlerFactory
implements URLStreamHandlerFactory {
    static final SecureAction secureAction = new SecureAction();
    protected BundleContext context;
    protected FrameworkAdaptor adaptor;
    private ServiceTracker handlerTracker;
    protected static final String URLSTREAMHANDLERCLASS = "org.osgi.service.url.URLStreamHandlerService";
    protected static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    protected static final String INTERNAL_PROTOCOL_HANDLER_PKG = "org.eclipse.osgi.framework.internal.protocol.";
    private Hashtable proxies;

    public StreamHandlerFactory(BundleContext context, FrameworkAdaptor adaptor) {
        this.context = context;
        this.adaptor = adaptor;
        this.proxies = new Hashtable(15);
        this.handlerTracker = new ServiceTracker(context, URLSTREAMHANDLERCLASS, null);
        this.handlerTracker.open();
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        String builtInHandlers = System.getProperty(PROTOCOL_HANDLER_PKGS);
        Class clazz = null;
        if (builtInHandlers != null) {
            StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
            while (tok.hasMoreElements()) {
                StringBuffer name = new StringBuffer();
                name.append(tok.nextToken());
                name.append(".");
                name.append(protocol);
                name.append(".Handler");
                try {
                    clazz = secureAction.forName(name.toString());
                    if (clazz == null) continue;
                    return null;
                }
                catch (ClassNotFoundException ex) {
                }
            }
        }
        String name = INTERNAL_PROTOCOL_HANDLER_PKG + protocol + ".Handler";
        try {
            clazz = secureAction.forName(name);
        }
        catch (Throwable t2) {
            URLStreamHandlerProxy handler = (URLStreamHandlerProxy)this.proxies.get(protocol);
            if (handler != null) {
                return handler;
            }
            ServiceReference[] serviceReferences = this.handlerTracker.getServiceReferences();
            if (serviceReferences != null) {
                for (int i2 = 0; i2 < serviceReferences.length; ++i2) {
                    Object prop = serviceReferences[i2].getProperty("url.handler.protocol");
                    if (prop == null || !(prop instanceof String[])) continue;
                    String[] protocols = (String[])prop;
                    for (int j2 = 0; j2 < protocols.length; ++j2) {
                        if (!protocols[j2].equals(protocol)) continue;
                        handler = new URLStreamHandlerProxy(protocol, serviceReferences[i2], this.context);
                        this.proxies.put(protocol, handler);
                        return handler;
                    }
                }
            }
            return null;
        }
        if (clazz == null) {
            return null;
        }
        try {
            URLStreamHandler handler = (URLStreamHandler)clazz.newInstance();
            if (handler instanceof ProtocolActivator) {
                ((ProtocolActivator)((Object)handler)).start(this.context, this.adaptor);
            }
            return handler;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

