/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.net.ContentHandler;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.internal.protocol.ContentHandlerProxy;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ContentHandlerFactory
implements java.net.ContentHandlerFactory {
    private ServiceTracker contentHandlerTracker;
    private BundleContext context;
    private static final String contentHandlerClazz = "java.net.ContentHandler";
    private static final String CONTENT_HANDLER_PKGS = "java.content.handler.pkgs";
    private static final String DEFAULT_VM_CONTENT_HANDLERS = "sun.net.www.content";
    private Hashtable proxies;

    public ContentHandlerFactory(BundleContext context) {
        this.context = context;
        this.proxies = new Hashtable(5);
        this.contentHandlerTracker = new ServiceTracker(context, contentHandlerClazz, null);
        this.contentHandlerTracker.open();
    }

    public ContentHandler createContentHandler(String contentType) {
        ContentHandlerProxy proxy;
        String builtInHandlers = System.getProperty(CONTENT_HANDLER_PKGS);
        builtInHandlers = builtInHandlers == null ? DEFAULT_VM_CONTENT_HANDLERS : "sun.net.www.content|" + builtInHandlers;
        Class clazz = null;
        if (builtInHandlers != null) {
            String convertedContentType = contentType.replace('.', '_');
            convertedContentType = convertedContentType.replace('/', '.');
            convertedContentType = convertedContentType.replace('-', '_');
            StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
            while (tok.hasMoreElements()) {
                StringBuffer name = new StringBuffer();
                name.append(tok.nextToken());
                name.append(".");
                name.append(convertedContentType);
                try {
                    clazz = StreamHandlerFactory.secureAction.forName(name.toString());
                    if (clazz == null) continue;
                    return null;
                }
                catch (ClassNotFoundException ex) {
                }
            }
        }
        if ((proxy = (ContentHandlerProxy)this.proxies.get(contentType)) != null) {
            return proxy;
        }
        ServiceReference[] serviceReferences = this.contentHandlerTracker.getServiceReferences();
        if (serviceReferences != null) {
            for (int i2 = 0; i2 < serviceReferences.length; ++i2) {
                Object obj = serviceReferences[i2].getProperty("url.content.mimetype");
                if (obj == null || !(obj instanceof String[])) continue;
                String[] contentHandler = (String[])obj;
                for (int j2 = 0; j2 < contentHandler.length; ++j2) {
                    if (!contentHandler[j2].equals(contentType)) continue;
                    proxy = new ContentHandlerProxy(contentType, serviceReferences[i2], this.context);
                    this.proxies.put(contentType, proxy);
                    return proxy;
                }
            }
        }
        proxy = new ContentHandlerProxy(contentType, null, this.context);
        this.proxies.put(contentType, proxy);
        return proxy;
    }
}

