/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

public class Tokenizer {
    protected char[] value;
    protected int max;
    protected int cursor;

    public Tokenizer(String value) {
        this.value = value.toCharArray();
        this.max = this.value.length;
        this.cursor = 0;
    }

    private void skipWhiteSpace() {
        char c2;
        int cur;
        char[] val = this.value;
        for (cur = this.cursor; cur < this.max && ((c2 = val[cur]) == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r'); ++cur) {
        }
        this.cursor = cur;
    }

    public String getToken(String terminals) {
        char c2;
        int cur;
        this.skipWhiteSpace();
        char[] val = this.value;
        int begin = cur = this.cursor;
        while (cur < this.max && terminals.indexOf(c2 = val[cur]) == -1) {
            ++cur;
        }
        this.cursor = cur;
        int count = cur - begin;
        if (count > 0) {
            this.skipWhiteSpace();
            while (count > 0 && (val[begin + count - 1] == ' ' || val[begin + count - 1] == '\t')) {
                --count;
            }
            return new String(val, begin, count);
        }
        return null;
    }

    public String getString(String terminals) {
        int cur;
        this.skipWhiteSpace();
        char[] val = this.value;
        if (cur < this.max) {
            if (val[cur] == '\"') {
                char c2 = '\u0000';
                int begin = ++cur;
                while (cur < this.max && (c2 = val[cur]) != '\"') {
                    ++cur;
                }
                int count = cur - begin;
                if (c2 == '\"') {
                    ++cur;
                }
                this.cursor = cur;
                if (count > 0) {
                    this.skipWhiteSpace();
                    return new String(val, begin, count);
                }
            } else {
                int begin = cur;
                for (cur = this.cursor; cur < this.max; ++cur) {
                    char c3 = val[cur];
                    if (c3 == '\"') {
                        cur += this.skipQuotedString(val, cur);
                        continue;
                    }
                    if (terminals.indexOf(c3) != -1) break;
                }
                this.cursor = cur;
                int count = cur - begin;
                if (count > 0) {
                    this.skipWhiteSpace();
                    while (count > 0 && (val[begin + count - 1] == ' ' || val[begin + count - 1] == '\t')) {
                        --count;
                    }
                    return new String(val, begin, count);
                }
            }
        }
        return null;
    }

    private int skipQuotedString(char[] val, int cur) {
        char c2 = '\u0000';
        int begin = ++cur;
        while (cur < this.max && (c2 = val[cur]) != '\"') {
            ++cur;
        }
        int count = cur - begin;
        if (c2 == '\"') {
            ++cur;
        }
        this.cursor = cur;
        if (count > 0) {
            this.skipWhiteSpace();
        }
        return count;
    }

    public char getChar() {
        int cur = this.cursor;
        if (cur < this.max) {
            this.cursor = cur + 1;
            return this.value[cur];
        }
        return '\u0000';
    }

    public boolean hasMoreTokens() {
        return this.cursor < this.max;
    }
}

