/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;

public abstract class PackageSource
implements KeyedElement {
    protected String id;

    public PackageSource(String id) {
        this.id = id.intern();
    }

    public String getId() {
        return this.id;
    }

    public abstract SingleSourcePackage[] getSuppliers();

    public boolean compare(KeyedElement other) {
        return this.id.equals(((PackageSource)other).getId());
    }

    public int getKeyHashCode() {
        return this.id.hashCode();
    }

    public Object getKey() {
        return this.id;
    }

    public boolean isNullSource() {
        return false;
    }

    public boolean isFriend(String symbolicName) {
        return true;
    }

    public abstract Class loadClass(String var1);

    public abstract URL getResource(String var1);

    public abstract Enumeration getResources(String var1) throws IOException;

    public boolean hasCommonSource(PackageSource other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        SingleSourcePackage[] suppliers1 = this.getSuppliers();
        SingleSourcePackage[] suppliers2 = other.getSuppliers();
        if (suppliers1 == null || suppliers2 == null) {
            return false;
        }
        for (int i2 = 0; i2 < suppliers1.length; ++i2) {
            boolean found = false;
            for (int j2 = 0; j2 < suppliers2.length; ++j2) {
                if (!suppliers2[j2].equals(suppliers1[i2])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

