/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.AliasMapper;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.BundleNativeCode;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.BundleSource;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.MessageResourceBundle;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.PermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.SystemBundle;
import org.eclipse.osgi.framework.internal.protocol.ContentHandlerFactory;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class Framework
implements EventDispatcher,
EventPublisher {
    protected FrameworkAdaptor adaptor;
    protected Properties properties;
    protected boolean active;
    protected BundleRepository bundles;
    protected PackageAdminImpl packageAdmin;
    protected PermissionAdminImpl permissionAdmin;
    protected StartLevelManager startLevelManager;
    protected ServiceRegistry serviceRegistry;
    protected long serviceid;
    private String vmProfile;
    protected EventListeners bundleEvent;
    protected static final int BUNDLEEVENT = 1;
    protected EventListeners bundleEventSync;
    protected static final int BUNDLEEVENTSYNC = 2;
    protected EventListeners serviceEvent;
    protected static final int SERVICEEVENT = 3;
    protected EventListeners frameworkEvent;
    protected static final int FRAMEWORKEVENT = 4;
    protected static final int BATCHEVENT_BEGIN = -2147483647;
    protected static final int BATCHEVENT_END = Integer.MIN_VALUE;
    protected EventManager eventManager;
    protected Hashtable installLock;
    protected SystemBundle systemBundle;
    String[] bootDelegation;
    String[] bootDelegationStems;
    boolean bootDelegateAll = false;
    boolean contextBootDelegation = "true".equals(System.getProperty("osgi.context.bootdelegation", "true"));
    protected static AliasMapper aliasMapper = new AliasMapper();
    protected ConditionalPermissionAdminImpl condPermAdmin;
    SecureAction secureAction = new SecureAction();

    public Framework(FrameworkAdaptor adaptor) {
        this.initialize(adaptor);
    }

    protected void initialize(FrameworkAdaptor adaptor) {
        BundleData[] bundleDatas;
        if (Profile.STARTUP) {
            Profile.logEnter("Framework.initialze()", null);
        }
        long start = System.currentTimeMillis();
        this.adaptor = adaptor;
        this.active = false;
        this.installSecurityManager();
        if (Debug.DEBUG_SECURITY) {
            Debug.println("SecurityManager: " + System.getSecurityManager());
            Debug.println("ProtectionDomain of Framework.class: \n" + this.getClass().getProtectionDomain());
        }
        MessageResourceBundle.setAdaptor(adaptor);
        adaptor.initialize(this);
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter initialized");
        }
        try {
            adaptor.initializeStorage();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2.getMessage());
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "adapter storage initialized");
        }
        this.initializeProperties(adaptor.getProperties());
        this.packageAdmin = new PackageAdminImpl(this);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                this.permissionAdmin = new PermissionAdminImpl(this, adaptor.getPermissionStorage());
            }
            catch (IOException e3) {
                e3.printStackTrace();
                throw new RuntimeException(e3.getMessage());
            }
            try {
                this.condPermAdmin = new ConditionalPermissionAdminImpl(this, adaptor.getPermissionStorage());
            }
            catch (IOException e4) {
                e4.printStackTrace();
                throw new RuntimeException(e4.getMessage());
            }
        }
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done init props & new PermissionAdminImpl");
        }
        this.startLevelManager = new StartLevelManager(this);
        this.eventManager = new EventManager("Framework Event Dispatcher");
        this.bundleEvent = new EventListeners();
        this.bundleEventSync = new EventListeners();
        this.serviceEvent = new EventListeners();
        this.frameworkEvent = new EventListeners();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new EventManager");
        }
        this.serviceid = 1L;
        this.serviceRegistry = adaptor.getServiceRegistry();
        this.installLock = new Hashtable(10);
        this.createSystemBundle();
        this.loadVMProfile();
        this.setBootDelegation();
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done createSystemBundle");
        }
        URL.setURLStreamHandlerFactory(new StreamHandlerFactory(this.systemBundle.context, adaptor));
        URLConnection.setContentHandlerFactory(new ContentHandlerFactory(this.systemBundle.context));
        if (Profile.STARTUP) {
            Profile.logTime("Framework.initialze()", "done new URLStream/Content HandlerFactory");
        }
        this.bundles = new BundleRepository((bundleDatas = adaptor.getInstalledBundles()) == null ? 10 : bundleDatas.length + 1, this.packageAdmin);
        this.bundles.add(this.systemBundle);
        if (bundleDatas != null) {
            for (int i2 = 0; i2 < bundleDatas.length; ++i2) {
                try {
                    AbstractBundle bundle = AbstractBundle.createBundle(bundleDatas[i2], this);
                    this.bundles.add(bundle);
                    continue;
                }
                catch (BundleException be) {
                    this.publishFrameworkEvent(2, this.systemBundle, be);
                }
            }
        }
        if (Debug.DEBUG_GENERAL) {
            System.out.println("Initialize the framework: " + (System.currentTimeMillis() - start));
        }
        if (Profile.STARTUP) {
            Profile.logExit("Framework.initialize()");
        }
    }

    private void createSystemBundle() {
        try {
            this.systemBundle = new SystemBundle(this);
        }
        catch (BundleException e2) {
            e2.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, e2.getMessage()));
        }
    }

    protected void initializeProperties(Properties adaptorProperties) {
        this.properties = System.getProperties();
        Enumeration<?> enumKeys = adaptorProperties.propertyNames();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            if (this.properties.getProperty(key) != null) continue;
            this.properties.put(key, adaptorProperties.getProperty(key));
        }
        this.properties.put("org.osgi.framework.vendor", "Eclipse");
        this.properties.put("org.osgi.framework.version", "1.3");
        this.properties.put("osgi.framework.version", "3.0.0");
        String value = this.properties.getProperty("org.osgi.framework.processor");
        if (value == null && (value = this.properties.getProperty("os.arch")) != null) {
            this.properties.put("org.osgi.framework.processor", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.os.name")) == null) {
            value = this.properties.getProperty("os.name");
            try {
                String canonicalValue = (String)aliasMapper.aliasOSName(value);
                if (canonicalValue != null) {
                    value = canonicalValue;
                }
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            if (value != null) {
                this.properties.put("org.osgi.framework.os.name", value);
            }
        }
        if ((value = this.properties.getProperty("org.osgi.framework.os.version")) == null && (value = this.properties.getProperty("os.version")) != null) {
            int space = value.indexOf(32);
            if (space > 0) {
                value = value.substring(0, space);
            }
            this.properties.put("org.osgi.framework.os.version", value);
        }
        if ((value = this.properties.getProperty("org.osgi.framework.language")) == null && (value = this.properties.getProperty("user.language")) != null) {
            this.properties.put("org.osgi.framework.language", value);
            StringTokenizer tokenizer = new StringTokenizer(value, "_");
            int segments = tokenizer.countTokens();
            try {
                switch (segments) {
                    case 2: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                        break;
                    }
                    case 3: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                    }
                }
            }
            catch (NoSuchElementException e2) {
                // empty catch block
            }
        }
        this.setExecutionEnvironment();
    }

    private void setExecutionEnvironment() {
        String value = this.properties.getProperty("org.osgi.framework.executionenvironment", "");
        String j2meConfig = this.properties.getProperty("microedition.configuration");
        String j2meProfile = this.properties.getProperty("microedition.profiles");
        StringBuffer ee = new StringBuffer(value);
        if (j2meConfig != null && j2meConfig.length() > 0 && j2meProfile != null && j2meProfile.length() > 0) {
            this.vmProfile = j2meConfig + '_' + j2meProfile;
            int ic = value.indexOf(j2meConfig);
            if (ic < 0 || ic + j2meConfig.length() >= value.length() || value.charAt(ic + j2meConfig.length()) != '/' || !value.startsWith(j2meProfile, ic + j2meConfig.length() + 1)) {
                if (ee.length() > 0) {
                    ee.append(',');
                }
                ee.append(j2meConfig).append('/').append(j2meProfile);
            }
        } else if (value.length() > 0) {
            StringTokenizer st = new StringTokenizer(value, ",");
            this.vmProfile = st.nextToken().replace('/', '_');
        } else {
            String javaSpecVersion = this.properties.getProperty("java.specification.version");
            if (javaSpecVersion != null) {
                StringTokenizer st = new StringTokenizer(javaSpecVersion, " _-");
                javaSpecVersion = st.nextToken();
                this.vmProfile = "J2SE-" + javaSpecVersion;
                int index = value.indexOf(this.vmProfile);
                if (index < 0) {
                    if (ee.length() > 0) {
                        ee.append(',');
                    }
                    ee.append(this.vmProfile);
                }
            }
        }
        this.properties.put("org.osgi.framework.executionenvironment", ee.toString());
    }

    private void setBootDelegation() {
        String bootDelegationProp = this.properties.getProperty("org.osgi.framework.bootdelegation");
        if (bootDelegationProp == null) {
            return;
        }
        if (bootDelegationProp.trim().length() == 0) {
            return;
        }
        String[] bootPackages = ManifestElement.getArrayFromList(bootDelegationProp);
        ArrayList<String> exactMatch = new ArrayList<String>(bootPackages.length);
        ArrayList<String> stemMatch = new ArrayList<String>(bootPackages.length);
        for (int i2 = 0; i2 < bootPackages.length; ++i2) {
            if (bootPackages[i2].equals("*")) {
                this.bootDelegateAll = true;
                return;
            }
            if (bootPackages[i2].endsWith("*")) {
                if (bootPackages[i2].length() <= 2 || !bootPackages[i2].endsWith(".*")) continue;
                stemMatch.add(bootPackages[i2].substring(0, bootPackages[i2].length() - 1));
                continue;
            }
            exactMatch.add(bootPackages[i2]);
        }
        if (exactMatch.size() > 0) {
            this.bootDelegation = exactMatch.toArray(new String[exactMatch.size()]);
        }
        if (stemMatch.size() > 0) {
            this.bootDelegationStems = stemMatch.toArray(new String[stemMatch.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVMProfile() {
        String systemExports;
        InputStream in = this.findVMProfile();
        Properties profileProps = new Properties();
        if (in != null) {
            try {
                profileProps.load(new BufferedInputStream(in));
            }
            catch (IOException e2) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ee) {}
            }
        }
        if ((systemExports = this.properties.getProperty("org.osgi.framework.system.packages")) == null && (systemExports = profileProps.getProperty("org.osgi.framework.system.packages")) != null) {
            this.properties.put("org.osgi.framework.system.packages", systemExports);
        }
        String type = this.properties.getProperty("osgi.java.profile.bootdelegation");
        String profileBootDelegation = profileProps.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(type)) {
            if (profileBootDelegation == null) {
                this.properties.remove("org.osgi.framework.bootdelegation");
            } else {
                this.properties.put("org.osgi.framework.bootdelegation", profileBootDelegation);
            }
        } else if ("none".equals(type)) {
            this.properties.remove("org.osgi.framework.bootdelegation");
        }
    }

    private InputStream findVMProfile() {
        String javaProfile;
        URL url = null;
        String propJavaProfile = System.getProperty("osgi.java.profile");
        if (propJavaProfile != null) {
            try {
                url = new URL(propJavaProfile);
            }
            catch (MalformedURLException e1) {
                // empty catch block
            }
        }
        if (url == null && this.vmProfile != null && (url = this.systemBundle.getEntry(javaProfile = this.vmProfile + ".profile")) == null) {
            url = this.getClass().getResource(javaProfile);
        }
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.active) {
            this.shutdown();
        }
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            for (int i2 = 0; i2 < size; ++i2) {
                AbstractBundle bundle = (AbstractBundle)allBundles.get(i2);
                bundle.close();
            }
            this.bundles.removeAllBundles();
        }
        this.serviceRegistry = null;
        if (this.bundleEvent != null) {
            this.bundleEvent.removeAllListeners();
            this.bundleEvent = null;
        }
        if (this.bundleEventSync != null) {
            this.bundleEventSync.removeAllListeners();
            this.bundleEventSync = null;
        }
        if (this.serviceEvent != null) {
            this.serviceEvent.removeAllListeners();
            this.serviceEvent = null;
        }
        if (this.frameworkEvent != null) {
            this.frameworkEvent.removeAllListeners();
            this.frameworkEvent = null;
        }
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        this.permissionAdmin = null;
        this.condPermAdmin = null;
        this.packageAdmin = null;
        this.adaptor = null;
    }

    public synchronized void launch() {
        if (this.active) {
            return;
        }
        this.active = true;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to launch framework");
        }
        this.systemBundle.resume();
    }

    public synchronized void shutdown() {
        if (!this.active) {
            return;
        }
        this.systemBundle.state = 16;
        try {
            this.adaptor.frameworkStopping(this.systemBundle.getContext());
        }
        catch (Throwable t2) {
            this.publishFrameworkEvent(2, this.systemBundle, t2);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("Trying to shutdown Framework");
        }
        this.systemBundle.suspend();
        try {
            this.adaptor.compactStorage();
        }
        catch (IOException e2) {
            this.publishFrameworkEvent(2, this.systemBundle, e2);
        }
        this.active = false;
    }

    AbstractBundle createAndVerifyBundle(BundleData bundledata) throws BundleException {
        AbstractBundle installedBundle;
        if (bundledata.getSymbolicName() != null && (installedBundle = this.getBundleBySymbolicName(bundledata.getSymbolicName(), bundledata.getVersion())) != null && installedBundle.getBundleId() != bundledata.getBundleID()) {
            throw new BundleException(NLS.bind(Msg.BUNDLE_INSTALL_SAME_UNIQUEID, new Object[]{installedBundle.getSymbolicName(), installedBundle.getVersion().toString(), installedBundle.getLocation()}));
        }
        this.verifyExecutionEnvironment(bundledata.getManifest());
        return AbstractBundle.createBundle(bundledata, this);
    }

    protected boolean verifyExecutionEnvironment(Dictionary manifest) throws BundleException {
        int i2;
        String headerValue = (String)manifest.get("Bundle-RequiredExecutionEnvironment");
        if (headerValue == null) {
            return true;
        }
        ManifestElement[] bundleRequiredEE = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", headerValue);
        if (bundleRequiredEE.length == 0) {
            return true;
        }
        String systemEE = System.getProperty("org.osgi.framework.executionenvironment");
        if (systemEE != null && !systemEE.equals("")) {
            ManifestElement[] systemEEs = ManifestElement.parseHeader("Bundle-RequiredExecutionEnvironment", systemEE);
            for (i2 = 0; i2 < systemEEs.length; ++i2) {
                for (int j2 = 0; j2 < bundleRequiredEE.length; ++j2) {
                    if (!systemEEs[i2].getValue().equals(bundleRequiredEE[j2].getValue())) continue;
                    return true;
                }
            }
        }
        StringBuffer bundleEE = new StringBuffer(25);
        for (i2 = 0; i2 < bundleRequiredEE.length; ++i2) {
            if (i2 > 0) {
                bundleEE.append(",");
            }
            bundleEE.append(bundleRequiredEE[i2].getValue());
        }
        throw new BundleException(NLS.bind(Msg.BUNDLE_INSTALL_REQUIRED_EE_EXCEPTION, bundleEE.toString()));
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    protected String getProperty(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    protected Object setProperty(String key, String value) {
        return this.properties.put(key, value);
    }

    public AbstractBundle installBundle(final String location) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from location: " + location);
        }
        final AccessControlContext callerContext = AccessController.getContext();
        return this.installWorker(location, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                URLConnection source = Framework.this.adaptor.mapLocationToURLConnection(location);
                return Framework.this.installWorkerPrivileged(location, source, callerContext);
            }
        });
    }

    protected AbstractBundle installBundle(final String location, final InputStream in) throws BundleException {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("install from inputstream: " + location + ", " + in);
        }
        final AccessControlContext callerContext = AccessController.getContext();
        return this.installWorker(location, new PrivilegedExceptionAction(){

            public Object run() throws BundleException {
                BundleSource source = new BundleSource(in);
                return Framework.this.installWorkerPrivileged(location, source, callerContext);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AbstractBundle installWorker(String location, PrivilegedExceptionAction action) throws BundleException {
        block16: {
            var3_3 = this.installLock;
            synchronized (var3_3) lbl-1000:
            // 3 sources

            {
                while (true) {
                    bundle = this.getBundleByLocation(location);
                    if (bundle != null) {
                        return bundle;
                    }
                    current = Thread.currentThread();
                    reservation = this.installLock.put(location, current);
                    if (reservation != null) ** break block15
                    // MONITOREXIT @DISABLED, blocks:[5, 11] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    try {
                        bundle = (AbstractBundle)AccessController.doPrivileged(action);
                        this.publishBundleEvent(1, bundle);
                        var4_5 = bundle;
                        var10_9 = null;
                        var11_11 = this.installLock;
                        break block16;
                    }
                    catch (PrivilegedActionException e) {
                        if (e.getException() instanceof RuntimeException == false) throw (BundleException)e.getException();
                        throw (RuntimeException)e.getException();
                    }
                    break;
                }
            }
            catch (Throwable var9_13) {
                var10_10 = null;
                var11_12 = this.installLock;
                synchronized (var11_12) {
                    this.installLock.remove(location);
                    this.installLock.notifyAll();
                    throw var9_13;
                }
            }
            {
                if (current.equals(reservation)) {
                    throw new BundleException(Msg.BUNDLE_INSTALL_RECURSION_EXCEPTION);
                }
                try {
                    this.installLock.wait();
                }
                catch (InterruptedException e) {}
                ** continue;
            }
        }
        synchronized (var11_11) {
            this.installLock.remove(location);
            this.installLock.notifyAll();
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle installWorkerPrivileged(String location, URLConnection source, AccessControlContext callerContext) throws BundleException {
        AbstractBundle bundle;
        BundleOperation storage = this.adaptor.installBundle(location, source);
        try {
            BundleData bundledata = storage.begin();
            bundle = this.createAndVerifyBundle(bundledata);
            try {
                String[] nativepaths = this.selectNativeCode(bundle);
                if (nativepaths != null) {
                    bundledata.installNativeCode(nativepaths);
                }
                bundle.load();
                if (System.getSecurityManager() != null) {
                    boolean extension;
                    boolean bl = extension = (bundledata.getType() & 6) != 0;
                    if (extension) {
                        bundle.hasPermission(new AllPermission());
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                Framework.this.checkAdminPermission(bundle, "lifecycle");
                                if (extension) {
                                    Framework.this.checkAdminPermission(bundle, "extensionLifecycle");
                                }
                                return null;
                            }
                        }, callerContext);
                    }
                    catch (PrivilegedActionException e2) {
                        throw e2.getException();
                    }
                }
                storage.commit(false);
            }
            catch (Throwable error) {
                BundleRepository bundleRepository = this.bundles;
                synchronized (bundleRepository) {
                    bundle.unload();
                }
                bundle.close();
                throw error;
            }
            this.bundles.add(bundle);
        }
        catch (Throwable t2) {
            try {
                storage.undo();
            }
            catch (BundleException ee) {
                this.publishFrameworkEvent(2, this.systemBundle, ee);
            }
            if (t2 instanceof SecurityException) {
                throw (SecurityException)t2;
            }
            if (t2 instanceof BundleException) {
                throw (BundleException)t2;
            }
            throw new BundleException(t2.getMessage(), t2);
        }
        return bundle;
    }

    String[] selectNativeCode(Bundle bundle) throws BundleException {
        Version osversion;
        String headerValue = (String)((AbstractBundle)bundle).getBundleData().getManifest().get("Bundle-NativeCode");
        if (headerValue == null) {
            return null;
        }
        ManifestElement[] elements = ManifestElement.parseHeader("Bundle-NativeCode", headerValue);
        ArrayList<BundleNativeCode> bundleNativeCodes = new ArrayList<BundleNativeCode>(elements.length);
        int length = elements.length;
        boolean optional = false;
        if (elements[length - 1].getValue().equals("*")) {
            optional = true;
            --length;
        }
        String processor = this.getProperty("org.osgi.framework.processor");
        String osname = this.getProperty("org.osgi.framework.os.name");
        try {
            osversion = Version.parseVersion(this.getProperty("org.osgi.framework.os.version"));
        }
        catch (Exception e2) {
            osversion = Version.emptyVersion;
        }
        String language = this.getProperty("org.osgi.framework.language");
        for (int i2 = 0; i2 < length; ++i2) {
            BundleNativeCode bnc = new BundleNativeCode(elements[i2], (AbstractBundle)bundle);
            if (bnc.matchProcessorOSNameFilter(processor, osname) <= 0 || bnc.matchOSVersion(osversion) == null || bnc.matchLanguage(language) <= 0) continue;
            bundleNativeCodes.add(bnc);
        }
        if (bundleNativeCodes.size() == 0) {
            return this.noMatches(optional);
        }
        Iterator iter = bundleNativeCodes.iterator();
        BundleNativeCode highestRanking = (BundleNativeCode)iter.next();
        while (iter.hasNext()) {
            BundleNativeCode bnc = (BundleNativeCode)iter.next();
            if (!this.isBncGreaterThan(bnc, highestRanking, osversion, language)) continue;
            highestRanking = bnc;
        }
        return highestRanking.getPaths();
    }

    private boolean isBncGreaterThan(BundleNativeCode candidate, BundleNativeCode highestRanking, Version version, String language) {
        Version candidateHigh;
        Version currentHigh = highestRanking.matchOSVersion(version);
        if (currentHigh.compareTo(candidateHigh = candidate.matchOSVersion(version)) < 0) {
            return true;
        }
        return highestRanking.matchLanguage(language) < candidate.matchLanguage(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundle(long id) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBundle getBundleBySymbolicName(String symbolicName, Version version) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundle(symbolicName, version);
        }
    }

    protected BundleRepository getBundles() {
        return this.bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getAllBundles() {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            List allBundles = this.bundles.getBundles();
            int size = allBundles.size();
            if (size == 0) {
                return null;
            }
            AbstractBundle[] bundlelist = new AbstractBundle[size];
            allBundles.toArray(bundlelist);
            return bundlelist;
        }
    }

    protected void resumeBundle(AbstractBundle bundle) {
        if (bundle.isActive()) {
            return;
        }
        try {
            int status = bundle.getBundleData().getStatus();
            if ((status & 1) == 0) {
                return;
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to start bundle " + bundle);
            }
            bundle.resume();
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle resume exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, bundle, be);
        }
    }

    protected boolean suspendBundle(AbstractBundle bundle, boolean lock) {
        boolean changed = false;
        if (!bundle.isActive() || bundle.isFragment()) {
            return changed;
        }
        try {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Trying to suspend bundle " + bundle);
            }
            bundle.suspend(lock);
        }
        catch (BundleException be) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Bundle suspend exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException());
            }
            this.publishFrameworkEvent(2, bundle, be);
        }
        if (!bundle.isActive()) {
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle getBundleByLocation(String location) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            final String finalLocation = location;
            return (AbstractBundle)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    List allBundles = Framework.this.bundles.getBundles();
                    int size = allBundles.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        AbstractBundle bundle = (AbstractBundle)allBundles.get(i2);
                        if (!finalLocation.equals(bundle.getLocation())) continue;
                        return bundle;
                    }
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBundle[] getBundleBySymbolicName(String symbolicName) {
        BundleRepository bundleRepository = this.bundles;
        synchronized (bundleRepository) {
            return this.bundles.getBundles(symbolicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceReference[] getServiceReferences(String clazz, String filterstring, BundleContextImpl context, boolean allservices) throws InvalidSyntaxException {
        FilterImpl filter = filterstring == null ? null : new FilterImpl(filterstring);
        ServiceReference[] services = null;
        if (clazz != null) {
            try {
                this.checkGetServicePermission(clazz);
            }
            catch (SecurityException se) {
                return null;
            }
        }
        ServiceRegistry serviceRegistry = this.serviceRegistry;
        synchronized (serviceRegistry) {
            services = this.serviceRegistry.lookupServiceReferences(clazz, filter);
            if (services == null) {
                return null;
            }
            int removed = 0;
            for (int i2 = services.length - 1; i2 >= 0; --i2) {
                ServiceReferenceImpl ref = (ServiceReferenceImpl)services[i2];
                String[] classes = ref.getClasses();
                if (allservices || context.isAssignableTo((ServiceReferenceImpl)services[i2])) {
                    if (clazz != null) continue;
                    try {
                        this.checkGetServicePermission(classes);
                    }
                    catch (SecurityException se) {
                        services[i2] = null;
                        ++removed;
                    }
                    continue;
                }
                services[i2] = null;
                ++removed;
            }
            if (removed > 0) {
                ServiceReference[] temp = services;
                services = new ServiceReference[temp.length - removed];
                for (int i3 = temp.length - 1; i3 >= 0; --i3) {
                    if (temp[i3] == null) {
                        --removed;
                        continue;
                    }
                    services[i3 - removed] = temp[i3];
                }
            }
        }
        return services == null || services.length == 0 ? null : services;
    }

    protected long getNextServiceId() {
        long id = this.serviceid++;
        return id;
    }

    protected File getDataFile(final AbstractBundle bundle, final String filename) {
        return (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundle.getBundleData().getDataFile(filename);
            }
        });
    }

    protected void checkAdminPermission(Bundle bundle, String action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(bundle, action));
        }
    }

    protected void checkRegisterServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            int len = names.length;
            for (int i2 = 0; i2 < len; ++i2) {
                sm.checkPermission(new ServicePermission(names[i2], "register"));
            }
        }
    }

    protected void checkGetServicePermission(String[] names) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SecurityException se = null;
            int len = names.length;
            for (int i2 = 0; i2 < len; ++i2) {
                try {
                    sm.checkPermission(new ServicePermission(names[i2], "get"));
                    return;
                }
                catch (SecurityException e2) {
                    se = e2;
                    continue;
                }
            }
            throw se;
        }
    }

    protected void checkGetServicePermission(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ServicePermission(name, "get"));
        }
    }

    protected void installSecurityManager() {
        SecurityManager sm;
        String securityManager = System.getProperty("java.security.manager");
        if (securityManager != null && (sm = System.getSecurityManager()) == null) {
            if (securityManager.length() < 1) {
                securityManager = "java.lang.SecurityManager";
            }
            try {
                Class<?> clazz = Class.forName(securityManager);
                sm = (SecurityManager)clazz.newInstance();
                if (Debug.DEBUG_SECURITY) {
                    Debug.println("Setting SecurityManager to: " + sm);
                }
                System.setSecurityManager(sm);
                return;
            }
            catch (ClassNotFoundException e2) {
            }
            catch (ClassCastException e3) {
            }
            catch (InstantiationException e4) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new NoClassDefFoundError(securityManager);
        }
    }

    public void publishFrameworkEvent(int type, Bundle bundle, Throwable throwable) {
        if (this.frameworkEvent != null) {
            if (bundle == null) {
                bundle = this.systemBundle;
            }
            final FrameworkEvent event = new FrameworkEvent(type, bundle, throwable);
            if (System.getSecurityManager() == null) {
                this.publishFrameworkEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishFrameworkEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFrameworkEventPrivileged(FrameworkEvent event) {
        FrameworkLog frameworkLog;
        if (event.getType() == 2 && (frameworkLog = this.adaptor.getFrameworkLog()) != null) {
            frameworkLog.log(event);
        }
        ListenerQueue listeners = new ListenerQueue(this.eventManager);
        ListenerQueue contexts = new ListenerQueue(this.eventManager);
        EventListeners eventListeners = this.frameworkEvent;
        synchronized (eventListeners) {
            contexts.queueListeners(this.frameworkEvent, this);
            contexts.dispatchEventSynchronous(4, listeners);
        }
        listeners.dispatchEventAsynchronous(4, event);
    }

    public void publishBundleEvent(int type, Bundle bundle) {
        if (this.bundleEventSync != null || this.bundleEvent != null) {
            final BundleEvent event = new BundleEvent(type, bundle);
            if (System.getSecurityManager() == null) {
                this.publishBundleEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishBundleEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishBundleEventPrivileged(BundleEvent event) {
        ListenerQueue listenersSync = null;
        if (this.bundleEventSync != null) {
            listenersSync = new ListenerQueue(this.eventManager);
            ListenerQueue contexts = new ListenerQueue(this.eventManager);
            EventListeners eventListeners = this.bundleEventSync;
            synchronized (eventListeners) {
                contexts.queueListeners(this.bundleEventSync, this);
                contexts.dispatchEventSynchronous(2, listenersSync);
            }
        }
        ListenerQueue listenersAsync = null;
        if (this.bundleEvent != null) {
            listenersAsync = new ListenerQueue(this.eventManager);
            ListenerQueue contexts = new ListenerQueue(this.eventManager);
            EventListeners eventListeners = this.bundleEvent;
            synchronized (eventListeners) {
                contexts.queueListeners(this.bundleEvent, this);
                contexts.dispatchEventSynchronous(1, listenersAsync);
            }
        }
        if (listenersSync != null) {
            listenersSync.dispatchEventSynchronous(2, event);
        }
        if (listenersAsync != null) {
            listenersAsync.dispatchEventAsynchronous(1, event);
        }
    }

    public void publishServiceEvent(int type, ServiceReference reference) {
        if (this.serviceEvent != null) {
            final ServiceEvent event = new ServiceEvent(type, reference);
            if (System.getSecurityManager() == null) {
                this.publishServiceEventPrivileged(event);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Framework.this.publishServiceEventPrivileged(event);
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishServiceEventPrivileged(ServiceEvent event) {
        ListenerQueue listeners = new ListenerQueue(this.eventManager);
        ListenerQueue contexts = new ListenerQueue(this.eventManager);
        EventListeners eventListeners = this.serviceEvent;
        synchronized (eventListeners) {
            contexts.queueListeners(this.serviceEvent, this);
            contexts.dispatchEventSynchronous(3, listeners);
        }
        listeners.dispatchEventSynchronous(3, event);
    }

    public void dispatchEvent(Object l2, Object lo, int action, Object object) {
        block10: {
            try {
                BundleContextImpl context = (BundleContextImpl)l2;
                if (context.isValid()) {
                    ListenerQueue queue = (ListenerQueue)object;
                    switch (action) {
                        case 1: {
                            queue.queueListeners(context.bundleEvent, context);
                            break;
                        }
                        case 2: {
                            queue.queueListeners(context.bundleEventSync, context);
                            break;
                        }
                        case 3: {
                            queue.queueListeners(context.serviceEvent, context);
                            break;
                        }
                        case 4: {
                            queue.queueListeners(context.frameworkEvent, context);
                        }
                    }
                }
            }
            catch (Throwable t2) {
                FrameworkEvent event;
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("Exception in Top level event dispatcher: " + t2.getMessage());
                    Debug.printStackTrace(t2);
                }
                this.adaptor.handleRuntimeError(t2);
                if (action == 4 && (event = (FrameworkEvent)object).getType() == 2) break block10;
                BundleContextImpl context = (BundleContextImpl)l2;
                this.publishFrameworkEvent(2, context.bundle, t2);
            }
        }
    }

    private String[] noMatches(boolean optional) throws BundleException {
        if (optional) {
            return null;
        }
        throw new BundleException(Msg.BUNDLE_NATIVECODE_MATCH_EXCEPTION);
    }
}

