/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Tokenizer;

public class AliasMapper {
    private static Hashtable processorAliasTable;
    private static Hashtable osnameAliasTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String aliasProcessor(String processor) {
        String alias;
        InputStream in;
        processor = processor.toLowerCase();
        if (processorAliasTable == null && (in = this.getClass().getResourceAsStream("processor.aliases")) != null) {
            try {
                processorAliasTable = AliasMapper.initAliases(in);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (processorAliasTable != null && (alias = (String)processorAliasTable.get(processor)) != null) {
            processor = alias;
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aliasOSName(String osname) {
        Object aliasObject;
        InputStream in;
        osname = osname.toLowerCase();
        if (osnameAliasTable == null && (in = this.getClass().getResourceAsStream("osname.aliases")) != null) {
            try {
                osnameAliasTable = AliasMapper.initAliases(in);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (osnameAliasTable != null && (aliasObject = osnameAliasTable.get(osname)) != null) {
            if (aliasObject instanceof String) {
                osname = (String)aliasObject;
            } else {
                return (Vector)aliasObject;
            }
        }
        return osname;
    }

    protected static Hashtable initAliases(InputStream in) {
        Hashtable<String, Object> aliases;
        block8: {
            aliases = new Hashtable<String, Object>(37);
            try {
                String line;
                BufferedReader br;
                try {
                    br = new BufferedReader(new InputStreamReader(in, "UTF8"));
                }
                catch (UnsupportedEncodingException e2) {
                    br = new BufferedReader(new InputStreamReader(in));
                }
                while ((line = br.readLine()) != null) {
                    String alias;
                    Tokenizer tokenizer = new Tokenizer(line);
                    String master = tokenizer.getString("# \t");
                    if (master == null) continue;
                    aliases.put(master.toLowerCase(), master);
                    while ((alias = tokenizer.getString("# \t")) != null) {
                        String lowerCaseAlias = alias.toLowerCase();
                        Object storedMaster = aliases.get(lowerCaseAlias);
                        if (storedMaster == null) {
                            aliases.put(lowerCaseAlias, master);
                            continue;
                        }
                        if (storedMaster instanceof String) {
                            Vector<Object> newMaster = new Vector<Object>();
                            newMaster.add(storedMaster);
                            newMaster.add(master);
                            aliases.put(lowerCaseAlias, newMaster);
                            continue;
                        }
                        ((Vector)storedMaster).add(master);
                        aliases.put(lowerCaseAlias, storedMaster);
                    }
                }
            }
            catch (IOException e3) {
                if (!Debug.DEBUG_GENERAL) break block8;
                Debug.printStackTrace(e3);
            }
        }
        return aliases;
    }
}

