/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

public class EventListeners {
    private static final ListElement[] emptyArray = new ListElement[0];
    private final int initialCapacity;
    private ListElement[] list = null;
    private int size = 0;
    private boolean copyOnWrite = false;

    public EventListeners() {
        this(10);
    }

    public EventListeners(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.initialCapacity = capacity;
    }

    public synchronized void addListener(Object listener, Object listenerObject) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.size == 0) {
            this.list = new ListElement[this.initialCapacity];
        } else {
            if (this.copyOnWrite) {
                this.copyList(this.size);
                this.copyOnWrite = false;
            }
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.list[i2].primary != listener) continue;
                this.list[i2] = new ListElement(listener, listenerObject);
                return;
            }
            if (this.size == this.list.length) {
                this.copyList(this.size);
            }
        }
        this.list[this.size] = new ListElement(listener, listenerObject);
        ++this.size;
    }

    public synchronized void removeListener(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.list[i2].primary != listener) continue;
            --this.size;
            if (this.size == 0) {
                this.list = null;
                return;
            }
            if (this.copyOnWrite) {
                this.copyList(i2);
                this.copyOnWrite = false;
            } else {
                System.arraycopy(this.list, i2 + 1, this.list, i2, this.size - i2);
                this.list[this.size] = null;
            }
            return;
        }
    }

    public synchronized void removeAllListeners() {
        this.list = null;
        this.size = 0;
    }

    synchronized ListElement[] getListeners() {
        if (this.size == 0) {
            return emptyArray;
        }
        this.copyOnWrite = true;
        return this.list;
    }

    private void copyList(int i2) {
        if (i2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int capacity = this.size * 3 / 2 + 1;
        if (capacity < this.initialCapacity) {
            capacity = this.initialCapacity;
        }
        ListElement[] newList = new ListElement[capacity];
        System.arraycopy(this.list, 0, newList, 0, i2);
        if (i2 < this.size) {
            System.arraycopy(this.list, i2 + 1, newList, i2, this.size - i2);
        }
        this.list = newList;
    }

    static class ListElement {
        final Object primary;
        final Object companion;

        ListElement(Object primary, Object companion) {
            this.primary = primary;
            this.companion = companion;
        }
    }
}

