/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.NameInfo;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.ConfigurationCache;
import org.eclipse.emf.ecore.xmi.impl.DefaultDOMHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.NameInfoImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLString;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLSaveImpl
implements XMLSave {
    protected static final int INDEX_LOOKUP = 0;
    final StringBuffer buffer = new StringBuffer();
    protected XMLHelper helper;
    protected XMLString doc;
    protected boolean declareXSI;
    protected boolean useEncodedAttributeStyle;
    protected boolean declareXML;
    protected boolean saveTypeInfo;
    protected XMLSave.XMLTypeInfo xmlTypeInfo;
    protected boolean keepDefaults;
    protected Escape escape;
    protected Escape escapeURI;
    protected Lookup featureTable;
    protected String encoding;
    protected String idAttributeName = "id";
    protected String idAttributeNS = null;
    protected String processDanglingHREF;
    protected boolean declareSchemaLocation;
    protected boolean declareSchemaLocationImplementation;
    protected XMLResource.XMLMap map;
    protected ExtendedMetaData extendedMetaData;
    protected EClass anySimpleType;
    protected EClass anyType;
    protected Map eObjectToExtensionMap;
    protected EPackage xmlSchemaTypePackage = XMLTypePackage.eINSTANCE;
    protected int flushThreshold = Integer.MAX_VALUE;
    protected boolean toDOM;
    protected DOMHandler handler;
    protected Document document;
    protected Node currentNode;
    protected NameInfo nameInfo;
    protected boolean useCache;
    protected static final int SKIP = 0;
    protected static final int SAME_DOC = 1;
    protected static final int CROSS_DOC = 2;
    protected static final int TRANSIENT = 0;
    protected static final int DATATYPE_SINGLE = 1;
    protected static final int DATATYPE_ELEMENT_SINGLE = 2;
    protected static final int DATATYPE_CONTENT_SINGLE = 3;
    protected static final int DATATYPE_SINGLE_NILLABLE = 4;
    protected static final int DATATYPE_MANY = 5;
    protected static final int OBJECT_CONTAIN_SINGLE = 6;
    protected static final int OBJECT_CONTAIN_MANY = 7;
    protected static final int OBJECT_HREF_SINGLE = 8;
    protected static final int OBJECT_HREF_MANY = 9;
    protected static final int OBJECT_CONTAIN_SINGLE_UNSETTABLE = 10;
    protected static final int OBJECT_CONTAIN_MANY_UNSETTABLE = 11;
    protected static final int OBJECT_HREF_SINGLE_UNSETTABLE = 12;
    protected static final int OBJECT_HREF_MANY_UNSETTABLE = 13;
    protected static final int OBJECT_ELEMENT_SINGLE = 14;
    protected static final int OBJECT_ELEMENT_SINGLE_UNSETTABLE = 15;
    protected static final int OBJECT_ELEMENT_MANY = 16;
    protected static final int OBJECT_ELEMENT_IDREF_SINGLE = 17;
    protected static final int OBJECT_ELEMENT_IDREF_SINGLE_UNSETTABLE = 18;
    protected static final int OBJECT_ELEMENT_IDREF_MANY = 19;
    protected static final int ATTRIBUTE_FEATURE_MAP = 20;
    protected static final int ELEMENT_FEATURE_MAP = 21;
    protected static final int OBJECT_ATTRIBUTE_SINGLE = 22;
    protected static final int OBJECT_ATTRIBUTE_MANY = 23;
    protected static final int OBJECT_ATTRIBUTE_IDREF_SINGLE = 24;
    protected static final int OBJECT_ATTRIBUTE_IDREF_MANY = 25;
    protected static final int DATATYPE_ATTRIBUTE_MANY = 26;
    protected static final String XML_VERSION = "1.0";
    protected static final String XSI_NIL = "xsi:nil";
    protected static final String XSI_TYPE_NS = "xsi:type";
    protected static final String XSI_XMLNS = "xmlns:xsi";
    protected static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    protected static final String XSI_NO_NAMESPACE_SCHEMA_LOCATION = "xsi:noNamespaceSchemaLocation";
    protected static final int EMPTY_ELEMENT = 1;
    protected static final int CONTENT_ELEMENT = 2;

    public XMLSaveImpl(XMLHelper helper) {
        this.helper = helper;
    }

    public XMLSaveImpl(Map options, XMLHelper helper, String encoding) {
        this.helper = helper;
        this.init(helper.getResource(), options);
        this.encoding = encoding;
    }

    public Document save(XMLResource resource, Document doc, Map options, DOMHandler handler) {
        EObject root;
        EClass eClass;
        EReference xmlnsPrefixMapFeature;
        this.toDOM = true;
        this.document = doc;
        this.handler = handler;
        this.init(resource, options);
        EList contents = resource.getContents();
        this.traverse(contents);
        if (this.extendedMetaData != null && contents.size() >= 1 && (xmlnsPrefixMapFeature = this.extendedMetaData.getXMLNSPrefixMapFeature(eClass = (root = (EObject)contents.get(0)).eClass())) != null) {
            EMap xmlnsPrefixMap = (EMap)root.eGet(xmlnsPrefixMapFeature);
            Iterator i2 = this.helper.getPrefixToNamespaceMap().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = (Map.Entry)i2.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                Object currentValue = xmlnsPrefixMap.get(key);
                if (!(currentValue == null ? value != null : !currentValue.equals(value))) continue;
                xmlnsPrefixMap.put(key, value);
            }
        }
        return this.document;
    }

    public void save(XMLResource resource, OutputStream outputStream, Map options) throws IOException {
        DanglingHREFException exception;
        EObject root;
        EClass eClass;
        EReference xmlnsPrefixMapFeature;
        this.init(resource, options);
        EList contents = resource.getContents();
        this.traverse(contents);
        if (this.encoding.equals("US-ASCII") || this.encoding.equals("ASCII")) {
            this.writeAscii(outputStream);
            outputStream.flush();
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.helper.getJavaEncoding(this.encoding));
            this.write(outputStreamWriter);
            outputStreamWriter.flush();
        }
        if (this.extendedMetaData != null && contents.size() >= 1 && (xmlnsPrefixMapFeature = this.extendedMetaData.getXMLNSPrefixMapFeature(eClass = (root = (EObject)contents.get(0)).eClass())) != null) {
            EMap xmlnsPrefixMap = (EMap)root.eGet(xmlnsPrefixMapFeature);
            Iterator i2 = this.helper.getPrefixToNamespaceMap().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = (Map.Entry)i2.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                Object currentValue = xmlnsPrefixMap.get(key);
                if (!(currentValue == null ? value != null : !currentValue.equals(value))) continue;
                xmlnsPrefixMap.put(key, value);
            }
        }
        if ((this.processDanglingHREF == null || "THROW".equals(this.processDanglingHREF)) && (exception = this.helper.getDanglingHREFException()) != null) {
            this.helper = null;
            throw new Resource.IOWrappedException(exception);
        }
        if (this.useCache) {
            ConfigurationCache.INSTANCE.releasePrinter(this.doc);
            if (this.escape != null) {
                ConfigurationCache.INSTANCE.releaseEscape(this.escape);
            }
        }
        this.featureTable = null;
        this.doc = null;
        this.helper = null;
    }

    protected void init(XMLResource resource, Map options) {
        List lookup;
        Object extendedMetaDataOption;
        this.useCache = Boolean.TRUE.equals(options.get("CONFIGURATION_CACHE"));
        this.nameInfo = new NameInfoImpl();
        this.declareXSI = false;
        this.keepDefaults = Boolean.TRUE.equals(options.get("KEEP_DEFAULT_CONTENT"));
        this.useEncodedAttributeStyle = Boolean.TRUE.equals(options.get("USE_ENCODED_ATTRIBUTE_STYLE"));
        this.declareSchemaLocationImplementation = Boolean.TRUE.equals(options.get("SCHEMA_LOCATION_IMPLEMENTATION"));
        this.declareSchemaLocation = this.declareSchemaLocationImplementation || Boolean.TRUE.equals(options.get("SCHEMA_LOCATION"));
        Object saveTypeInfoOption = options.get("SAVE_TYPE_INFORMATION");
        if (saveTypeInfoOption instanceof Boolean) {
            this.saveTypeInfo = saveTypeInfoOption.equals(Boolean.TRUE);
            if (this.saveTypeInfo) {
                this.xmlTypeInfo = new XMLTypeInfoImpl();
            }
        } else {
            boolean bl = this.saveTypeInfo = saveTypeInfoOption != null;
            if (this.saveTypeInfo) {
                this.xmlTypeInfo = (XMLSave.XMLTypeInfo)saveTypeInfoOption;
            }
        }
        this.anyType = (EClass)options.get("ANY_TYPE");
        this.anySimpleType = (EClass)options.get("ANY_SIMPLE_TYPE");
        if (this.anyType == null) {
            this.anyType = XMLTypePackage.eINSTANCE.getAnyType();
            this.anySimpleType = XMLTypePackage.eINSTANCE.getSimpleAnyType();
        }
        if ((extendedMetaDataOption = options.get("EXTENDED_META_DATA")) instanceof Boolean) {
            if (extendedMetaDataOption.equals(Boolean.TRUE)) {
                this.extendedMetaData = resource == null || resource.getResourceSet() == null ? ExtendedMetaData.INSTANCE : new BasicExtendedMetaData(resource.getResourceSet().getPackageRegistry());
            }
        } else {
            this.extendedMetaData = (ExtendedMetaData)options.get("EXTENDED_META_DATA");
        }
        if (!this.toDOM) {
            Integer lineWidth;
            boolean bl = this.declareXML = !Boolean.FALSE.equals(options.get("DECLARE_XML"));
            if (options.get("FLUSH_THRESHOLD") instanceof Integer) {
                this.flushThreshold = (Integer)options.get("FLUSH_THRESHOLD");
            }
            String temporaryFileName = null;
            if (Boolean.TRUE.equals(options.get("USE_FILE_BUFFER"))) {
                try {
                    temporaryFileName = File.createTempFile("XMLSave", null).getPath();
                }
                catch (IOException iOException) {}
            }
            int effectiveLineWidth = (lineWidth = (Integer)options.get("LINE_WIDTH")) == null ? Integer.MAX_VALUE : lineWidth;
            String publicId = null;
            String systemId = null;
            if (resource != null && Boolean.TRUE.equals(options.get("SAVE_DOCTYPE"))) {
                publicId = resource.getPublicId();
                systemId = resource.getSystemId();
            }
            if (this.useCache) {
                this.doc = ConfigurationCache.INSTANCE.getPrinter();
                this.doc.reset(publicId, systemId, effectiveLineWidth, temporaryFileName);
                this.escape = Boolean.TRUE.equals(options.get("SKIP_ESCAPE")) ? null : ConfigurationCache.INSTANCE.getEscape();
            } else {
                this.doc = new XMLString(effectiveLineWidth, publicId, systemId, temporaryFileName);
                Escape escape = this.escape = Boolean.TRUE.equals(options.get("SKIP_ESCAPE")) ? null : new Escape();
            }
            if (Boolean.FALSE.equals(options.get("FORMATTED"))) {
                this.doc.setUnformatted(true);
            }
            Escape escape = this.escapeURI = Boolean.FALSE.equals(options.get("SKIP_ESCAPE_URI")) ? this.escape : null;
            if (options.containsKey("ENCODING")) {
                this.encoding = (String)options.get("ENCODING");
            } else if (resource != null) {
                this.encoding = resource.getEncoding();
            }
        } else if (this.handler instanceof DefaultDOMHandlerImpl) {
            ((DefaultDOMHandlerImpl)this.handler).setExtendedMetaData(this.extendedMetaData);
        }
        this.processDanglingHREF = (String)options.get("PROCESS_DANGLING_HREF");
        this.helper.setProcessDanglingHREF(this.processDanglingHREF);
        this.map = (XMLResource.XMLMap)options.get("XML_MAP");
        if (this.map != null) {
            this.helper.setXMLMap(this.map);
            if (this.map.getIDAttributeName() != null) {
                this.idAttributeName = this.map.getIDAttributeName();
            }
        }
        if (resource != null) {
            this.eObjectToExtensionMap = resource.getEObjectToExtensionMap();
            if (this.eObjectToExtensionMap.isEmpty()) {
                this.eObjectToExtensionMap = null;
            } else if (this.extendedMetaData == null) {
                ExtendedMetaData extendedMetaData = this.extendedMetaData = resource.getResourceSet() == null ? ExtendedMetaData.INSTANCE : new BasicExtendedMetaData(resource.getResourceSet().getPackageRegistry());
            }
        }
        if (this.extendedMetaData != null) {
            EObject root;
            EClass eClass;
            EReference xmlnsPrefixMapFeature;
            this.helper.setExtendedMetaData(this.extendedMetaData);
            if (resource != null && resource.getContents().size() >= 1 && (xmlnsPrefixMapFeature = this.extendedMetaData.getXMLNSPrefixMapFeature(eClass = (root = (EObject)resource.getContents().get(0)).eClass())) != null) {
                EMap xmlnsPrefixMap = (EMap)root.eGet(xmlnsPrefixMapFeature);
                this.helper.setPrefixToNamespaceMap(xmlnsPrefixMap);
            }
        }
        if ((lookup = (List)options.get("USE_CACHED_LOOKUP_TABLE")) != null) {
            if (lookup.isEmpty()) {
                this.featureTable = new Lookup(this.map, this.extendedMetaData);
                lookup.add(this.featureTable);
            } else {
                this.featureTable = (Lookup)lookup.get(0);
            }
        } else {
            this.featureTable = new Lookup(this.map, this.extendedMetaData);
        }
    }

    public void traverse(List contents) {
        int size;
        if (!this.toDOM && this.declareXML) {
            this.doc.add("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            this.doc.addLine();
        }
        Object mark = (size = contents.size()) == 1 ? this.writeTopObject((EObject)contents.get(0)) : this.writeTopObjects(contents);
        if (!this.toDOM) {
            this.doc.resetToMark(mark);
        } else {
            this.currentNode = this.document.getDocumentElement();
        }
        this.addNamespaceDeclarations();
    }

    protected void writeTopAttributes(EObject top) {
    }

    protected Object writeTopObject(EObject top) {
        EClass eClass = top.eClass();
        if (!this.toDOM) {
            if (this.extendedMetaData == null || this.featureTable.getDocumentRoot(eClass.getEPackage()) != eClass) {
                String name = this.helper.getQName(eClass);
                this.doc.startElement(name);
                this.writeTopAttributes(top);
                Object mark = this.doc.mark();
                this.saveElementID(top);
                return mark;
            }
            this.doc.startElement(null);
            this.saveFeatures(top);
            return null;
        }
        if (this.extendedMetaData == null || this.extendedMetaData.getDocumentRoot(eClass.getEPackage()) != eClass) {
            this.helper.populateNameInfo(this.nameInfo, eClass);
            if (this.document.getLastChild() == null) {
                this.currentNode = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                this.currentNode = this.document.appendChild(this.currentNode);
            } else {
                this.currentNode = this.currentNode.appendChild(this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName()));
            }
            this.handler.recordValues(this.currentNode, null, null, top);
            this.writeTopAttributes(top);
            this.saveElementID(top);
            return null;
        }
        this.saveFeatures(top);
        return null;
    }

    protected Object writeTopObjects(List contents) {
        return this.writeTopObject((EObject)contents.get(0));
    }

    protected void addNamespaceDeclarations() {
        EPackage noNamespacePackage = this.helper.getNoNamespacePackage();
        EPackage[] packages = this.helper.packages();
        this.buffer.setLength(0);
        StringBuffer xsiSchemaLocation = this.buffer;
        String xsiNoNamespaceSchemaLocation = null;
        if (this.declareSchemaLocation) {
            EMap xsiSchemaLocationMap;
            EObject root;
            EClass eClass;
            EReference xsiSchemaLocationMapFeature;
            XMLResource resource;
            Map handledBySchemaLocationMap = Collections.EMPTY_MAP;
            if (this.extendedMetaData != null && (resource = this.helper.getResource()) != null && resource.getContents().size() >= 1 && (xsiSchemaLocationMapFeature = this.extendedMetaData.getXSISchemaLocationMapFeature(eClass = (root = (EObject)resource.getContents().get(0)).eClass())) != null && !(xsiSchemaLocationMap = (EMap)root.eGet(xsiSchemaLocationMapFeature)).isEmpty()) {
                handledBySchemaLocationMap = xsiSchemaLocationMap.map();
                this.declareXSI = true;
                Iterator i2 = xsiSchemaLocationMap.entrySet().iterator();
                while (i2.hasNext()) {
                    Map.Entry entry = (Map.Entry)i2.next();
                    String namespace = (String)entry.getKey();
                    URI location = URI.createURI(entry.getValue().toString());
                    if (namespace == null) {
                        xsiNoNamespaceSchemaLocation = this.helper.deresolve(location).toString();
                        continue;
                    }
                    if (xsiSchemaLocation.length() > 0) {
                        xsiSchemaLocation.append(' ');
                    }
                    xsiSchemaLocation.append(namespace);
                    xsiSchemaLocation.append(' ');
                    xsiSchemaLocation.append(this.helper.deresolve(location).toString());
                }
            }
            int i3 = 0;
            while (i3 < packages.length) {
                EPackage ePackage = packages[i3];
                String javaImplementationLocation = null;
                if (this.declareSchemaLocationImplementation) {
                    try {
                        Field field = ePackage.getClass().getField("eINSTANCE");
                        javaImplementationLocation = "java://" + field.getDeclaringClass().getName();
                    }
                    catch (Exception exception) {}
                }
                if (noNamespacePackage == ePackage) {
                    if (ePackage.eResource() != null && !handledBySchemaLocationMap.containsKey(null)) {
                        this.declareXSI = true;
                        if (javaImplementationLocation != null) {
                            xsiNoNamespaceSchemaLocation = javaImplementationLocation;
                        } else {
                            xsiNoNamespaceSchemaLocation = this.helper.getHREF(ePackage);
                            if (xsiNoNamespaceSchemaLocation.endsWith("#/")) {
                                xsiNoNamespaceSchemaLocation = xsiNoNamespaceSchemaLocation.substring(0, xsiNoNamespaceSchemaLocation.length() - 2);
                            }
                        }
                    }
                } else {
                    String nsURI;
                    Resource resource2 = ePackage.eResource();
                    if (resource2 != null && !handledBySchemaLocationMap.containsKey(nsURI = ePackage.getNsURI())) {
                        URI uri = resource2.getURI();
                        if (javaImplementationLocation != null || (uri == null ? nsURI != null : !uri.toString().equals(nsURI))) {
                            String location;
                            this.declareXSI = true;
                            if (xsiSchemaLocation.length() > 0) {
                                xsiSchemaLocation.append(' ');
                            }
                            xsiSchemaLocation.append(nsURI);
                            xsiSchemaLocation.append(' ');
                            String string = location = javaImplementationLocation == null ? this.helper.getHREF(ePackage) : javaImplementationLocation;
                            if (location.endsWith("#/")) {
                                location = location.substring(0, location.length() - 2);
                            }
                            xsiSchemaLocation.append(location);
                        }
                    }
                }
                ++i3;
            }
        }
        if (this.declareXSI) {
            if (!this.toDOM) {
                this.doc.addAttribute(XSI_XMLNS, "http://www.w3.org/2001/XMLSchema-instance");
            } else {
                ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", XSI_XMLNS, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        int i4 = 0;
        while (i4 < packages.length) {
            EPackage ePackage = packages[i4];
            if (ePackage != noNamespacePackage && ePackage != XMLNamespacePackage.eINSTANCE && !"http://www.w3.org/2000/xmlns/".equals(ePackage.getNsURI())) {
                String nsURI;
                String string = nsURI = this.extendedMetaData == null ? ePackage.getNsURI() : this.extendedMetaData.getNamespace(ePackage);
                if (ePackage == this.xmlSchemaTypePackage) {
                    nsURI = "http://www.w3.org/2001/XMLSchema";
                }
                if (nsURI != null && !this.isDuplicateURI(nsURI)) {
                    List nsPrefixes = this.helper.getPrefixes(ePackage);
                    Iterator j2 = nsPrefixes.iterator();
                    while (j2.hasNext()) {
                        String nsPrefix = (String)j2.next();
                        if (!this.toDOM) {
                            if (nsPrefix != null && nsPrefix.length() > 0) {
                                this.doc.addAttributeNS("xmlns", nsPrefix, nsURI);
                                continue;
                            }
                            this.doc.addAttribute("xmlns", nsURI);
                            continue;
                        }
                        if (nsPrefix != null && nsPrefix.length() > 0) {
                            ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + nsPrefix, nsURI);
                            continue;
                        }
                        ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", nsURI);
                    }
                }
            }
            ++i4;
        }
        if (xsiSchemaLocation.length() > 0) {
            if (!this.toDOM) {
                this.doc.addAttribute(XSI_SCHEMA_LOCATION, xsiSchemaLocation.toString());
            } else {
                ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSI_SCHEMA_LOCATION, xsiSchemaLocation.toString());
            }
        }
        if (xsiNoNamespaceSchemaLocation != null) {
            if (!this.toDOM) {
                this.doc.addAttribute(XSI_NO_NAMESPACE_SCHEMA_LOCATION, xsiNoNamespaceSchemaLocation);
            } else {
                ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSI_NO_NAMESPACE_SCHEMA_LOCATION, xsiNoNamespaceSchemaLocation);
            }
        }
    }

    public boolean isDuplicateURI(String nsURI) {
        return false;
    }

    public void write(OutputStreamWriter os) throws IOException {
        this.doc.write(os, this.flushThreshold);
        os.flush();
    }

    public void writeAscii(OutputStream os) throws IOException {
        this.doc.writeAscii(os, this.flushThreshold);
        os.flush();
    }

    public char[] toChar() {
        int size = this.doc.getLength();
        char[] output = new char[size];
        this.doc.getChars(output, 0);
        return output;
    }

    protected void saveElement(EObject o2, EStructuralFeature f2) {
        XMLResource.XMLInfo info;
        String name;
        EClass eClass = o2.eClass();
        EClassifier eType = f2.getEType();
        if (this.extendedMetaData != null && eClass != eType && (name = this.extendedMetaData.getName(eClass)).endsWith("_._type")) {
            String elementName = name.substring(0, name.indexOf("_._"));
            String prefix = this.helper.getPrefix(eClass.getEPackage());
            if (!"".equals(prefix)) {
                elementName = String.valueOf(prefix) + ":" + elementName;
            }
            if (!this.toDOM) {
                this.doc.startElement(elementName);
            } else {
                this.currentNode = this.currentNode.appendChild(this.document.createElementNS(this.helper.getNamespaceURI(prefix), elementName));
                this.handler.recordValues(this.currentNode, o2.eContainer(), f2, o2);
            }
            this.saveElementID(o2);
            return;
        }
        if (this.map != null && (info = this.map.getInfo(eClass)) != null && info.getXMLRepresentation() == 0) {
            if (!this.toDOM) {
                String elementName = this.helper.getQName(eClass);
                this.doc.startElement(elementName);
            } else {
                this.helper.populateNameInfo(this.nameInfo, eClass);
                if (this.currentNode == null) {
                    this.currentNode = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                    this.document.appendChild(this.currentNode);
                    this.handler.recordValues(this.currentNode, o2.eContainer(), f2, o2);
                } else {
                    this.currentNode = this.currentNode.appendChild(this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName()));
                    this.handler.recordValues(this.currentNode, o2.eContainer(), f2, o2);
                }
            }
            this.saveElementID(o2);
            return;
        }
        if (o2 instanceof AnyType) {
            this.helper.pushContext();
            Iterator i2 = ((AnyType)o2).getAnyAttribute().iterator();
            while (i2.hasNext()) {
                FeatureMap.Entry entry = (FeatureMap.Entry)i2.next();
                if (!"http://www.w3.org/2000/xmlns/".equals(this.extendedMetaData.getNamespace(entry.getEStructuralFeature()))) continue;
                String uri = (String)entry.getValue();
                this.helper.addPrefix(this.extendedMetaData.getName(entry.getEStructuralFeature()), uri == null ? "" : uri);
            }
        }
        if (!this.toDOM) {
            String featureName = this.helper.getQName(f2);
            this.doc.startElement(featureName);
        } else {
            this.helper.populateNameInfo(this.nameInfo, f2);
            if (this.currentNode == null) {
                this.currentNode = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                this.document.appendChild(this.currentNode);
                this.handler.recordValues(this.currentNode, o2.eContainer(), f2, o2);
            } else {
                this.currentNode = this.currentNode.appendChild(this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName()));
                this.handler.recordValues(this.currentNode, o2.eContainer(), f2, o2);
            }
        }
        if (this.saveTypeInfo ? this.xmlTypeInfo.shouldSaveType(eClass, eType, f2) : eClass != eType && eClass != this.anyType) {
            if (eClass == this.anySimpleType) {
                this.saveTypeAttribute(((SimpleAnyType)o2).getInstanceType());
            } else {
                this.saveTypeAttribute(eClass);
            }
        }
        this.saveElementID(o2);
    }

    protected void saveTypeAttribute(EClass eClass) {
        this.declareXSI = true;
        if (!this.toDOM) {
            this.doc.addAttribute(XSI_TYPE_NS, this.helper.getQName(eClass));
        } else {
            this.helper.populateNameInfo(this.nameInfo, eClass);
            ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSI_TYPE_NS, this.nameInfo.getQualifiedName());
        }
    }

    protected void saveTypeAttribute(EDataType eDataType) {
        this.declareXSI = true;
        if (!this.toDOM) {
            this.doc.addAttribute(XSI_TYPE_NS, this.helper.getQName(eDataType));
        } else {
            this.helper.populateNameInfo(this.nameInfo, eDataType);
            ((Element)this.currentNode).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSI_TYPE_NS, this.nameInfo.getQualifiedName());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean saveFeatures(EObject o) {
        eClass = o.eClass();
        v0 = contentKind = this.extendedMetaData == null ? 0 : this.extendedMetaData.getContentKind(eClass);
        if (!this.toDOM) {
            switch (contentKind) {
                case 2: 
                case 3: {
                    this.doc.setMixed(true);
                }
            }
        }
        features = this.featureTable.getFeatures(eClass);
        featureKinds = this.featureTable.getKinds(eClass, features);
        elementFeatures = null;
        elementCount = 0;
        content = null;
        i = 0;
        while (i < features.length) {
            block66: {
                kind = featureKinds[i];
                f = features[i];
                if (kind == 0 || !o.eIsSet(f) && (!this.keepDefaults || f.getDefaultValueLiteral() == null)) break block66;
                block3 : switch (kind) {
                    case 2: {
                        if (contentKind != 2) break;
                        content = this.getDataTypeElementSingleSimple(o, f);
                        break block66;
                    }
                    case 1: {
                        this.saveDataTypeSingle(o, f);
                        break block66;
                    }
                    case 4: {
                        if (this.isNil(o, f)) break;
                        this.saveDataTypeSingle(o, f);
                        break block66;
                    }
                    case 22: {
                        this.saveEObjectSingle(o, f);
                        break block66;
                    }
                    case 23: {
                        this.saveEObjectMany(o, f);
                        break block66;
                    }
                    case 24: {
                        this.saveIDRefSingle(o, f);
                        break block66;
                    }
                    case 25: {
                        this.saveIDRefMany(o, f);
                        break block66;
                    }
                    case 12: {
                        if (this.isNil(o, f)) break;
                    }
                    case 8: {
                        if (this.useEncodedAttributeStyle) {
                            this.saveEObjectSingle(o, f);
                        } else {
                            switch (this.sameDocSingle(o, f)) {
                                case 1: {
                                    this.saveIDRefSingle(o, f);
                                    break;
                                }
                                case 2: {
                                    break block3;
                                }
                            }
                        }
                        break block66;
                    }
                    case 13: {
                        if (!this.isEmpty(o, f)) ** GOTO lbl58
                        this.saveManyEmpty(o, f);
                        break block66;
                    }
lbl58:
                    // 2 sources

                    case 9: {
                        if (this.useEncodedAttributeStyle) {
                            this.saveEObjectMany(o, f);
                        } else {
                            switch (this.sameDocMany(o, f)) {
                                case 1: {
                                    this.saveIDRefMany(o, f);
                                    break;
                                }
                                case 2: {
                                    break block3;
                                }
                            }
                        }
                        break block66;
                    }
                    case 14: 
                    case 15: {
                        if (contentKind != 2) break;
                        content = this.getElementReferenceSingleSimple(o, f);
                        break block66;
                    }
                    case 16: {
                        if (contentKind != 2) break;
                        content = this.getElementReferenceManySimple(o, f);
                        break block66;
                    }
                    case 17: 
                    case 18: {
                        if (contentKind != 2) break;
                        content = this.getElementIDRefSingleSimple(o, f);
                        break block66;
                    }
                    case 19: {
                        if (contentKind != 2) break;
                        content = this.getElementIDRefManySimple(o, f);
                        break block66;
                    }
                    case 26: {
                        break;
                    }
                    case 5: 
                    case 11: {
                        if (!this.isEmpty(o, f)) break;
                        this.saveManyEmpty(o, f);
                        break block66;
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 21: {
                        break;
                    }
                    case 20: {
                        this.saveAttributeFeatureMap(o, f);
                        break block66;
                    }
                    default: {
                        break block66;
                    }
                }
                if (elementFeatures == null) {
                    elementFeatures = new int[features.length];
                }
                elementFeatures[elementCount++] = i;
            }
            ++i;
        }
        this.processAttributeExtensions(o);
        if (elementFeatures == null) {
            if (content == null) {
                content = this.getContent(o, features);
            }
            if (content == null) {
                this.endSaveFeatures(o, 1, null);
                return false;
            }
            this.endSaveFeatures(o, 2, content);
            return true;
        }
        i = 0;
        while (i < elementCount) {
            kind = featureKinds[elementFeatures[i]];
            f = features[elementFeatures[i]];
            switch (kind) {
                case 4: {
                    this.saveNil(o, f);
                    break;
                }
                case 21: {
                    this.saveElementFeatureMap(o, f);
                    break;
                }
                case 5: {
                    this.saveDataTypeMany(o, f);
                    break;
                }
                case 26: {
                    this.saveDataTypeAttributeMany(o, f);
                    break;
                }
                case 2: {
                    this.saveDataTypeElementSingle(o, f);
                    break;
                }
                case 10: {
                    if (this.isNil(o, f)) {
                        this.saveNil(o, f);
                        break;
                    }
                }
                case 6: {
                    this.saveContainedSingle(o, f);
                    break;
                }
                case 7: 
                case 11: {
                    this.saveContainedMany(o, f);
                    break;
                }
                case 12: {
                    if (this.isNil(o, f)) {
                        this.saveNil(o, f);
                        break;
                    }
                }
                case 8: {
                    this.saveHRefSingle(o, f);
                    break;
                }
                case 9: 
                case 13: {
                    this.saveHRefMany(o, f);
                    break;
                }
                case 15: {
                    if (this.isNil(o, f)) {
                        this.saveNil(o, f);
                        break;
                    }
                }
                case 14: {
                    this.saveElementReferenceSingle(o, f);
                    break;
                }
                case 16: {
                    this.saveElementReferenceMany(o, f);
                    break;
                }
                case 18: {
                    if (this.isNil(o, f)) {
                        this.saveNil(o, f);
                        break;
                    }
                }
                case 17: {
                    this.saveElementIDRefSingle(o, f);
                    break;
                }
                case 19: {
                    this.saveElementIDRefMany(o, f);
                }
            }
            ++i;
        }
        this.endSaveFeatures(o, 0, null);
        return true;
    }

    protected void endSaveFeatures(EObject o2, int elementType, String content) {
        if (this.processElementExtensions(o2)) {
            if (o2 instanceof AnyType) {
                this.helper.popContext();
            }
            if (!this.toDOM) {
                this.doc.endElement();
            }
        } else {
            switch (elementType) {
                case 1: {
                    if (this.toDOM) break;
                    this.doc.endEmptyElement();
                    break;
                }
                case 2: {
                    if (this.toDOM) break;
                    this.doc.endContentElement(content);
                    break;
                }
                default: {
                    if (o2 instanceof AnyType) {
                        this.helper.popContext();
                    }
                    if (this.toDOM) break;
                    this.doc.endElement();
                }
            }
        }
        if (this.toDOM) {
            this.currentNode = this.currentNode.getParentNode();
        }
    }

    protected boolean processElementExtensions(EObject object) {
        if (this.eObjectToExtensionMap != null) {
            AnyType anyType = (AnyType)this.eObjectToExtensionMap.get(object);
            return anyType != null && this.saveElementFeatureMap(anyType, XMLTypePackage.eINSTANCE.getAnyType_Mixed());
        }
        return false;
    }

    protected void processAttributeExtensions(EObject object) {
        AnyType anyType;
        if (this.eObjectToExtensionMap != null && (anyType = (AnyType)this.eObjectToExtensionMap.get(object)) != null) {
            this.saveAttributeFeatureMap(anyType, XMLTypePackage.eINSTANCE.getAnyType_AnyAttribute());
        }
    }

    protected void saveDataTypeSingle(EObject o2, EStructuralFeature f2) {
        Object value = this.helper.getValue(o2, f2);
        String svalue = this.getDatatypeValue(value, f2, true);
        if (svalue != null) {
            if (!this.toDOM) {
                this.doc.addAttribute(this.helper.getQName(f2), svalue);
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Attr attr = this.document.createAttributeNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                attr.setNodeValue(svalue);
                ((Element)this.currentNode).setAttributeNodeNS(attr);
                this.handler.recordValues(attr, o2, f2, value);
            }
        }
    }

    protected boolean isNil(EObject o2, EStructuralFeature f2) {
        return this.helper.getValue(o2, f2) == null;
    }

    protected boolean isEmpty(EObject o2, EStructuralFeature f2) {
        return ((List)this.helper.getValue(o2, f2)).isEmpty();
    }

    protected void saveNil(EObject o2, EStructuralFeature f2) {
        if (!this.toDOM) {
            this.saveNil(f2);
        } else {
            this.declareXSI = true;
            this.helper.populateNameInfo(this.nameInfo, f2);
            Element elem = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
            elem.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSI_NIL, "true");
            this.currentNode.appendChild(elem);
            this.handler.recordValues(this.currentNode.getLastChild(), o2, f2, null);
        }
    }

    protected void saveNil(EStructuralFeature f2) {
        this.declareXSI = true;
        this.doc.saveNilElement(this.helper.getQName(f2));
    }

    protected void saveManyEmpty(EObject o2, EStructuralFeature f2) {
        if (!this.toDOM) {
            this.saveManyEmpty(f2);
        } else {
            this.helper.populateNameInfo(this.nameInfo, f2);
            Attr attr = this.document.createAttributeNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
            ((Element)this.currentNode).setAttributeNodeNS(attr);
            this.handler.recordValues(attr, o2, f2, null);
        }
    }

    protected void saveManyEmpty(EStructuralFeature f2) {
        this.doc.addAttribute(this.helper.getQName(f2), "");
    }

    protected void saveDataTypeMany(EObject o2, EStructuralFeature f2) {
        block9: {
            List values = (List)this.helper.getValue(o2, f2);
            int size = values.size();
            if (size <= 0) break block9;
            if (!this.toDOM) {
                EDataType d2 = (EDataType)f2.getEType();
                EPackage ePackage = d2.getEPackage();
                EFactory fac = ePackage.getEFactoryInstance();
                String name = this.helper.getQName(f2);
                int i2 = 0;
                while (i2 < size) {
                    Object value = values.get(i2);
                    if (value == null) {
                        this.doc.startElement(name);
                        this.doc.addAttribute(XSI_NIL, "true");
                        this.doc.endEmptyElement();
                        this.declareXSI = true;
                    } else {
                        String svalue = this.helper.convertToString(fac, d2, value);
                        if (this.escape != null) {
                            svalue = this.escape.convert(svalue);
                        }
                        this.doc.saveDataValueElement(name, svalue);
                    }
                    ++i2;
                }
            } else {
                EDataType d3 = (EDataType)f2.getEType();
                EPackage ePackage = d3.getEPackage();
                EFactory fac = ePackage.getEFactoryInstance();
                this.helper.populateNameInfo(this.nameInfo, f2);
                int i3 = 0;
                while (i3 < size) {
                    Element elem;
                    Object value = values.get(i3);
                    if (value == null) {
                        elem = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                        elem.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", XSI_NIL, "true");
                        this.currentNode.appendChild(elem);
                        this.handler.recordValues(elem, o2, f2, null);
                        this.declareXSI = true;
                    } else {
                        elem = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                        Text text = this.document.createTextNode(this.helper.convertToString(fac, d3, value));
                        elem.appendChild(text);
                        this.currentNode.appendChild(elem);
                        this.handler.recordValues(elem, o2, f2, value);
                        this.handler.recordValues(text, o2, f2, value);
                    }
                    ++i3;
                }
            }
        }
    }

    protected void saveDataTypeAttributeMany(EObject o2, EStructuralFeature f2) {
        List values = (List)this.helper.getValue(o2, f2);
        int size = values.size();
        if (size > 0) {
            Object value;
            EDataType d2 = (EDataType)f2.getEType();
            EPackage ePackage = d2.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            StringBuffer stringValues = new StringBuffer();
            int i2 = 0;
            while (i2 < size) {
                value = values.get(i2);
                if (value != null) {
                    String svalue = this.helper.convertToString(fac, d2, value);
                    if (this.escape != null) {
                        svalue = this.escape.convert(svalue);
                    }
                    if (i2 > 0) {
                        stringValues.append(' ');
                    }
                    stringValues.append(svalue);
                }
                ++i2;
            }
            if (!this.toDOM) {
                String name = this.helper.getQName(f2);
                this.doc.startAttribute(name);
                this.doc.addAttributeContent(stringValues.toString());
                this.doc.endAttribute();
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Attr attr = this.document.createAttributeNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                value = stringValues.toString();
                attr.setNodeValue((String)value);
                ((Element)this.currentNode).setAttributeNodeNS(attr);
                this.handler.recordValues(attr, o2, f2, value);
            }
        }
    }

    protected void saveEObjectSingle(EObject o2, EStructuralFeature f2) {
        String id;
        EObject value = (EObject)this.helper.getValue(o2, f2);
        if (value != null && (id = this.helper.getHREF(value)) != null) {
            if (this.escapeURI != null) {
                id = this.escapeURI.convert(id);
            }
            this.buffer.setLength(0);
            if (!id.startsWith("#")) {
                EClass eClass = value.eClass();
                EClass expectedType = (EClass)f2.getEType();
                if (this.saveTypeInfo ? this.xmlTypeInfo.shouldSaveType(eClass, expectedType, f2) : eClass != expectedType && expectedType.isAbstract()) {
                    this.buffer.append(this.helper.getQName(eClass));
                    this.buffer.append(" ");
                }
            }
            this.buffer.append(id);
            if (!this.toDOM) {
                String name = this.helper.getQName(f2);
                this.doc.startAttribute(name);
                this.doc.addAttributeContent(this.buffer.toString());
                this.doc.endAttribute();
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Attr attr = this.document.createAttributeNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                attr.setNodeValue(this.buffer.toString());
                ((Element)this.currentNode).setAttributeNodeNS(attr);
                this.handler.recordValues(attr, o2, f2, value);
            }
        }
    }

    protected void saveEObjectMany(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        if (!values.isEmpty()) {
            this.buffer.setLength(0);
            Iterator i2 = values.basicIterator();
            while (true) {
                EObject value;
                String id;
                if ((id = this.helper.getHREF(value = (EObject)i2.next())) != null) {
                    if (this.escapeURI != null) {
                        id = this.escapeURI.convert(id);
                    }
                    if (!id.startsWith("#")) {
                        EClass eClass = value.eClass();
                        EClass expectedType = (EClass)f2.getEType();
                        if (this.saveTypeInfo ? this.xmlTypeInfo.shouldSaveType(eClass, expectedType, f2) : eClass != expectedType && expectedType.isAbstract()) {
                            this.buffer.append(this.helper.getQName(eClass));
                            this.buffer.append(" ");
                        }
                    }
                    this.buffer.append(id);
                }
                if (!i2.hasNext()) break;
                this.buffer.append(" ");
            }
            if (!this.toDOM) {
                String name = this.helper.getQName(f2);
                this.doc.startAttribute(name);
                this.doc.addAttributeContent(this.buffer.toString());
                this.doc.endAttribute();
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Attr attr = this.document.createAttributeNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                attr.setNodeValue(this.buffer.toString());
                ((Element)this.currentNode).setAttributeNodeNS(attr);
                this.handler.recordValues(attr, o2, f2, values);
            }
        }
    }

    protected void saveIDRefSingle(EObject o2, EStructuralFeature f2) {
        EObject value = (EObject)this.helper.getValue(o2, f2);
        if (value != null) {
            String id = this.helper.getIDREF(value);
            if (!this.toDOM) {
                String name = this.helper.getQName(f2);
                this.doc.addAttribute(name, id);
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Attr attr = this.document.createAttributeNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                attr.setNodeValue(id);
                ((Element)this.currentNode).setAttributeNodeNS(attr);
                this.handler.recordValues(attr, o2, f2, value);
            }
        }
    }

    protected void saveIDRefMany(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        if (!values.isEmpty()) {
            this.buffer.setLength(0);
            StringBuffer ids = this.buffer;
            Iterator i2 = values.basicIterator();
            while (true) {
                EObject value = (EObject)i2.next();
                String id = this.helper.getIDREF(value);
                ids.append(id);
                if (!i2.hasNext()) break;
                ids.append(" ");
            }
            if (!this.toDOM) {
                String name = this.helper.getQName(f2);
                this.doc.addAttribute(name, ids.toString());
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Attr attr = this.document.createAttributeNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                attr.setNodeValue(ids.toString());
                ((Element)this.currentNode).setAttributeNodeNS(attr);
                this.handler.recordValues(attr, o2, f2, values);
            }
        }
    }

    protected void saveElementReference(EObject remote, EStructuralFeature f2) {
        String href = this.helper.getHREF(remote);
        if (href != null) {
            if (this.escapeURI != null) {
                href = this.escapeURI.convert(href);
            }
            if (!this.toDOM) {
                this.doc.startElement(this.helper.getQName(f2));
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Element elem = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                Text text = this.document.createTextNode(href);
                elem.appendChild(text);
                this.currentNode = this.currentNode.appendChild(elem);
                this.handler.recordValues(elem, remote.eContainer(), f2, remote);
                this.handler.recordValues(text, remote.eContainer(), f2, remote);
            }
            EClass eClass = remote.eClass();
            EClass expectedType = (EClass)f2.getEType();
            if (this.saveTypeInfo ? this.xmlTypeInfo.shouldSaveType(eClass, expectedType, f2) : eClass != expectedType && expectedType.isAbstract()) {
                this.saveTypeAttribute(eClass);
            }
            if (!this.toDOM) {
                this.doc.endContentElement(href);
            } else {
                this.currentNode = this.currentNode.getParentNode();
            }
        }
    }

    protected void saveElementReferenceSingle(EObject o2, EStructuralFeature f2) {
        EObject value = (EObject)this.helper.getValue(o2, f2);
        if (value != null) {
            this.saveElementReference(value, f2);
        }
    }

    protected void saveElementReferenceMany(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        int size = values.size();
        int i2 = 0;
        while (i2 < size) {
            this.saveElementReference((EObject)values.basicGet(i2), f2);
            ++i2;
        }
    }

    protected String getElementReferenceSingleSimple(EObject o2, EStructuralFeature f2) {
        EObject value = (EObject)this.helper.getValue(o2, f2);
        String svalue = this.helper.getHREF(value);
        if (this.escapeURI != null && svalue != null) {
            svalue = this.escapeURI.convert(svalue);
        }
        if (this.toDOM) {
            Text text = this.document.createTextNode(svalue);
            this.currentNode.appendChild(text);
            this.handler.recordValues(text, o2, f2, value);
        }
        return svalue;
    }

    protected String getElementReferenceManySimple(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        this.buffer.setLength(0);
        StringBuffer result = this.buffer;
        int size = values.size();
        String href = null;
        int i2 = 0;
        while (i2 < size) {
            href = this.helper.getHREF((EObject)values.basicGet(i2));
            if (this.escapeURI != null && href != null) {
                href = this.escapeURI.convert(href);
            }
            result.append(href);
            result.append(' ');
            ++i2;
        }
        String svalue = result.substring(0, result.length() - 1);
        if (this.toDOM) {
            Text text = this.document.createTextNode(svalue);
            this.currentNode.appendChild(text);
            this.handler.recordValues(text, o2, f2, values);
        }
        return svalue;
    }

    protected void saveElementIDRef(EObject o2, EObject target, EStructuralFeature f2) {
        if (!this.toDOM) {
            this.saveElementIDRef(target, f2);
        } else {
            String id = this.helper.getIDREF(target);
            this.helper.populateNameInfo(this.nameInfo, f2);
            Element elem = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
            Text text = this.document.createTextNode(id);
            elem.appendChild(text);
            this.currentNode.appendChild(elem);
            this.handler.recordValues(elem, o2, f2, target);
            this.handler.recordValues(text, o2, f2, target);
        }
    }

    protected void saveElementIDRef(EObject target, EStructuralFeature f2) {
        String name = this.helper.getQName(f2);
        String id = this.helper.getIDREF(target);
        this.doc.saveDataValueElement(name, id);
    }

    protected void saveElementIDRefSingle(EObject o2, EStructuralFeature f2) {
        EObject value = (EObject)this.helper.getValue(o2, f2);
        if (value != null) {
            this.saveElementIDRef(o2, value, f2);
        }
    }

    protected void saveElementIDRefMany(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        int size = values.size();
        int i2 = 0;
        while (i2 < size) {
            this.saveElementIDRef(o2, (EObject)values.basicGet(i2), f2);
            ++i2;
        }
    }

    protected String getElementIDRefSingleSimple(EObject o2, EStructuralFeature f2) {
        EObject value = (EObject)this.helper.getValue(o2, f2);
        String svalue = this.helper.getIDREF(value);
        if (this.toDOM) {
            Text text = this.document.createTextNode(svalue);
            this.currentNode.appendChild(text);
            this.handler.recordValues(text, o2, f2, value);
        }
        return svalue;
    }

    protected String getElementIDRefManySimple(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        this.buffer.setLength(0);
        StringBuffer result = this.buffer;
        int i2 = 0;
        int size = values.size();
        while (i2 < size) {
            result.append(this.helper.getIDREF((EObject)values.basicGet(i2)));
            result.append(' ');
            ++i2;
        }
        String svalue = result.substring(0, result.length() - 1);
        if (this.toDOM) {
            Text text = this.document.createTextNode(svalue);
            this.currentNode.appendChild(text);
            this.handler.recordValues(text, o2, f2, values);
        }
        return svalue;
    }

    protected void saveHref(EObject remote, EStructuralFeature f2) {
        String href = this.helper.getHREF(remote);
        if (href != null) {
            if (this.escapeURI != null) {
                href = this.escapeURI.convert(href);
            }
            if (!this.toDOM) {
                String name = this.helper.getQName(f2);
                this.doc.startElement(name);
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Element elem = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                this.currentNode = this.currentNode.appendChild(elem);
                this.handler.recordValues(elem, remote.eContainer(), f2, remote);
            }
            EClass eClass = remote.eClass();
            EClass expectedType = (EClass)f2.getEType();
            if (this.saveTypeInfo ? this.xmlTypeInfo.shouldSaveType(eClass, expectedType, f2) : eClass != expectedType && expectedType.isAbstract()) {
                this.saveTypeAttribute(eClass);
            }
            if (!this.toDOM) {
                this.doc.addAttribute("href", href);
                this.doc.endEmptyElement();
            } else {
                ((Element)this.currentNode).setAttributeNS(null, "href", href);
                this.currentNode = this.currentNode.getParentNode();
            }
        }
    }

    protected void saveHRefSingle(EObject o2, EStructuralFeature f2) {
        EObject value = (EObject)this.helper.getValue(o2, f2);
        if (value != null) {
            this.saveHref(value, f2);
        }
    }

    protected void saveHRefMany(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        int size = values.size();
        int i2 = 0;
        while (i2 < size) {
            this.saveHref((EObject)values.basicGet(i2), f2);
            ++i2;
        }
    }

    protected void saveContainedSingle(EObject o2, EStructuralFeature f2) {
        EObject value = (EObject)this.helper.getValue(o2, f2);
        if (value != null) {
            this.saveElement(value, f2);
        }
    }

    protected void saveContainedMany(EObject o2, EStructuralFeature f2) {
        List values = (List)this.helper.getValue(o2, f2);
        int size = values.size();
        int i2 = 0;
        while (i2 < size) {
            EObject value = (EObject)values.get(i2);
            if (value != null) {
                this.saveElement(value, f2);
            }
            ++i2;
        }
    }

    protected void saveFeatureMapElementReference(EObject o2, EReference f2) {
        this.saveElementReference(o2, f2);
    }

    protected boolean saveElementFeatureMap(EObject o2, EStructuralFeature f2) {
        List values = (List)this.helper.getValue(o2, f2);
        int size = values.size();
        int i2 = 0;
        while (i2 < size) {
            String stringValue;
            FeatureMap.Entry entry = (FeatureMap.Entry)values.get(i2);
            EStructuralFeature entryFeature = entry.getEStructuralFeature();
            Object value = entry.getValue();
            if (entryFeature instanceof EReference) {
                if (value == null) {
                    this.saveNil(o2, entryFeature);
                } else {
                    EReference referenceEntryFeature = (EReference)entryFeature;
                    if (referenceEntryFeature.isContainment()) {
                        this.saveElement((EObject)value, entryFeature);
                    } else if (referenceEntryFeature.isResolveProxies()) {
                        this.saveFeatureMapElementReference((EObject)value, referenceEntryFeature);
                    } else {
                        this.saveElementIDRef(o2, (EObject)value, entryFeature);
                    }
                }
            } else if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text()) {
                String svalue = value.toString();
                if (this.escape != null) {
                    svalue = this.escape.convertText(svalue);
                }
                if (!this.toDOM) {
                    this.doc.addText(svalue);
                } else {
                    Text text = this.document.createTextNode(svalue);
                    this.currentNode.appendChild(text);
                    this.handler.recordValues(text, o2, f2, entry);
                }
            } else if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA()) {
                stringValue = value.toString();
                if (this.escape != null) {
                    stringValue = this.escape.convertLines(stringValue);
                }
                if (!this.toDOM) {
                    this.doc.addCDATA(stringValue);
                } else {
                    CDATASection cdata = this.document.createCDATASection(stringValue);
                    this.currentNode.appendChild(cdata);
                    this.handler.recordValues(cdata, o2, f2, entry);
                }
            } else if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Comment()) {
                stringValue = value.toString();
                if (this.escape != null) {
                    stringValue = this.escape.convertLines(stringValue);
                }
                if (!this.toDOM) {
                    this.doc.addComment(stringValue);
                } else {
                    this.currentNode.appendChild(this.document.createComment(stringValue));
                }
            } else {
                this.saveElement(o2, value, entryFeature);
            }
            ++i2;
        }
        return size > 0;
    }

    protected void saveAttributeFeatureMap(EObject o2, EStructuralFeature f2) {
        List values = (List)this.helper.getValue(o2, f2);
        int size = values.size();
        HashSet<EReference> repeats = null;
        int i2 = 0;
        while (i2 < size) {
            block13: {
                EStructuralFeature entryFeature;
                FeatureMap.Entry entry;
                block9: {
                    EReference referenceEntryFeature;
                    block10: {
                        block12: {
                            block11: {
                                entry = (FeatureMap.Entry)values.get(i2);
                                entryFeature = entry.getEStructuralFeature();
                                if (!(entryFeature instanceof EReference)) break block9;
                                referenceEntryFeature = (EReference)entryFeature;
                                if (!referenceEntryFeature.isMany()) break block10;
                                if (repeats != null) break block11;
                                repeats = new HashSet<EReference>();
                                break block12;
                            }
                            if (repeats.contains(referenceEntryFeature)) break block13;
                        }
                        repeats.add(referenceEntryFeature);
                        if (referenceEntryFeature.isResolveProxies()) {
                            this.saveEObjectMany(o2, entryFeature);
                        } else {
                            this.saveIDRefMany(o2, entryFeature);
                        }
                        break block13;
                    }
                    if (referenceEntryFeature.isResolveProxies()) {
                        this.saveEObjectSingle(o2, entryFeature);
                    } else {
                        this.saveIDRefSingle(o2, entryFeature);
                    }
                    break block13;
                }
                Object value = entry.getValue();
                String svalue = this.getDatatypeValue(value, entryFeature, true);
                if (!this.toDOM) {
                    this.doc.addAttribute(this.helper.getQName(entryFeature), svalue);
                } else {
                    this.helper.populateNameInfo(this.nameInfo, entryFeature);
                    Attr attr = this.document.createAttributeNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                    attr.setNodeValue(svalue);
                    ((Element)this.currentNode).setAttributeNodeNS(attr);
                    this.handler.recordValues(attr, o2, f2, value);
                }
            }
            ++i2;
        }
    }

    protected int sameDocSingle(EObject o2, EStructuralFeature f2) {
        InternalEObject value = (InternalEObject)this.helper.getValue(o2, f2);
        if (value == null) {
            return 0;
        }
        if (value.eIsProxy()) {
            return 2;
        }
        Resource res = value.eResource();
        return res == this.helper.getResource() ? 1 : 2;
    }

    protected int sameDocMany(EObject o2, EStructuralFeature f2) {
        InternalEList values = (InternalEList)this.helper.getValue(o2, f2);
        if (values.isEmpty()) {
            return 0;
        }
        Iterator i2 = values.basicIterator();
        while (i2.hasNext()) {
            InternalEObject value = (InternalEObject)i2.next();
            if (!value.eIsProxy() && value.eResource() == this.helper.getResource()) continue;
            return 2;
        }
        return 1;
    }

    protected String getContent(EObject o2, EStructuralFeature[] features) {
        if (this.map == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < features.length) {
            EStructuralFeature feature = features[i2];
            XMLResource.XMLInfo info = this.map.getInfo(feature);
            if (info != null && info.getXMLRepresentation() == 2) {
                Object value = this.helper.getValue(o2, feature);
                String svalue = this.getDatatypeValue(value, feature, false);
                if (this.toDOM) {
                    Text text = this.document.createTextNode(svalue);
                    this.currentNode.appendChild(text);
                    this.handler.recordValues(text, o2, feature, value);
                }
                return svalue;
            }
            ++i2;
        }
        return null;
    }

    protected void saveDataTypeElementSingle(EObject o2, EStructuralFeature f2) {
        this.saveElement(o2, this.helper.getValue(o2, f2), f2);
    }

    protected String getDataTypeElementSingleSimple(EObject o2, EStructuralFeature f2) {
        Object value = this.helper.getValue(o2, f2);
        String svalue = this.getDatatypeValue(value, f2, false);
        if (this.toDOM) {
            Text text = this.document.createTextNode(svalue);
            this.currentNode.appendChild(text);
            this.handler.recordValues(text, o2, f2, value);
        }
        return svalue;
    }

    protected void saveElementID(EObject o2) {
        String id = this.helper.getID(o2);
        if (id != null) {
            if (!this.toDOM) {
                this.doc.addAttribute(this.idAttributeName, id);
            } else {
                Attr attr = this.document.createAttributeNS(this.idAttributeNS, this.idAttributeName);
                attr.setNodeValue(id);
                ((Element)this.currentNode).setAttributeNodeNS(attr);
                this.handler.recordValues(attr, o2, null, o2);
            }
        }
        this.saveFeatures(o2);
    }

    protected String getDatatypeValue(Object value, EStructuralFeature f2, boolean isAttribute) {
        if (value == null) {
            return null;
        }
        EDataType d2 = (EDataType)f2.getEType();
        EPackage ePackage = d2.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        String svalue = this.helper.convertToString(fac, d2, value);
        if (this.escape != null) {
            svalue = isAttribute ? this.escape.convert(svalue) : this.escape.convertText(svalue);
        }
        return svalue;
    }

    private void saveElement(EObject o2, Object value, EStructuralFeature f2) {
        if (value == null) {
            this.saveNil(o2, f2);
        } else {
            String svalue = this.getDatatypeValue(value, f2, false);
            if (!this.toDOM) {
                this.doc.saveDataValueElement(this.helper.getQName(f2), svalue);
            } else {
                this.helper.populateNameInfo(this.nameInfo, f2);
                Element elem = this.document.createElementNS(this.nameInfo.getNamespaceURI(), this.nameInfo.getQualifiedName());
                Text text = this.document.createTextNode(svalue);
                elem.appendChild(text);
                this.currentNode.appendChild(elem);
                this.handler.recordValues(elem, o2, f2, value);
                this.handler.recordValues(text, o2, f2, value);
            }
        }
    }

    protected static class Lookup {
        protected static final int SHIFT = 10;
        protected static final int SIZE = 1024;
        protected static final int MASK = 1023;
        protected EClass[] classes;
        protected EStructuralFeature[][] features;
        protected int[][] featureKinds;
        protected XMLResource.XMLMap map;
        protected ExtendedMetaData extendedMetaData;
        protected ArrayList docRoots = new ArrayList();
        static /* synthetic */ Class class$0;

        public Lookup(XMLResource.XMLMap map) {
            this(map, null);
        }

        public Lookup(XMLResource.XMLMap map, ExtendedMetaData extendedMetaData) {
            this.map = map;
            this.extendedMetaData = extendedMetaData;
            this.classes = new EClass[1024];
            this.features = new EStructuralFeature[1024][];
            this.featureKinds = new int[1024][];
        }

        public EClass getDocumentRoot(EPackage epackage) {
            int i2 = 0;
            while (i2 < this.docRoots.size()) {
                if (this.docRoots.get(i2) == epackage) {
                    return (EClass)this.docRoots.get(++i2);
                }
                i2 += 2;
            }
            this.docRoots.add(epackage);
            EClass docRoot = this.extendedMetaData.getDocumentRoot(epackage);
            this.docRoots.add(docRoot);
            return docRoot;
        }

        public EStructuralFeature[] getFeatures(EClass cls) {
            int index = this.getIndex(cls);
            EClass c2 = this.classes[index];
            if (c2 == cls) {
                return this.features[index];
            }
            EStructuralFeature[] featureList = this.listFeatures(cls);
            if (c2 == null) {
                this.classes[index] = cls;
                this.features[index] = featureList;
                this.featureKinds[index] = this.listKinds(featureList);
            }
            return featureList;
        }

        public int[] getKinds(EClass cls, EStructuralFeature[] featureList) {
            int index = this.getIndex(cls);
            EClass c2 = this.classes[index];
            if (c2 == cls) {
                return this.featureKinds[index];
            }
            int[] kindsList = this.listKinds(featureList);
            if (c2 == null) {
                this.classes[index] = cls;
                this.features[index] = featureList;
                this.featureKinds[index] = kindsList;
            }
            return kindsList;
        }

        protected int getIndex(EClass cls) {
            String name = cls.getInstanceClassName();
            int index = 0;
            index = name != null ? name.hashCode() & 0x3FF : cls.hashCode() >> 10 & 0x3FF;
            return index;
        }

        protected EStructuralFeature[] listFeatures(EClass cls) {
            if (this.extendedMetaData != null) {
                ArrayList f2 = new ArrayList();
                f2.addAll(cls.getEAllStructuralFeatures());
                List orderedElements = this.extendedMetaData.getAllElements(cls);
                f2.removeAll(orderedElements);
                f2.addAll(orderedElements);
                return f2.toArray(new EStructuralFeature[f2.size()]);
            }
            EList f3 = this.map == null ? cls.getEAllStructuralFeatures() : this.map.getFeatures(cls);
            return f3.toArray(new EStructuralFeature[f3.size()]);
        }

        protected int[] listKinds(EStructuralFeature[] featureList) {
            int[] kinds = new int[featureList.length];
            int i2 = featureList.length - 1;
            while (i2 >= 0) {
                kinds[i2] = this.featureKind(featureList[i2]);
                --i2;
            }
            return kinds;
        }

        protected int featureKind(EStructuralFeature f2) {
            if (f2.isTransient()) {
                return 0;
            }
            boolean isMany = f2.isMany();
            boolean isUnsettable = f2.isUnsettable();
            if (f2 instanceof EReference) {
                XMLResource.XMLInfo info;
                EReference r2 = (EReference)f2;
                if (r2.isContainment()) {
                    return isMany ? (isUnsettable ? 11 : 7) : (isUnsettable ? 10 : 6);
                }
                EReference opposite = r2.getEOpposite();
                if (opposite != null && opposite.isContainment()) {
                    return 0;
                }
                if (this.map != null && (info = this.map.getInfo(f2)) != null && info.getXMLRepresentation() == 0) {
                    return isMany ? 16 : (r2.isUnsettable() ? 15 : 14);
                }
                if (this.extendedMetaData != null) {
                    switch (this.extendedMetaData.getFeatureKind(f2)) {
                        case 2: {
                            return r2.isResolveProxies() ? (isMany ? 23 : 22) : (isMany ? 25 : 24);
                        }
                        case 1: 
                        case 4: {
                            return r2.isResolveProxies() ? (isMany ? 16 : (r2.isUnsettable() ? 15 : 14)) : (isMany ? 19 : (r2.isUnsettable() ? 18 : 17));
                        }
                    }
                }
                return isMany ? (isUnsettable ? 13 : 9) : (isUnsettable ? 12 : 8);
            }
            EDataType d2 = (EDataType)f2.getEType();
            if (!d2.isSerializable()) {
                return 0;
            }
            Class clazz = d2.getInstanceClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.emf.ecore.util.FeatureMap$Entry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                return this.extendedMetaData != null && this.extendedMetaData.getFeatureKind(f2) == 3 ? 20 : 21;
            }
            if (this.extendedMetaData != null) {
                switch (this.extendedMetaData.getFeatureKind(f2)) {
                    case 1: {
                        return 2;
                    }
                    case 4: {
                        return f2.isMany() ? 5 : 2;
                    }
                    case 2: {
                        return f2.isMany() ? 26 : 1;
                    }
                }
            }
            if (isMany) {
                return 5;
            }
            if (isUnsettable && this.map == null) {
                return 4;
            }
            if (this.map == null) {
                return 1;
            }
            XMLResource.XMLInfo info = this.map.getInfo(f2);
            if (info != null && info.getXMLRepresentation() == 0) {
                return 2;
            }
            if (info != null && info.getXMLRepresentation() == 2) {
                return 3;
            }
            if (isUnsettable) {
                return 4;
            }
            return 1;
        }
    }

    protected static class Escape {
        protected char[] value;
        protected final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
        protected final char[] LESS = new char[]{'&', 'l', 't', ';'};
        protected final char[] QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        protected final char[] LF = new char[]{'&', '#', 'x', 'A', ';'};
        protected final char[] CR = new char[]{'&', '#', 'x', 'D', ';'};
        protected final char[] TAB = new char[]{'&', '#', 'x', '9', ';'};
        protected final char[] LINE_FEED = System.getProperty("line.separator").toCharArray();

        public Escape() {
            this.value = new char[100];
        }

        public String convert(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            char ch = '\u0000';
            while (inputLength-- > 0) {
                ch = this.value[pos];
                switch (ch) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    case '\n': {
                        pos = this.replace(pos, this.LF, inputLength);
                        changed = true;
                        break;
                    }
                    case '\r': {
                        pos = this.replace(pos, this.CR, inputLength);
                        changed = true;
                        break;
                    }
                    case '\t': {
                        pos = this.replace(pos, this.TAB, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        if (!DataValue.XMLChar.isValid(ch)) {
                            throw new RuntimeException("An invalid XML character (Unicode: 0x" + Integer.toHexString(ch) + ") was found in the element content:" + input);
                        }
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        public String convertText(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            while (inputLength-- > 0) {
                char ch = this.value[pos];
                switch (ch) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    case '\n': {
                        pos = this.replace(pos, this.LINE_FEED, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        if (!DataValue.XMLChar.isValid(ch)) {
                            throw new RuntimeException("An invalid XML character (Unicode: 0x" + Integer.toHexString(ch) + ") was found in the element content:" + input);
                        }
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        public String convertLines(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            while (inputLength-- > 0) {
                switch (this.value[pos]) {
                    case '\n': {
                        pos = this.replace(pos, this.LINE_FEED, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        protected int replace(int pos, char[] replacement, int inputLength) {
            int rlen = replacement.length;
            int newPos = pos + rlen;
            this.grow(newPos + inputLength);
            System.arraycopy(this.value, pos + 1, this.value, newPos, inputLength);
            System.arraycopy(replacement, 0, this.value, pos, rlen);
            return newPos;
        }

        protected void grow(int newSize) {
            int vlen = this.value.length;
            if (vlen < newSize) {
                char[] newValue = new char[newSize + newSize / 2];
                System.arraycopy(this.value, 0, newValue, 0, vlen);
                this.value = newValue;
            }
        }
    }

    protected class XMLTypeInfoImpl
    implements XMLSave.XMLTypeInfo {
        protected XMLTypeInfoImpl() {
        }

        public boolean shouldSaveType(EClass objectType, EClassifier featureType, EStructuralFeature feature) {
            return objectType != featureType && objectType != XMLSaveImpl.this.anyType;
        }

        public boolean shouldSaveType(EClass objectType, EClass featureType, EStructuralFeature feature) {
            return objectType != featureType;
        }
    }
}

