/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class EcoreUtil {
    protected static final String GEN_MODEL_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/GenModel";
    public static final int GET = 0;
    public static final int SET = 1;
    public static final int IS_SET = 2;
    public static final int UNSET = 3;
    static final String[] ACCESSOR_KEYS = new String[]{"suppressedGetVisibility", "suppressedSetVisibility", "suppressedIsSetVisibility", "suppressedUnsetVisibility"};
    static final String TRUE = "true";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public static Adapter getExistingAdapter(Notifier notifier, Object type) {
        return EcoreUtil.getAdapter(notifier.eAdapters(), type);
    }

    public static Adapter getRegisteredAdapter(EObject eObject, Object type) {
        AdapterFactory factory;
        ResourceSet resourceSet;
        Resource resource;
        Adapter result = EcoreUtil.getExistingAdapter(eObject, type);
        if (result == null && (resource = eObject.eResource()) != null && (resourceSet = resource.getResourceSet()) != null && (factory = EcoreUtil.getAdapterFactory(resourceSet.getAdapterFactories(), type)) != null) {
            result = factory.adaptNew(eObject, type);
        }
        return result;
    }

    public static Adapter getRegisteredAdapter(Resource resource, Object type) {
        AdapterFactory factory;
        ResourceSet resourceSet;
        Adapter result = EcoreUtil.getExistingAdapter(resource, type);
        if (result == null && (resourceSet = resource.getResourceSet()) != null && (factory = EcoreUtil.getAdapterFactory(resourceSet.getAdapterFactories(), type)) != null) {
            result = factory.adaptNew(resource, type);
        }
        return result;
    }

    public static Adapter getAdapter(List adapters, Object type) {
        int size = adapters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Adapter adapter = (Adapter)adapters.get(i2);
            if (!adapter.isAdapterForType(type)) continue;
            return adapter;
        }
        return null;
    }

    public static AdapterFactory getAdapterFactory(List adapterFactories, Object type) {
        int size = adapterFactories.size();
        for (int i2 = 0; i2 < size; ++i2) {
            AdapterFactory factory = (AdapterFactory)adapterFactories.get(i2);
            if (!factory.isFactoryForType(type)) continue;
            return factory;
        }
        return null;
    }

    public static EObject resolve(EObject proxy, ResourceSet resourceSet) {
        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
        if (proxyURI != null) {
            try {
                EObject resolvedObject = null;
                if (resourceSet != null) {
                    resolvedObject = resourceSet.getEObject(proxyURI, true);
                } else {
                    Resource resource;
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(proxyURI.trimFragment().toString());
                    if (ePackage != null && (resource = ePackage.eResource()) != null) {
                        resolvedObject = resource.getEObject(proxyURI.fragment().toString());
                    }
                }
                if (resolvedObject != null && resolvedObject != proxy) {
                    return EcoreUtil.resolve(resolvedObject, resourceSet);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return proxy;
    }

    public static EObject resolve(EObject proxy, Resource resourceContext) {
        return EcoreUtil.resolve(proxy, resourceContext != null ? resourceContext.getResourceSet() : null);
    }

    public static EObject resolve(EObject proxy, EObject objectContext) {
        Resource resourceContext = objectContext != null ? objectContext.eResource() : null;
        return EcoreUtil.resolve(proxy, resourceContext != null ? resourceContext.getResourceSet() : null);
    }

    public static void resolveAll(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        for (int i2 = 0; i2 < resources.size(); ++i2) {
            EcoreUtil.resolveAll((Resource)resources.get(i2));
        }
    }

    public static void resolveAll(Resource resource) {
        TreeIterator i2 = resource.getAllContents();
        while (i2.hasNext()) {
            EObject eObject = (EObject)i2.next();
            Iterator j2 = eObject.eCrossReferences().iterator();
            while (j2.hasNext()) {
                j2.next();
            }
        }
    }

    public static void resolveAll(EObject eObject) {
        TreeIterator i2 = eObject.eAllContents();
        while (i2.hasNext()) {
            EObject childEObject = (EObject)i2.next();
            Iterator j2 = childEObject.eCrossReferences().iterator();
            while (j2.hasNext()) {
                j2.next();
            }
        }
    }

    public static Object getObjectByType(Collection objects, EClassifier type) {
        Iterator i2 = objects.iterator();
        while (i2.hasNext()) {
            Object object = i2.next();
            if (!type.isInstance(object)) continue;
            return object;
        }
        return null;
    }

    public static Collection getObjectsByType(Collection objects, EClassifier type) {
        ArrayList result = new ArrayList();
        Iterator i2 = objects.iterator();
        while (i2.hasNext()) {
            Object object = i2.next();
            if (!type.isInstance(object)) continue;
            result.add(object);
        }
        return result;
    }

    public static EObject copy(EObject eObject) {
        Copier copier = new Copier();
        EObject result = copier.copy(eObject);
        copier.copyReferences();
        return result;
    }

    public static Collection copyAll(Collection eObjects) {
        Copier copier = new Copier();
        Collection result = copier.copyAll(eObjects);
        copier.copyReferences();
        return result;
    }

    public static EObject getRootContainer(EObject eObject) {
        EObject result = eObject;
        for (EObject parent = eObject; parent != null; parent = parent.eContainer()) {
            result = parent;
        }
        return result;
    }

    public static boolean isAncestor(EObject ancestorEObject, EObject eObject) {
        while (eObject != null) {
            if (eObject == ancestorEObject) {
                return true;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public static boolean isAncestor(Resource ancestorResource, EObject eObject) {
        return eObject.eResource() == ancestorResource;
    }

    public static boolean isAncestor(ResourceSet ancestorResourceSet, EObject eObject) {
        Resource resource = eObject.eResource();
        return resource != null && resource.getResourceSet() == ancestorResourceSet;
    }

    public static boolean isAncestor(Collection ancestorEMFObjects, EObject eObject) {
        if (ancestorEMFObjects.contains(eObject)) {
            return true;
        }
        for (EObject container = eObject.eContainer(); container != null; container = container.eContainer()) {
            if (ancestorEMFObjects.contains(container)) {
                return true;
            }
            eObject = container;
        }
        Resource resource = eObject.eResource();
        if (resource != null) {
            if (ancestorEMFObjects.contains(resource)) {
                return true;
            }
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null && ancestorEMFObjects.contains(resourceSet)) {
                return true;
            }
        }
        return false;
    }

    public static TreeIterator getAllContents(Collection emfObjects) {
        return new ContentTreeIterator(emfObjects);
    }

    public static boolean equals(EObject eObject1, EObject eObject2) {
        EqualityHelper equalityHelper = new EqualityHelper();
        return equalityHelper.equals(eObject1, eObject2);
    }

    public static String getIdentification(EObject eObject) {
        StringBuffer result = new StringBuffer(eObject.getClass().getName());
        EClass eClass = eObject.eClass();
        if (eClass.getInstanceClassName() == null) {
            result.append('/');
            result.append(eClass.getEPackage().getNsURI());
            result.append('#');
            result.append(eClass.getName());
        }
        result.append('@');
        result.append(Integer.toHexString(eObject.hashCode()));
        result.append('{');
        result.append(EcoreUtil.getURI(eObject));
        result.append('}');
        return result.toString();
    }

    public static URI getURI(EObject eObject) {
        URI proxyURI = ((InternalEObject)eObject).eProxyURI();
        if (proxyURI != null) {
            return proxyURI;
        }
        EObject eRootContainer = EcoreUtil.getRootContainer(eObject);
        Resource resource = eRootContainer.eResource();
        if (resource != null) {
            return resource.getURI().appendFragment(resource.getURIFragment(eObject));
        }
        StringBuffer result = new StringBuffer("#//");
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        EObject container = eObject.eContainer();
        while (container != null) {
            uriFragmentPath.add(((InternalEObject)container).eURIFragmentSegment(eObject.eContainmentFeature(), eObject));
            eObject = container;
            container = eObject.eContainer();
        }
        int size = uriFragmentPath.size();
        if (size > 0) {
            int i2 = size - 1;
            while (true) {
                result.append((String)uriFragmentPath.get(i2));
                if (i2 == 0) break;
                result.append('/');
                --i2;
            }
        }
        return URI.createURI(result.toString());
    }

    public static int indexOf(List list, Object o2, int fromIndex) {
        return ECollections.indexOf(list, o2, fromIndex);
    }

    public static void setEList(EList eList, Collection prototypeCollection) {
        ECollections.setEList(eList, new ArrayList(prototypeCollection));
    }

    public static void setEList(EList eList, List prototypeList) {
        ECollections.setEList(eList, prototypeList);
    }

    public static void remove(EStructuralFeature.Setting setting, Object value) {
        if (setting.getEStructuralFeature().isMany()) {
            ((List)setting.get(false)).remove(value);
        } else {
            setting.unset();
        }
    }

    public static void replace(EStructuralFeature.Setting setting, Object oldValue, Object newValue) {
        if (setting.getEStructuralFeature().isMany()) {
            List list = (List)setting.get(false);
            list.set(list.indexOf(oldValue), newValue);
        } else {
            setting.set(newValue);
        }
    }

    public static void remove(EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        if (eStructuralFeature.isMany()) {
            ((List)eObject.eGet(eStructuralFeature)).remove(value);
        } else {
            eObject.eUnset(eStructuralFeature);
        }
    }

    public static void replace(EObject eObject, EStructuralFeature eStructuralFeature, Object oldValue, Object newValue) {
        if (eStructuralFeature.isMany()) {
            List list = (List)eObject.eGet(eStructuralFeature);
            list.set(list.indexOf(oldValue), newValue);
        } else {
            eObject.eSet(eStructuralFeature, newValue);
        }
    }

    public static void remove(EObject eObject) {
        EObject container = eObject.eContainer();
        if (container != null) {
            EReference feature = eObject.eContainmentFeature();
            if (feature.isMany()) {
                ((EList)container.eGet(feature)).remove(eObject);
            } else {
                container.eUnset(feature);
            }
        } else {
            Resource resource = eObject.eResource();
            if (resource != null) {
                resource.getContents().remove(eObject);
            }
        }
    }

    public static void replace(EObject eObject, EObject replacementEObject) {
        EObject container = eObject.eContainer();
        if (container != null) {
            EReference feature = eObject.eContainmentFeature();
            if (feature.isMany()) {
                List list = (List)container.eGet(feature);
                list.set(list.indexOf(eObject), replacementEObject);
            } else {
                container.eSet(feature, replacementEObject);
            }
        } else {
            Resource resource = eObject.eResource();
            if (resource != null) {
                EList list = resource.getContents();
                list.set(list.indexOf(eObject), replacementEObject);
            }
        }
    }

    public static EObject create(EClass eClass) {
        return eClass.getEPackage().getEFactoryInstance().create(eClass);
    }

    public static Object createFromString(EDataType eDataType, String literal) {
        return eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, literal);
    }

    public static String convertToString(EDataType eDataType, Object value) {
        return eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, value);
    }

    public static String getID(EObject eObject) {
        EClass eClass = eObject.eClass();
        EAttribute eIDAttribute = eClass.getEIDAttribute();
        return eIDAttribute == null || !eObject.eIsSet(eIDAttribute) ? null : EcoreUtil.convertToString(eIDAttribute.getEAttributeType(), eObject.eGet(eIDAttribute));
    }

    public static void setID(EObject eObject, String id) {
        EClass eClass = eObject.eClass();
        EAttribute eIDAttribute = eClass.getEIDAttribute();
        if (eIDAttribute == null) {
            throw new IllegalArgumentException("The object doesn't have an ID feature.");
        }
        if (id == null) {
            eObject.eUnset(eIDAttribute);
        } else {
            eObject.eSet(eIDAttribute, EcoreUtil.createFromString(eIDAttribute.getEAttributeType(), id));
        }
    }

    public static Class wrapperClassFor(Class javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (javaClass.isPrimitive()) {
            if (javaClass == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = EcoreUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (javaClass == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = EcoreUtil.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (javaClass == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = EcoreUtil.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (javaClass == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = EcoreUtil.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (javaClass == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = EcoreUtil.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (javaClass == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = EcoreUtil.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (javaClass == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = EcoreUtil.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            return class$java$lang$Character == null ? (class$java$lang$Character = EcoreUtil.class$("java.lang.Character")) : class$java$lang$Character;
        }
        return javaClass;
    }

    public static String getDocumentation(EModelElement eModelElement) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(GEN_MODEL_PACKAGE_NS_URI);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get("documentation");
    }

    public static void setDocumentation(EModelElement eModelElement, String documentation) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(GEN_MODEL_PACKAGE_NS_URI);
        if (documentation == null) {
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("documentation");
            }
        } else {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(GEN_MODEL_PACKAGE_NS_URI);
                eModelElement.getEAnnotations().add(eAnnotation);
            }
            eAnnotation.getDetails().put("documentation", documentation);
        }
    }

    public static List getConstraints(EModelElement eModelElement) {
        String constraints;
        EAnnotation eAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (eAnnotation != null && (constraints = (String)eAnnotation.getDetails().get("constraints")) != null) {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(constraints);
            while (stringTokenizer.hasMoreTokens()) {
                String constraint = stringTokenizer.nextToken();
                result.add(constraint);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public static void setConstraints(EModelElement eModelElement, List constraints) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (constraints == null || constraints.isEmpty()) {
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove("constraints");
            }
        } else {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                eModelElement.getEAnnotations().add(eAnnotation);
            }
            StringBuffer value = new StringBuffer();
            Iterator i2 = constraints.iterator();
            while (i2.hasNext()) {
                value.append(i2.next());
                if (!i2.hasNext()) continue;
                value.append(' ');
            }
            eAnnotation.getDetails().put("constraints", value.toString());
        }
    }

    public static String getAnnotation(EModelElement eModelElement, String sourceURI, String key) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
        return eAnnotation == null ? null : (String)eAnnotation.getDetails().get(key);
    }

    public static void setAnnotation(EModelElement eModelElement, String sourceURI, String key, String value) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(sourceURI);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(sourceURI);
            eModelElement.getEAnnotations().add(eAnnotation);
        }
        eAnnotation.getDetails().put(key, value);
    }

    public static boolean isSuppressedVisibility(EStructuralFeature eStructuralFeature, int accessor) {
        if (accessor < 0 || accessor > 3) {
            throw new IllegalArgumentException("Invalid accessor identifier: " + accessor);
        }
        EAnnotation eAnnotation = eStructuralFeature.getEAnnotation(GEN_MODEL_PACKAGE_NS_URI);
        return eAnnotation == null ? false : TRUE.equalsIgnoreCase((String)eAnnotation.getDetails().get(ACCESSOR_KEYS[accessor]));
    }

    public static void setSuppressedVisibility(EStructuralFeature eStructuralFeature, int accessor, boolean suppress) {
        if (accessor < 0 || accessor > 3) {
            throw new IllegalArgumentException("Invalid accessor identifier: " + accessor);
        }
        EAnnotation eAnnotation = eStructuralFeature.getEAnnotation(GEN_MODEL_PACKAGE_NS_URI);
        if (!suppress) {
            if (eAnnotation != null) {
                eAnnotation.getDetails().removeKey(ACCESSOR_KEYS[accessor]);
            }
        } else {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(GEN_MODEL_PACKAGE_NS_URI);
                eStructuralFeature.getEAnnotations().add(eAnnotation);
            }
            eAnnotation.getDetails().put(ACCESSOR_KEYS[accessor], TRUE);
        }
    }

    public static String generateUUID() {
        return UUID.generate();
    }

    public static void freeze(EPackage ePackage) {
        try {
            ((EPackageImpl)ePackage).freeze();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class UUID {
        private static final char[] BASE64_DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        private static final long EPOCH_ADJUSTMENT = new GregorianCalendar(1970, 0, 1, 0, 0, 0).getTime().getTime() - new GregorianCalendar(1582, 9, 15, 0, 0, 0).getTime().getTime();
        private static long lastTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
        private static short clockSequence;
        private static short timeAdjustment;
        private static int sleepTime;
        private static final byte[] uuid;
        private static final char[] buffer;

        public static synchronized String generate() {
            UUID.updateCurrentTime();
            for (int i2 = 0; i2 < 5; ++i2) {
                UUID.buffer[4 * i2 + 1] = BASE64_DIGITS[uuid[i2 * 3] >> 2 & 0x3F];
                UUID.buffer[4 * i2 + 2] = BASE64_DIGITS[uuid[i2 * 3] << 4 & 0x30 | uuid[i2 * 3 + 1] >> 4 & 0xF];
                UUID.buffer[4 * i2 + 3] = BASE64_DIGITS[uuid[i2 * 3 + 1] << 2 & 0x3C | uuid[i2 * 3 + 2] >> 6 & 3];
                UUID.buffer[4 * i2 + 4] = BASE64_DIGITS[uuid[i2 * 3 + 2] & 0x3F];
            }
            UUID.buffer[21] = BASE64_DIGITS[uuid[15] >> 2 & 0x3F];
            UUID.buffer[22] = BASE64_DIGITS[uuid[15] << 4 & 0x30];
            return new String(buffer);
        }

        private UUID() {
        }

        private static void updateClockSequence() {
            UUID.uuid[8] = (byte)(clockSequence >> 8 & 0x3F | 0x80);
            UUID.uuid[9] = (byte)(clockSequence & 0xFF);
        }

        private static void updateCurrentTime() {
            int i2;
            long currentTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
            if (lastTime > currentTime) {
                if (16384 == (clockSequence = (short)(clockSequence + 1))) {
                    clockSequence = 0;
                }
                UUID.updateClockSequence();
            } else if (lastTime == currentTime) {
                if ((timeAdjustment = (short)(timeAdjustment + 1)) > 9999) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException exception) {
                        // empty catch block
                    }
                    timeAdjustment = 0;
                    currentTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
                    while (lastTime == currentTime) {
                        try {
                            ++sleepTime;
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException exception) {
                            // empty catch block
                        }
                        currentTime = System.currentTimeMillis() + EPOCH_ADJUSTMENT;
                    }
                }
            } else {
                timeAdjustment = 0;
            }
            lastTime = currentTime;
            currentTime *= 10000L;
            currentTime += (long)timeAdjustment;
            currentTime |= 0x1000000000000000L;
            for (i2 = 0; i2 < 4; ++i2) {
                UUID.uuid[i2] = (byte)(currentTime >> 8 * (3 - i2) & 0xFFL);
            }
            for (i2 = 0; i2 < 2; ++i2) {
                UUID.uuid[i2 + 4] = (byte)(currentTime >> 8 * (1 - i2) + 32 & 0xFFL);
            }
            for (i2 = 0; i2 < 2; ++i2) {
                UUID.uuid[i2 + 6] = (byte)(currentTime >> 8 * (1 - i2) + 48 & 0xFFL);
            }
        }

        static {
            sleepTime = 1;
            uuid = new byte[16];
            buffer = new char[23];
            SecureRandom random = new SecureRandom();
            clockSequence = (short)random.nextInt(16384);
            UUID.updateClockSequence();
            byte[] nodeAddress = new byte[6];
            random.nextBytes(nodeAddress);
            nodeAddress[0] = (byte)(nodeAddress[0] | 0xFFFFFF80);
            for (int i2 = 0; i2 < 6; ++i2) {
                UUID.uuid[i2 + 10] = nodeAddress[i2];
            }
            UUID.buffer[0] = 95;
        }
    }

    public static class UnresolvedProxyCrossReferencer
    extends CrossReferencer {
        protected UnresolvedProxyCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected UnresolvedProxyCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected UnresolvedProxyCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected UnresolvedProxyCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eIsProxy();
        }

        protected Map findUnresolvedProxyCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new UnresolvedProxyCrossReferencer(eObject).findUnresolvedProxyCrossReferences();
        }

        public static Map find(Resource resource) {
            return new UnresolvedProxyCrossReferencer(resource).findUnresolvedProxyCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new UnresolvedProxyCrossReferencer(resourceSet).findUnresolvedProxyCrossReferences();
        }

        public static Map find(Collection emfObjects) {
            return new UnresolvedProxyCrossReferencer(emfObjects).findUnresolvedProxyCrossReferences();
        }
    }

    public static class ProxyCrossReferencer
    extends CrossReferencer {
        protected ProxyCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected ProxyCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected ProxyCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected ProxyCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eIsProxy();
        }

        protected Map findProxyCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new ProxyCrossReferencer(eObject).findProxyCrossReferences();
        }

        public static Map find(Resource resource) {
            return new ProxyCrossReferencer(resource).findProxyCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new ProxyCrossReferencer(resourceSet).findProxyCrossReferences();
        }

        public static Map find(Collection emfObjects) {
            return new ProxyCrossReferencer(emfObjects).findProxyCrossReferences();
        }
    }

    public static class UsageCrossReferencer
    extends CrossReferencer {
        protected Collection eObjectsOfInterest;

        protected UsageCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected UsageCrossReferencer(Resource resource) {
            super(resource);
        }

        protected UsageCrossReferencer(ResourceSet resourceSet) {
            super(resourceSet);
        }

        protected UsageCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return this.eObjectsOfInterest.contains(crossReferencedEObject);
        }

        protected Collection findUsage(EObject eObject) {
            this.eObjectsOfInterest = Collections.singleton(eObject);
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this.getCollection(eObject);
        }

        protected Map findAllUsage(Collection eObjectsOfInterest) {
            this.eObjectsOfInterest = eObjectsOfInterest;
            this.crossReference();
            this.eObjectsOfInterest = null;
            this.done();
            return this;
        }

        public static Collection find(EObject eObjectOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findUsage(eObjectOfInterest);
        }

        public static Collection find(EObject eObjectOfInterest, Collection emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findUsage(eObjectOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, EObject eObject) {
            return new UsageCrossReferencer(eObject).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, Resource resource) {
            return new UsageCrossReferencer(resource).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, ResourceSet resourceSet) {
            return new UsageCrossReferencer(resourceSet).findAllUsage(eObjectsOfInterest);
        }

        public static Map findAll(Collection eObjectsOfInterest, Collection emfObjectsToSearch) {
            return new UsageCrossReferencer(emfObjectsToSearch).findAllUsage(eObjectsOfInterest);
        }
    }

    public static class EqualityHelper
    extends HashMap {
        public boolean equals(EObject eObject1, EObject eObject2) {
            if (eObject1 == null) {
                return eObject2 == null;
            }
            if (eObject2 == null) {
                return false;
            }
            Object eObject1MappedValue = this.get(eObject1);
            if (eObject1MappedValue != null) {
                return eObject1MappedValue == eObject2;
            }
            Object eObject2MappedValue = this.get(eObject2);
            if (eObject2MappedValue != null) {
                return eObject2MappedValue == eObject1;
            }
            if (eObject1 == eObject2) {
                this.put(eObject1, eObject2);
                this.put(eObject2, eObject1);
                return true;
            }
            EClass eClass = eObject1.eClass();
            if (eClass != eObject2.eClass()) {
                return false;
            }
            this.put(eObject1, eObject2);
            this.put(eObject2, eObject1);
            int size = eClass.getFeatureCount();
            for (int i2 = 0; i2 < size; ++i2) {
                boolean eIsSet;
                EStructuralFeature feature = eClass.getEStructuralFeature(i2);
                if (feature.isDerived() || (eIsSet = eObject1.eIsSet(feature)) == eObject2.eIsSet(feature) && !(feature instanceof EReference ? !this.haveEqualReference(eObject1, eObject2, (EReference)feature) : !this.haveEqualAttribute(eObject1, eObject2, (EAttribute)feature))) continue;
                return false;
            }
            return true;
        }

        public boolean equals(List list1, List list2) {
            int size = list1.size();
            if (size != list2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < size; ++i2) {
                EObject eObject2;
                EObject eObject1 = (EObject)list1.get(i2);
                if (this.equals(eObject1, eObject2 = (EObject)list2.get(i2))) continue;
                return false;
            }
            return true;
        }

        protected boolean haveEqualReference(EObject eObject1, EObject eObject2, EReference reference) {
            Object value1 = eObject1.eGet(reference);
            Object value2 = eObject2.eGet(reference);
            return reference.isMany() ? this.equals((List)value1, (List)value2) : this.equals((EObject)value1, (EObject)value2);
        }

        protected boolean haveEqualAttribute(EObject eObject1, EObject eObject2, EAttribute attribute) {
            Object value1 = eObject1.eGet(attribute);
            Object value2 = eObject2.eGet(attribute);
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            if (FeatureMapUtil.isFeatureMap(attribute)) {
                FeatureMap featureMap1 = (FeatureMap)value1;
                FeatureMap featureMap2 = (FeatureMap)value2;
                return this.equalFeatureMaps(featureMap1, featureMap2);
            }
            return value1.equals(value2);
        }

        protected boolean equalFeatureMaps(FeatureMap featureMap1, FeatureMap featureMap2) {
            int size = featureMap1.size();
            if (size != featureMap2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < size; ++i2) {
                EStructuralFeature feature = featureMap1.getEStructuralFeature(i2);
                if (feature != featureMap2.getEStructuralFeature(i2)) {
                    return false;
                }
                Object value1 = featureMap1.getValue(i2);
                Object value2 = featureMap2.getValue(i2);
                if (!(feature instanceof EReference ? !this.equals((EObject)value1, (EObject)value2) : (value1 == null ? value2 != null : !value1.equals(value2)))) continue;
                return false;
            }
            return true;
        }
    }

    public static class ExternalCrossReferencer
    extends CrossReferencer {
        protected ExternalCrossReferencer(Collection emfObjects) {
            super(emfObjects);
        }

        protected ExternalCrossReferencer(EObject eObject) {
            super(eObject);
        }

        protected ExternalCrossReferencer(Resource resource) {
            super(Collections.singleton(resource));
        }

        protected ExternalCrossReferencer(ResourceSet resourceSet) {
            super(Collections.singleton(resourceSet));
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return !EcoreUtil.isAncestor(this.emfObjects, crossReferencedEObject);
        }

        protected Map findExternalCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map find(EObject eObject) {
            return new ExternalCrossReferencer(eObject).findExternalCrossReferences();
        }

        public static Map find(Resource resource) {
            return new ExternalCrossReferencer(resource).findExternalCrossReferences();
        }

        public static Map find(ResourceSet resourceSet) {
            return new ExternalCrossReferencer(resourceSet).findExternalCrossReferences();
        }

        public static Map find(Collection emfObjectsToSearch) {
            return new ExternalCrossReferencer(emfObjectsToSearch).findExternalCrossReferences();
        }
    }

    public static class CrossReferencer
    extends HashMap {
        protected Collection emfObjects;

        protected CrossReferencer(EObject eObject) {
            this.emfObjects = Collections.singleton(eObject);
        }

        protected CrossReferencer(Resource resource) {
            this.emfObjects = Collections.singleton(resource);
        }

        protected CrossReferencer(ResourceSet resourceSet) {
            this.emfObjects = Collections.singleton(resourceSet);
        }

        protected CrossReferencer(Collection emfObjects) {
            this.emfObjects = emfObjects;
        }

        protected boolean containment(EObject eObject) {
            return true;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return true;
        }

        protected boolean resolve() {
            return true;
        }

        protected Collection newCollection() {
            return new ArrayList();
        }

        protected Collection getCollection(Object key) {
            Collection result = (Collection)this.get(key);
            if (result == null) {
                result = this.newCollection();
                this.put(key, result);
            }
            return result;
        }

        protected TreeIterator newContentsIterator() {
            return new ContentTreeIterator(this.emfObjects);
        }

        protected void crossReference() {
            TreeIterator contents = this.newContentsIterator();
            while (contents.hasNext()) {
                Object content = contents.next();
                if (!(content instanceof EObject)) continue;
                EObject eObject = (EObject)content;
                if (this.containment(eObject)) {
                    this.handleCrossReference(eObject);
                    continue;
                }
                contents.prune();
            }
        }

        protected EContentsEList.FeatureIterator getCrossReferences(EObject eObject) {
            return (EContentsEList.FeatureIterator)(this.resolve() ? eObject.eCrossReferences().iterator() : ((InternalEList)eObject.eCrossReferences()).basicIterator());
        }

        protected void handleCrossReference(EObject eObject) {
            InternalEObject internalEObject = (InternalEObject)eObject;
            EContentsEList.FeatureIterator crossReferences = this.getCrossReferences(internalEObject);
            while (crossReferences.hasNext()) {
                EReference eReference;
                EObject crossReferencedEObject = (EObject)crossReferences.next();
                if (crossReferencedEObject == null || !this.crossReference(internalEObject, eReference = (EReference)crossReferences.feature(), crossReferencedEObject)) continue;
                this.getCollection(crossReferencedEObject).add(internalEObject.eSetting(eReference));
            }
        }

        protected void done() {
            this.emfObjects = null;
        }

        public static Map find(Collection emfObjects) {
            CrossReferencer result = new CrossReferencer(emfObjects);
            result.crossReference();
            result.done();
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("{");
            Iterator i2 = this.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                EObject eObject = (EObject)entry.getKey();
                result.append(EcoreUtil.getIdentification(eObject));
                result.append("=[");
                Collection collection = (Collection)entry.getValue();
                Iterator j2 = collection.iterator();
                while (j2.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j2.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    result.append(eStructuralFeature.getName());
                    result.append("<-");
                    result.append(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j2.hasNext()) continue;
                    result.append(", ");
                }
                result.append(']');
            }
            result.append('}');
            return result.toString();
        }

        public static void print(PrintStream out, Map crossReferenceMap) {
            out.println('{');
            Iterator i2 = crossReferenceMap.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                EObject eObject = (EObject)entry.getKey();
                out.print(" ");
                out.print(EcoreUtil.getIdentification(eObject));
                Collection collection = (Collection)entry.getValue();
                if (collection.isEmpty()) {
                    out.println(" =[]");
                    continue;
                }
                out.println(" =[");
                Iterator j2 = collection.iterator();
                while (j2.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j2.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    out.print("   ");
                    out.print(eStructuralFeature.getName());
                    out.print("<-");
                    out.print(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j2.hasNext()) continue;
                    out.println(",");
                }
                out.println(']');
            }
            out.println('}');
        }

        public static void print(PrintStream out, Collection settings) {
            if (settings.isEmpty()) {
                out.println("[]");
            } else {
                out.println("[");
                Iterator j2 = settings.iterator();
                while (j2.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)j2.next();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    out.print(" ");
                    out.print(eStructuralFeature.getName());
                    out.print("<-");
                    out.print(EcoreUtil.getIdentification(setting.getEObject()));
                    if (!j2.hasNext()) continue;
                    out.println(",");
                }
                out.println(']');
            }
        }
    }

    public static class ContentTreeIterator
    extends AbstractTreeIterator {
        protected Collection emfObjects;
        protected ResourcesIterator resourceSetIterator;

        protected ContentTreeIterator(Collection emfObjects) {
            super(emfObjects, false);
            this.emfObjects = emfObjects;
        }

        public Iterator getChildren(Object object) {
            if (object instanceof EObject) {
                return this.getEObjectChildren((EObject)object);
            }
            if (object instanceof Resource) {
                return this.getResourceChildren((Resource)object);
            }
            if (object instanceof ResourceSet) {
                return this.getResourceSetChildren((ResourceSet)object);
            }
            if (object == this.emfObjects) {
                return this.emfObjects.iterator();
            }
            return this.getObjectChildren(object);
        }

        protected Iterator getEObjectChildren(EObject eObject) {
            return eObject.eContents().iterator();
        }

        protected Iterator getResourceChildren(Resource resource) {
            return resource.getContents().iterator();
        }

        public boolean hasNext() {
            Iterator iterator;
            if (!this.includeRoot && this.data == null) {
                this.nextPruneIterator = this.getChildren(this.object);
                this.add(this.nextPruneIterator);
                iterator = this.nextPruneIterator;
            } else {
                if (this.data == null) {
                    return true;
                }
                if (this.isEmpty()) {
                    return false;
                }
                iterator = (Iterator)this.data[this.size - 1];
            }
            if (iterator == this.resourceSetIterator && !this.resourceSetIterator.reallyHasNext()) {
                this.next();
                return this.hasNext();
            }
            return iterator.hasNext();
        }

        protected Iterator getResourceSetChildren(ResourceSet resourceSet) {
            this.resourceSetIterator = new ResourcesIterator(resourceSet.getResources());
            return this.resourceSetIterator;
        }

        protected Iterator getObjectChildren(Object object) {
            return ECollections.EMPTY_ELIST.iterator();
        }

        protected static class ResourcesIterator
        implements Iterator {
            protected List resources;
            protected int index = 0;

            public ResourcesIterator(List resources) {
                this.resources = resources;
            }

            public boolean reallyHasNext() {
                return this.index < this.resources.size();
            }

            public boolean hasNext() {
                return this.index <= this.resources.size();
            }

            public Object next() {
                if (this.index >= this.resources.size()) {
                    ++this.index;
                    return null;
                }
                return this.resources.get(this.index++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class Copier
    extends HashMap {
        public Collection copyAll(Collection eObjects) {
            ArrayList<EObject> result = new ArrayList<EObject>(eObjects.size());
            Iterator i2 = eObjects.iterator();
            while (i2.hasNext()) {
                result.add(this.copy((EObject)i2.next()));
            }
            return result;
        }

        public EObject copy(EObject eObject) {
            EObject copyEObject = this.createCopy(eObject);
            this.put(eObject, copyEObject);
            EClass eClass = eObject.eClass();
            int size = eClass.getFeatureCount();
            for (int i2 = 0; i2 < size; ++i2) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i2);
                if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived()) continue;
                if (eStructuralFeature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)eStructuralFeature, eObject, copyEObject);
                    continue;
                }
                EReference eReference = (EReference)eStructuralFeature;
                if (!eReference.isContainment()) continue;
                this.copyContainment(eReference, eObject, copyEObject);
            }
            return copyEObject;
        }

        protected EObject createCopy(EObject eObject) {
            return EcoreUtil.create(this.getTarget(eObject.eClass()));
        }

        protected EClass getTarget(EClass eClass) {
            return eClass;
        }

        protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature;
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet(eReference)) {
                if (eReference.isMany()) {
                    List source = (List)eObject.eGet(eReference);
                    List target = (List)copyEObject.eGet(this.getTarget(eReference));
                    if (source.isEmpty()) {
                        target.clear();
                    } else {
                        target.addAll(this.copyAll(source));
                    }
                } else {
                    EObject childEObject = (EObject)eObject.eGet(eReference);
                    copyEObject.eSet(this.getTarget(eReference), childEObject == null ? null : this.copy(childEObject));
                }
            }
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet(eAttribute)) {
                if (FeatureMapUtil.isFeatureMap(eAttribute)) {
                    FeatureMap featureMap = (FeatureMap)eObject.eGet(eAttribute);
                    int size = featureMap.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        Object value;
                        EStructuralFeature feature = featureMap.getEStructuralFeature(i2);
                        if (!(feature instanceof EReference) || !((EReference)feature).isContainment() || (value = featureMap.getValue(i2)) == null) continue;
                        this.copy((EObject)value);
                    }
                } else if (eAttribute.isMany()) {
                    List source = (List)eObject.eGet(eAttribute);
                    List target = (List)copyEObject.eGet(this.getTarget(eAttribute));
                    if (source.isEmpty()) {
                        target.clear();
                    } else {
                        target.addAll(source);
                    }
                } else {
                    copyEObject.eSet(this.getTarget(eAttribute), eObject.eGet(eAttribute));
                }
            }
        }

        public void copyReferences() {
            Iterator i2 = this.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                EObject eObject = (EObject)entry.getKey();
                EObject copyEObject = (EObject)entry.getValue();
                EClass eClass = eObject.eClass();
                int size = eClass.getFeatureCount();
                for (int j2 = 0; j2 < size; ++j2) {
                    EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(j2);
                    if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived()) continue;
                    if (eStructuralFeature instanceof EReference) {
                        EReference eReference = (EReference)eStructuralFeature;
                        if (eReference.isContainment()) continue;
                        this.copyReference(eReference, eObject, copyEObject);
                        continue;
                    }
                    if (!FeatureMapUtil.isFeatureMap(eStructuralFeature)) continue;
                    FeatureMap featureMap = (FeatureMap)eObject.eGet(eStructuralFeature);
                    FeatureMap copyFeatureMap = (FeatureMap)copyEObject.eGet(this.getTarget(eStructuralFeature));
                    int featureMapSize = featureMap.size();
                    for (int k2 = 0; k2 < featureMapSize; ++k2) {
                        EStructuralFeature feature = featureMap.getEStructuralFeature(k2);
                        if (feature instanceof EReference) {
                            Object referencedEObject = featureMap.getValue(k2);
                            Object copyReferencedEObject = this.get(referencedEObject);
                            copyFeatureMap.add(feature, copyReferencedEObject == null ? referencedEObject : copyReferencedEObject);
                            continue;
                        }
                        copyFeatureMap.add(featureMap.get(k2));
                    }
                }
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet(eReference)) {
                if (eReference.isMany()) {
                    List source = (List)eObject.eGet(eReference);
                    InternalEList target = (InternalEList)copyEObject.eGet(this.getTarget(eReference));
                    if (source.isEmpty()) {
                        target.clear();
                    } else {
                        boolean isBidirectional = eReference.getEOpposite() != null;
                        int index = 0;
                        Iterator k2 = source.iterator();
                        while (k2.hasNext()) {
                            Object referencedEObject = k2.next();
                            Object copyReferencedEObject = this.get(referencedEObject);
                            if (copyReferencedEObject == null) {
                                if (isBidirectional) continue;
                                target.addUnique(index, referencedEObject);
                                ++index;
                                continue;
                            }
                            if (isBidirectional) {
                                int position = target.indexOf(copyReferencedEObject);
                                if (position == -1) {
                                    target.addUnique(index, copyReferencedEObject);
                                } else if (index != position) {
                                    target.move(index, copyReferencedEObject);
                                }
                            } else {
                                target.addUnique(index, copyReferencedEObject);
                            }
                            ++index;
                        }
                    }
                } else {
                    Object referencedEObject = eObject.eGet(eReference);
                    if (referencedEObject == null) {
                        copyEObject.eSet(this.getTarget(eReference), null);
                    } else {
                        Object copyReferencedEObject = this.get(referencedEObject);
                        if (copyReferencedEObject == null) {
                            if (eReference.getEOpposite() == null) {
                                copyEObject.eSet(this.getTarget(eReference), referencedEObject);
                            }
                        } else {
                            copyEObject.eSet(this.getTarget(eReference), copyReferencedEObject);
                        }
                    }
                }
            }
        }
    }
}

