/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;

public class BasicDiagnostic
implements Diagnostic,
DiagnosticChain {
    protected int severity;
    protected String message;
    protected List children;
    protected List data;
    protected String source;
    protected int code;

    public BasicDiagnostic(String source, int code, String message, Object[] data) {
        this.source = source;
        this.code = code;
        this.message = message;
        this.data = this.dataAsList(data);
    }

    public BasicDiagnostic(int severity, String source, int code, String message, Object[] data) {
        this(source, code, message, data);
        this.severity = severity;
    }

    public BasicDiagnostic(String source, int code, List children, String message, Object[] data) {
        this(source, code, message, data);
        if (children != null) {
            Iterator i2 = children.iterator();
            while (i2.hasNext()) {
                this.add((Diagnostic)i2.next());
            }
        }
    }

    protected List dataAsList(Object[] data) {
        if (data == null) {
            return Collections.EMPTY_LIST;
        }
        Object[] copy = new Object[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return new BasicEList.UnmodifiableEList(copy.length, copy);
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public List getData() {
        return this.data;
    }

    public List getChildren() {
        return this.children == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.children);
    }

    public String getSource() {
        return this.source;
    }

    public int getCode() {
        return this.code;
    }

    public void add(Diagnostic diagnostic) {
        if (this.children == null) {
            this.children = new BasicEList();
        }
        this.children.add(diagnostic);
        int childSeverity = diagnostic.getSeverity();
        if (childSeverity > this.getSeverity()) {
            this.severity = childSeverity;
        }
    }

    public void addAll(Diagnostic diagnostic) {
        Iterator i2 = diagnostic.getChildren().iterator();
        while (i2.hasNext()) {
            this.add((Diagnostic)i2.next());
        }
    }

    public void merge(Diagnostic diagnostic) {
        if (diagnostic.getChildren().isEmpty()) {
            this.add(diagnostic);
        } else {
            this.addAll(diagnostic);
        }
    }

    public int recomputeSeverity() {
        if (this.children != null) {
            this.severity = 0;
            Iterator i2 = this.children.iterator();
            while (i2.hasNext()) {
                int childSeverity;
                Diagnostic child = (Diagnostic)i2.next();
                int n2 = childSeverity = child instanceof BasicDiagnostic ? ((BasicDiagnostic)child).recomputeSeverity() : child.getSeverity();
                if (childSeverity <= this.severity) continue;
                this.severity = childSeverity;
            }
        }
        return this.severity;
    }

    public static IStatus toIStatus(Diagnostic diagnostic) {
        return Wrapper.create(diagnostic);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Diagnostic ");
        switch (this.severity) {
            case 0: {
                result.append("OK");
                break;
            }
            case 1: {
                result.append("INFO");
                break;
            }
            case 2: {
                result.append("WARNING");
                break;
            }
            case 4: {
                result.append("ERROR");
                break;
            }
            case 8: {
                result.append("CANCEL");
                break;
            }
            default: {
                result.append(Integer.toHexString(this.severity));
            }
        }
        result.append(" source=");
        result.append(this.source);
        result.append(" code=");
        result.append(this.code);
        result.append(' ');
        result.append(this.message);
        if (this.data != null) {
            result.append(" data=");
            result.append(this.data);
        }
        if (this.children != null) {
            result.append(' ');
            result.append(this.children);
        }
        return result.toString();
    }

    private static class Wrapper
    implements IStatus {
        protected static final IStatus[] EMPTY_CHILDREN = new IStatus[0];
        protected Diagnostic diagnostic;
        protected IStatus[] wrappedChildren;

        public Wrapper(Diagnostic diagnostic) {
            this.diagnostic = diagnostic;
        }

        public IStatus[] getChildren() {
            if (this.wrappedChildren == null) {
                List children = this.diagnostic.getChildren();
                if (children.isEmpty()) {
                    this.wrappedChildren = EMPTY_CHILDREN;
                } else {
                    this.wrappedChildren = new IStatus[children.size()];
                    int i2 = 0;
                    while (i2 < this.wrappedChildren.length) {
                        this.wrappedChildren[i2] = BasicDiagnostic.toIStatus((Diagnostic)children.get(i2));
                        ++i2;
                    }
                }
            }
            return this.wrappedChildren;
        }

        public int getCode() {
            return this.diagnostic.getCode();
        }

        public Throwable getException() {
            Iterator i2 = this.diagnostic.getData().iterator();
            while (i2.hasNext()) {
                Object data = i2.next();
                if (!(data instanceof Throwable)) continue;
                return (Throwable)data;
            }
            return null;
        }

        public String getMessage() {
            return this.diagnostic.getMessage();
        }

        public String getPlugin() {
            return this.diagnostic.getSource();
        }

        public int getSeverity() {
            return this.diagnostic.getSeverity();
        }

        public boolean isMultiStatus() {
            return !this.diagnostic.getChildren().isEmpty();
        }

        public boolean isOK() {
            return this.diagnostic.getSeverity() == 0;
        }

        public boolean matches(int severityMask) {
            return (this.diagnostic.getSeverity() & severityMask) != 0;
        }

        public String toString() {
            return this.diagnostic.toString();
        }

        public static IStatus create(Diagnostic diagnostic) {
            return new Wrapper(diagnostic);
        }
    }
}

