/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.jobs;

import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class MultiRule
implements ISchedulingRule {
    private ISchedulingRule[] rules;

    public static ISchedulingRule combine(ISchedulingRule[] ruleArray) {
        ISchedulingRule result = null;
        int i2 = 0;
        while (i2 < ruleArray.length) {
            if (ruleArray[i2] != null) {
                result = result == null ? ruleArray[i2] : MultiRule.combine(result, ruleArray[i2]);
            }
            ++i2;
        }
        return result;
    }

    public static ISchedulingRule combine(ISchedulingRule rule1, ISchedulingRule rule2) {
        if (rule1 == rule2) {
            return rule1;
        }
        if (rule1 == null) {
            return rule2;
        }
        if (rule2 == null) {
            return rule1;
        }
        if (rule1.contains(rule2)) {
            return rule1;
        }
        if (rule2.contains(rule1)) {
            return rule2;
        }
        MultiRule result = new MultiRule();
        result.rules = new ISchedulingRule[]{rule1, rule2};
        if (rule1 instanceof MultiRule || rule2 instanceof MultiRule) {
            result.rules = MultiRule.flatten(result.rules);
        }
        return result;
    }

    private static ISchedulingRule[] flatten(ISchedulingRule[] nestedRules) {
        ArrayList<ISchedulingRule> myRules = new ArrayList<ISchedulingRule>(nestedRules.length);
        int i2 = 0;
        while (i2 < nestedRules.length) {
            if (nestedRules[i2] instanceof MultiRule) {
                ISchedulingRule[] children = ((MultiRule)nestedRules[i2]).getChildren();
                int j2 = 0;
                while (j2 < children.length) {
                    myRules.add(children[j2]);
                    ++j2;
                }
            } else {
                myRules.add(nestedRules[i2]);
            }
            ++i2;
        }
        return myRules.toArray(new ISchedulingRule[myRules.size()]);
    }

    public MultiRule(ISchedulingRule[] nestedRules) {
        this.rules = MultiRule.flatten(nestedRules);
    }

    private MultiRule() {
    }

    public ISchedulingRule[] getChildren() {
        return (ISchedulingRule[])this.rules.clone();
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] otherRules = ((MultiRule)rule).getChildren();
            int other = 0;
            while (other < otherRules.length) {
                boolean found = false;
                int mine = 0;
                while (!found && mine < this.rules.length) {
                    found = this.rules[mine].contains(otherRules[other]);
                    ++mine;
                }
                if (!found) {
                    return false;
                }
                ++other;
            }
            return true;
        }
        int i2 = 0;
        while (i2 < this.rules.length) {
            if (this.rules[i2].contains(rule)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] otherRules = ((MultiRule)rule).getChildren();
            int j2 = 0;
            while (j2 < otherRules.length) {
                int i2 = 0;
                while (i2 < this.rules.length) {
                    if (this.rules[i2].isConflicting(otherRules[j2])) {
                        return true;
                    }
                    ++i2;
                }
                ++j2;
            }
        } else {
            int i3 = 0;
            while (i3 < this.rules.length) {
                if (this.rules[i3].isConflicting(rule)) {
                    return true;
                }
                ++i3;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MultiRule[");
        int last = this.rules.length - 1;
        int i2 = 0;
        while (i2 < this.rules.length) {
            buffer.append(this.rules[i2]);
            if (i2 != last) {
                buffer.append(',');
            }
            ++i2;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

