/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.watson;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.dtree.DataTreeWriter;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.dtree.IDataFlattener;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.IElementComparator;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ElementTreeWriter {
    public static final int CURRENT_FORMAT = 1;
    public static final int D_INFINITE = -1;
    protected DataTreeWriter dataTreeWriter;

    public ElementTreeWriter(final IElementInfoFlattener flattener) {
        IDataFlattener f2 = new IDataFlattener(){

            public void writeData(IPath path, Object data, DataOutput output) throws IOException {
                if (!Path.ROOT.equals(path)) {
                    flattener.writeElement(path, data, output);
                }
            }

            public Object readData(IPath path, DataInput input) {
                return null;
            }
        };
        this.dataTreeWriter = new DataTreeWriter(f2);
    }

    protected ElementTree[] sortTrees(ElementTree[] trees, DataOutput output) throws IOException {
        int numTrees = trees.length;
        ElementTree[] sorted = new ElementTree[numTrees];
        int[] order = new int[numTrees];
        HashMap<ElementTree, ArrayList<Integer>> table = new HashMap<ElementTree, ArrayList<Integer>>(numTrees * 2 + 1);
        int i2 = 0;
        while (i2 < trees.length) {
            ArrayList<Integer> indices = (ArrayList<Integer>)table.get(trees[i2]);
            if (indices == null) {
                indices = new ArrayList<Integer>();
                table.put(trees[i2], indices);
            }
            indices.add(new Integer(i2));
            ++i2;
        }
        ElementTree oldest = trees[ElementTree.findOldest(trees)];
        int i3 = numTrees - 1;
        while (i3 >= 0) {
            List indices = (List)table.remove(oldest);
            Enumeration e2 = Collections.enumeration(indices);
            while (e2.hasMoreElements()) {
                Integer next = (Integer)e2.nextElement();
                sorted[i3] = oldest;
                order[i3] = next;
                --i3;
            }
            if (i3 < 0) continue;
            ElementTree parent = oldest.getParent();
            while (table.get(parent) == null) {
                parent = parent.getParent();
            }
            oldest = parent;
        }
        i3 = 0;
        while (i3 < numTrees) {
            this.writeNumber(order[i3], output);
            ++i3;
        }
        return sorted;
    }

    public void writeDelta(ElementTree olderTree, ElementTree newerTree, IPath path, int depth, DataOutput output, IElementComparator comparator) throws IOException {
        this.writeNumber(1, output);
        DeltaDataTree completeTree = newerTree.getDataTree();
        DeltaDataTree derivedTree = olderTree.getDataTree();
        DeltaDataTree deltaToWrite = null;
        deltaToWrite = completeTree.forwardDeltaWith(derivedTree, comparator);
        Assert.isTrue(deltaToWrite.isImmutable());
        this.dataTreeWriter.writeTree(deltaToWrite, path, depth, output);
    }

    public void writeDeltaChain(ElementTree[] trees, IPath path, int depth, DataOutput output, IElementComparator comparator) throws IOException {
        this.writeNumber(1, output);
        int treeCount = trees.length;
        this.writeNumber(treeCount, output);
        if (treeCount <= 0) {
            return;
        }
        ElementTree[] sortedTrees = this.sortTrees(trees, output);
        this.writeTree(sortedTrees[0], path, depth, output);
        int i2 = 1;
        while (i2 < treeCount) {
            this.writeDelta(sortedTrees[i2], sortedTrees[i2 - 1], path, depth, output, comparator);
            ++i2;
        }
    }

    protected void writeNumber(int number, DataOutput output) throws IOException {
        if (number >= 0 && number < 255) {
            output.writeByte(number);
        } else {
            output.writeByte(255);
            output.writeInt(number);
        }
    }

    public void writeTree(ElementTree tree, IPath path, int depth, DataOutput output) throws IOException {
        this.writeNumber(1, output);
        DeltaDataTree subtree = new DeltaDataTree(tree.getDataTree().copyCompleteSubtree(Path.ROOT));
        this.dataTreeWriter.writeTree(subtree, path, depth, output);
    }
}

