/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class Convert {
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();

    public static String fromUTF8(byte[] b2) {
        String result;
        try {
            result = new String(b2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = new String(b2);
        }
        return result;
    }

    public static byte[] toUTF8(String s2) {
        byte[] result;
        try {
            result = s2.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            result = s2.getBytes();
        }
        return result;
    }

    public static byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        int i2 = 0;
        while (i2 < bytes.length) {
            bytes[bytes.length - 1 - i2] = (byte)value;
            value >>>= 8;
            ++i2;
        }
        return bytes;
    }

    public static long bytesToLong(byte[] value) {
        long longValue = 0L;
        int i2 = 0;
        while (i2 < value.length) {
            longValue <<= 8;
            longValue ^= (long)(value[i2] & 0xFF);
            ++i2;
        }
        return longValue;
    }

    public static byte[] toPlatformBytes(String target) {
        if (defaultEncoding == null) {
            return target.getBytes();
        }
        try {
            return target.getBytes(defaultEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            defaultEncoding = null;
            return target.getBytes();
        }
    }
}

