/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

public class ListenerList {
    private static final Object[] EmptyArray = new Object[0];
    public static final int EQUALITY = 0;
    public static final int IDENTITY = 1;
    private final int compareMode;
    private volatile Object[] listeners = EmptyArray;

    public ListenerList() {
        this(0);
    }

    public ListenerList(int mode) {
        this.compareMode = mode;
    }

    public synchronized void add(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i2 = 0;
        while (i2 < oldSize) {
            if (this.same(listener, this.listeners[i2])) {
                return;
            }
            ++i2;
        }
        Object[] newListeners = new Object[oldSize + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = listener;
        this.listeners = newListeners;
    }

    public Object[] getListeners() {
        return this.listeners;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i2 = 0;
        while (i2 < oldSize) {
            if (this.same(listener, this.listeners[i2])) {
                if (oldSize == 1) {
                    this.listeners = EmptyArray;
                } else {
                    Object[] newListeners = new Object[oldSize - 1];
                    System.arraycopy(this.listeners, 0, newListeners, 0, i2);
                    System.arraycopy(this.listeners, i2 + 1, newListeners, i2, oldSize - i2 - 1);
                    this.listeners = newListeners;
                }
                return;
            }
            ++i2;
        }
    }

    private boolean same(Object listener1, Object listener2) {
        return this.compareMode == 1 ? listener1 == listener2 : listener1.equals(listener2);
    }

    public int size() {
        return this.listeners.length;
    }
}

