/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class FindSupport {
    private static String[] NL_JAR_VARIANTS = FindSupport.buildNLVariants(InternalPlatform.getDefault().getNL());

    private static String[] buildNLVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        Path base = new Path("nl");
        IPath path = new Path(nl.replace('_', '/'));
        while (path.segmentCount() > 0) {
            result.add(base.append(path).toString());
            if (path.segmentCount() > 1) {
                result.add(base.append(path.toString().replace('/', '_')).toString());
            }
            path = path.removeLastSegments(1);
        }
        return result.toArray(new String[result.size()]);
    }

    public static URL find(Bundle bundle, IPath path) {
        return FindSupport.find(bundle, path, null);
    }

    public static URL find(Bundle b2, IPath path, Map override) {
        if (path == null) {
            return null;
        }
        URL result = null;
        if (path.isEmpty() || path.isRoot()) {
            result = FindSupport.findInPlugin(b2, Path.EMPTY);
            if (result == null) {
                result = FindSupport.findInFragments(b2, Path.EMPTY);
            }
            return result;
        }
        String first = path.segment(0);
        if (first.charAt(0) != '$') {
            result = FindSupport.findInPlugin(b2, path);
            if (result == null) {
                result = FindSupport.findInFragments(b2, path);
            }
            return result;
        }
        IPath rest = path.removeFirstSegments(1);
        if (first.equalsIgnoreCase("$nl$")) {
            return FindSupport.findNL(b2, rest, override);
        }
        if (first.equalsIgnoreCase("$os$")) {
            return FindSupport.findOS(b2, rest, override);
        }
        if (first.equalsIgnoreCase("$ws$")) {
            return FindSupport.findWS(b2, rest, override);
        }
        if (first.equalsIgnoreCase("$files$")) {
            return null;
        }
        return null;
    }

    private static URL findOS(Bundle b2, IPath path, Map override) {
        String os = null;
        if (override != null) {
            try {
                os = (String)override.get("$os$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (os == null) {
            os = InternalPlatform.getDefault().getOS();
        }
        if (os.length() == 0) {
            return null;
        }
        String osArch = null;
        if (override != null) {
            try {
                osArch = (String)override.get("$arch$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (osArch == null) {
            osArch = InternalPlatform.getDefault().getOSArch();
        }
        if (osArch.length() == 0) {
            return null;
        }
        URL result = null;
        IPath base = new Path("os").append(os).append(osArch);
        while (base.segmentCount() != 1) {
            IPath filePath = base.append(path);
            result = FindSupport.findInPlugin(b2, filePath);
            if (result != null) {
                return result;
            }
            result = FindSupport.findInFragments(b2, filePath);
            if (result != null) {
                return result;
            }
            base = base.removeLastSegments(1);
        }
        result = FindSupport.findInPlugin(b2, path);
        if (result != null) {
            return result;
        }
        return FindSupport.findInFragments(b2, path);
    }

    private static URL findWS(Bundle b2, IPath path, Map override) {
        IPath filePath;
        URL result;
        String ws = null;
        if (override != null) {
            try {
                ws = (String)override.get("$ws$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (ws == null) {
            ws = InternalPlatform.getDefault().getWS();
        }
        if ((result = FindSupport.findInPlugin(b2, filePath = new Path("ws").append(ws).append(path))) != null) {
            return result;
        }
        result = FindSupport.findInFragments(b2, filePath);
        if (result != null) {
            return result;
        }
        result = FindSupport.findInPlugin(b2, path);
        if (result != null) {
            return result;
        }
        return FindSupport.findInFragments(b2, path);
    }

    private static URL findNL(Bundle b2, IPath path, Map override) {
        String nl = null;
        String[] nlVariants = null;
        if (override != null) {
            try {
                nl = (String)override.get("$nl$");
            }
            catch (ClassCastException classCastException) {}
        }
        String[] stringArray = nlVariants = nl == null ? NL_JAR_VARIANTS : FindSupport.buildNLVariants(nl);
        if (nl != null && nl.length() == 0) {
            return null;
        }
        URL result = null;
        int i2 = 0;
        while (i2 < nlVariants.length) {
            IPath filePath = new Path(nlVariants[i2]).append(path);
            result = FindSupport.findInPlugin(b2, filePath);
            if (result != null) {
                return result;
            }
            result = FindSupport.findInFragments(b2, filePath);
            if (result != null) {
                return result;
            }
            ++i2;
        }
        result = FindSupport.findInPlugin(b2, path);
        if (result != null) {
            return result;
        }
        return FindSupport.findInFragments(b2, path);
    }

    private static URL findInPlugin(Bundle b2, IPath filePath) {
        return b2.getEntry(filePath.toString());
    }

    private static URL findInFragments(Bundle b2, IPath filePath) {
        Bundle[] fragments = InternalPlatform.getDefault().getFragments(b2);
        if (fragments == null) {
            return null;
        }
        URL fileURL = null;
        int i2 = 0;
        while (i2 < fragments.length && fileURL == null) {
            fileURL = fragments[i2].getEntry(filePath.toString());
            ++i2;
        }
        return fileURL;
    }

    public static final InputStream openStream(Bundle bundle, IPath file, boolean localized) throws IOException {
        URL url = null;
        if (!localized) {
            url = FindSupport.findInPlugin(bundle, file);
            if (url == null) {
                url = FindSupport.findInFragments(bundle, file);
            }
        } else {
            url = FindSupport.find(bundle, file);
        }
        if (url != null) {
            return url.openStream();
        }
        throw new IOException("Cannot find " + file.toString());
    }
}

