/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Random;

public class Cipher {
    public static final int DECRYPT_MODE = -1;
    public static final int ENCRYPT_MODE = 1;
    private static final int RANDOM_SIZE = 16;
    private int mode = 0;
    private byte[] password = null;
    private byte[] byteStream;
    private int byteStreamOffset;
    private MessageDigest digest;
    private Random random;
    private final byte[] toDigest;

    public Cipher(int mode, String passwordString) {
        this.mode = mode;
        try {
            this.password = passwordString.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.password = passwordString.getBytes();
        }
        this.toDigest = new byte[this.password.length + 16];
    }

    public byte[] cipher(byte[] data) throws Exception {
        return this.transform(data, 0, data.length, this.mode);
    }

    public byte[] cipher(byte[] data, int off, int len) throws Exception {
        return this.transform(data, off, len, this.mode);
    }

    public byte cipher(byte datum) throws Exception {
        byte[] data = new byte[]{datum};
        return this.cipher(data)[0];
    }

    private byte[] generateBytes() throws Exception {
        if (this.digest == null) {
            this.digest = MessageDigest.getInstance("SHA");
            long seed = 0L;
            int i2 = 0;
            while (i2 < this.password.length) {
                seed = seed * 37L + (long)this.password[i2];
                ++i2;
            }
            this.random = new Random(seed);
        }
        this.random.nextBytes(this.toDigest);
        System.arraycopy(this.password, 0, this.toDigest, 0, this.password.length);
        return this.digest.digest(this.toDigest);
    }

    private byte[] nextRandom(int length) throws Exception {
        byte[] nextRandom = new byte[length];
        int nextRandomOffset = 0;
        while (nextRandomOffset < length) {
            if (this.byteStream == null || this.byteStreamOffset >= this.byteStream.length) {
                this.byteStream = this.generateBytes();
                this.byteStreamOffset = 0;
            }
            nextRandom[nextRandomOffset++] = this.byteStream[this.byteStreamOffset++];
        }
        return nextRandom;
    }

    private byte[] transform(byte[] data, int off, int len, int mod) throws Exception {
        byte[] result = this.nextRandom(len);
        int i2 = 0;
        while (i2 < len) {
            result[i2] = (byte)(data[i2 + off] + mod * result[i2]);
            ++i2;
        }
        return result;
    }
}

