/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.SyncInfoReader;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.ObjectMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class SyncInfoReader_3
extends SyncInfoReader {
    public static final byte INDEX = 1;
    public static final byte QNAME = 2;

    public SyncInfoReader_3(Workspace workspace, Synchronizer synchronizer) {
        super(workspace, synchronizer);
    }

    public void readSyncInfo(DataInputStream input) throws IOException, CoreException {
        try {
            ArrayList readPartners = new ArrayList(5);
            while (true) {
                Path path = new Path(input.readUTF());
                this.readSyncInfo(path, input, readPartners);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void readSyncInfo(IPath path, DataInputStream input, List readPartners) throws IOException, CoreException {
        int size = input.readInt();
        ObjectMap table = new ObjectMap(size);
        int i2 = 0;
        while (i2 < size) {
            QualifiedName name = null;
            byte type = input.readByte();
            switch (type) {
                case 2: {
                    String qualifier = input.readUTF();
                    String local = input.readUTF();
                    name = new QualifiedName(qualifier, local);
                    readPartners.add(name);
                    break;
                }
                case 1: {
                    name = (QualifiedName)readPartners.get(input.readInt());
                    break;
                }
                default: {
                    String msg = NLS.bind(Messages.resources_readSync, path == null ? "" : path.toString());
                    throw new ResourceException(567, path, msg, null);
                }
            }
            int length = input.readInt();
            byte[] bytes = new byte[length];
            input.readFully(bytes);
            table.put(name, bytes);
            ++i2;
        }
        ResourceInfo info = this.workspace.getResourceInfo(path, true, false);
        if (info == null) {
            return;
        }
        info.setSyncInfo(table);
        info.clear(8192);
    }
}

