/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SafeFileTable {
    protected IPath location;
    protected Properties table;

    public SafeFileTable(String pluginId) throws CoreException {
        this.location = this.getWorkspace().getMetaArea().getSafeTableLocationFor(pluginId);
        this.restore();
    }

    public IPath[] getFiles() {
        Set<Object> set = this.table.keySet();
        String[] keys = set.toArray(new String[set.size()]);
        IPath[] files = new IPath[keys.length];
        int i2 = 0;
        while (i2 < keys.length) {
            files[i2] = new Path(keys[i2]);
            ++i2;
        }
        return files;
    }

    protected Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    public IPath lookup(IPath file) {
        String result = this.table.getProperty(file.toOSString());
        return result == null ? null : new Path(result);
    }

    public void map(IPath file, IPath aLocation) {
        if (aLocation == null) {
            this.table.remove(file);
        } else {
            this.table.setProperty(file.toOSString(), aLocation.toOSString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restore() throws CoreException {
        File target = this.location.toFile();
        this.table = new Properties();
        if (!target.exists()) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(target);
            try {
                this.table.load(input);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                input.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                input.close();
                return;
            }
        }
        catch (IOException e2) {
            String message = Messages.resources_exSafeRead;
            throw new ResourceException(566, null, message, e2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws CoreException {
        File target = this.location.toFile();
        try {
            FileOutputStream output = new FileOutputStream(target);
            try {
                this.table.store(output, "safe table");
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                output.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                output.close();
                return;
            }
        }
        catch (IOException e2) {
            String message = Messages.resources_exSafeSave;
            throw new ResourceException(566, null, message, e2);
        }
    }

    public void setLocation(IPath location) {
        if (location != null) {
            this.location = location;
        }
    }
}

