/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.refresh;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.refresh.PollingMonitor;
import org.eclipse.core.internal.refresh.RefreshManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IPathVariableChangeEvent;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.refresh.IRefreshMonitor;
import org.eclipse.core.resources.refresh.RefreshProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

class MonitorManager
implements ILifecycleListener,
IPathVariableChangeListener {
    protected final PollingMonitor pollMonitor;
    private RefreshProvider[] providers;
    protected final RefreshManager refreshManager;
    protected final Map registeredMonitors;
    protected IWorkspace workspace;

    public MonitorManager(IWorkspace workspace, RefreshManager refreshManager) {
        this.workspace = workspace;
        this.refreshManager = refreshManager;
        this.registeredMonitors = Collections.synchronizedMap(new HashMap(10));
        this.pollMonitor = new PollingMonitor(refreshManager);
    }

    private RefreshProvider[] getRefreshProviders() {
        if (this.providers != null) {
            return this.providers;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "refreshProviders");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        ArrayList<RefreshProvider> providerList = new ArrayList<RefreshProvider>(infos.length);
        int i2 = 0;
        while (i2 < infos.length) {
            IConfigurationElement configurationElement = infos[i2];
            RefreshProvider provider = null;
            try {
                provider = (RefreshProvider)configurationElement.createExecutableExtension("class");
            }
            catch (CoreException e2) {
                Status status = new Status(2, "org.eclipse.core.resources", 1, Messages.refresh_installError, e2);
                ResourcesPlugin.getPlugin().getLog().log(status);
            }
            if (provider != null) {
                providerList.add(provider);
            }
            ++i2;
        }
        this.providers = providerList.toArray(new RefreshProvider[providerList.size()]);
        return this.providers;
    }

    private List getResourcesToMonitor() {
        ArrayList<IResource> resourcesToMonitor = new ArrayList<IResource>(10);
        IProject[] projects = this.workspace.getRoot().getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            if (projects[i2].isAccessible()) {
                resourcesToMonitor.add(projects[i2]);
                try {
                    IResource[] members = projects[i2].members();
                    int j2 = 0;
                    while (j2 < members.length) {
                        if (members[j2].isLinked()) {
                            resourcesToMonitor.add(members[j2]);
                        }
                        ++j2;
                    }
                }
                catch (CoreException e2) {
                    Status status = new Status(2, "org.eclipse.core.resources", 1, Messages.refresh_refreshErr, e2);
                    ResourcesPlugin.getPlugin().getLog().log(status);
                }
            }
            ++i2;
        }
        return resourcesToMonitor;
    }

    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 32: 
            case 512: {
                this.monitor(event.resource);
                break;
            }
            case 1: 
            case 16: 
            case 1024: {
                this.unmonitor(event.resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMonitoring(IResource resource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            List resources;
            Iterator i2 = this.registeredMonitors.keySet().iterator();
            do {
                if (i2.hasNext()) continue;
                return false;
            } while ((resources = (List)this.registeredMonitors.get(i2.next())) == null || !resources.contains(resource));
            return true;
        }
    }

    boolean monitor(IResource resource) {
        if (this.isMonitoring(resource)) {
            return false;
        }
        boolean pollingMonitorNeeded = true;
        RefreshProvider[] refreshProviders = this.getRefreshProviders();
        int i2 = 0;
        while (i2 < refreshProviders.length) {
            IRefreshMonitor monitor = this.safeInstallMonitor(refreshProviders[i2], resource);
            if (monitor != null) {
                this.registerMonitor(monitor, resource);
                pollingMonitorNeeded = false;
            }
            ++i2;
        }
        if (pollingMonitorNeeded) {
            this.pollMonitor.monitor(resource);
            this.registerMonitor(this.pollMonitor, resource);
        }
        return pollingMonitorNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorFailed(IRefreshMonitor monitor, IResource resource) {
        if (RefreshManager.DEBUG) {
            System.err.println("Auto-refresh:  monitor (" + monitor + ") failed to monitor resource: " + resource);
        }
        if (this.registeredMonitors == null || monitor == null) {
            return;
        }
        if (resource == null) {
            List resources = (List)this.registeredMonitors.get(monitor);
            if (resources == null || resources.isEmpty()) {
                this.registeredMonitors.remove(monitor);
                return;
            }
            Map map = this.registeredMonitors;
            synchronized (map) {
                Iterator i2 = resources.iterator();
                while (i2.hasNext()) {
                    resource = (IResource)i2.next();
                    this.pollMonitor.monitor(resource);
                    this.registerMonitor(this.pollMonitor, resource);
                }
                this.registeredMonitors.remove(monitor);
            }
        } else {
            this.removeMonitor(monitor, resource);
            this.pollMonitor.monitor(resource);
            this.registerMonitor(this.pollMonitor, resource);
        }
    }

    public void pathVariableChanged(IPathVariableChangeEvent event) {
        if (this.registeredMonitors.isEmpty()) {
            return;
        }
        String variableName = event.getVariableName();
        HashSet<IResource> invalidResources = new HashSet<IResource>();
        Iterator<Object> i2 = this.registeredMonitors.values().iterator();
        while (i2.hasNext()) {
            Iterator j2 = ((List)i2.next()).iterator();
            while (j2.hasNext()) {
                IResource resource = (IResource)j2.next();
                IPath rawLocation = resource.getRawLocation();
                if (rawLocation == null || rawLocation.segmentCount() <= 0 || !variableName.equals(rawLocation.segment(0)) || invalidResources.contains(resource)) continue;
                invalidResources.add(resource);
            }
        }
        if (!invalidResources.isEmpty()) {
            i2 = invalidResources.iterator();
            while (i2.hasNext()) {
                IResource resource = (IResource)i2.next();
                this.unmonitor(resource);
                this.monitor(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMonitor(IRefreshMonitor monitor, IResource resource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            ArrayList<IResource> resources = (ArrayList<IResource>)this.registeredMonitors.get(monitor);
            if (resources == null) {
                resources = new ArrayList<IResource>(1);
                this.registeredMonitors.put(monitor, resources);
            }
            if (!resources.contains(resource)) {
                resources.add(resource);
            }
        }
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  added monitor (" + monitor + ") on resource: " + resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMonitor(IRefreshMonitor monitor, IResource resource) {
        Map map = this.registeredMonitors;
        synchronized (map) {
            List resources = (List)this.registeredMonitors.get(monitor);
            if (resources != null && !resources.isEmpty()) {
                resources.remove(resource);
            } else {
                this.registeredMonitors.remove(monitor);
            }
        }
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  removing monitor (" + monitor + ") on resource: " + resource);
        }
    }

    private IRefreshMonitor safeInstallMonitor(RefreshProvider provider, IResource resource) {
        Throwable t2 = null;
        try {
            return provider.installMonitor(resource, this.refreshManager);
        }
        catch (Exception e2) {
            t2 = e2;
        }
        catch (LinkageError e3) {
            t2 = e3;
        }
        if (t2 != null) {
            Status error = new Status(4, "org.eclipse.core.resources", 1, Messages.refresh_installError, t2);
            ResourcesPlugin.getPlugin().getLog().log(error);
        }
        return null;
    }

    public void start() {
        boolean refreshNeeded = false;
        Iterator i2 = this.getResourcesToMonitor().iterator();
        while (i2.hasNext()) {
            refreshNeeded |= !this.monitor((IResource)i2.next());
        }
        this.workspace.getPathVariableManager().addChangeListener(this);
        ((Workspace)this.workspace).addLifecycleListener(this);
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  starting monitor manager.");
        }
        if (refreshNeeded) {
            new PollingMonitor(this.refreshManager).runOnce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.workspace.getPathVariableManager().removeChangeListener(this);
        Map map = this.registeredMonitors;
        synchronized (map) {
            Iterator i2 = this.registeredMonitors.keySet().iterator();
            while (i2.hasNext()) {
                IRefreshMonitor monitor = (IRefreshMonitor)i2.next();
                monitor.unmonitor(null);
            }
        }
        this.registeredMonitors.clear();
        if (RefreshManager.DEBUG) {
            System.out.println("Auto-refresh:  stopping monitor manager.");
        }
        this.pollMonitor.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmonitor(IResource resource) {
        if (resource == null || !this.isMonitoring(resource)) {
            return;
        }
        Map map = this.registeredMonitors;
        synchronized (map) {
            Iterator i2 = this.registeredMonitors.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry current = i2.next();
                List resources = (List)current.getValue();
                if (resources == null || resources.isEmpty() || !resources.contains(resource)) continue;
                ((IRefreshMonitor)current.getKey()).unmonitor(resource);
                resources.remove(resource);
            }
        }
        if (resource.getType() == 4) {
            this.unmonitorLinkedContents((IProject)resource);
        }
    }

    private void unmonitorLinkedContents(IProject project) {
        if (!project.isAccessible()) {
            return;
        }
        IResource[] children = null;
        try {
            children = project.members();
        }
        catch (CoreException e2) {
            Status status = new Status(2, "org.eclipse.core.resources", 1, Messages.refresh_refreshErr, e2);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
        if (children != null && children.length > 0) {
            int i2 = 0;
            while (i2 < children.length) {
                if (children[i2].isLinked()) {
                    this.unmonitor(children[i2]);
                }
                ++i2;
            }
        }
    }
}

