/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

public class Base64 {
    private static final byte equalSign = 61;
    static char[] digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static byte[] decode(byte[] data) {
        if (data.length == 0) {
            return data;
        }
        int lastRealDataIndex = data.length - 1;
        while (data[lastRealDataIndex] == 61) {
            --lastRealDataIndex;
        }
        int padBytes = data.length - 1 - lastRealDataIndex;
        int byteLength = data.length * 6 / 8 - padBytes;
        byte[] result = new byte[byteLength];
        int dataIndex = 0;
        int resultIndex = 0;
        int allBits = 0;
        int resultChunks = (lastRealDataIndex + 1) / 4;
        int i2 = 0;
        while (i2 < resultChunks) {
            allBits = 0;
            int j2 = 0;
            while (j2 < 4) {
                allBits = allBits << 6 | Base64.decodeDigit(data[dataIndex++]);
                ++j2;
            }
            j2 = resultIndex + 2;
            while (j2 >= resultIndex) {
                result[j2] = (byte)(allBits & 0xFF);
                allBits >>>= 8;
                --j2;
            }
            resultIndex += 3;
            ++i2;
        }
        switch (padBytes) {
            case 1: {
                allBits = 0;
                int j3 = 0;
                while (j3 < 3) {
                    allBits = allBits << 6 | Base64.decodeDigit(data[dataIndex++]);
                    ++j3;
                }
                allBits <<= 6;
                allBits >>>= 8;
                j3 = resultIndex + 1;
                while (j3 >= resultIndex) {
                    result[j3] = (byte)(allBits & 0xFF);
                    allBits >>>= 8;
                    --j3;
                }
                break;
            }
            case 2: {
                allBits = 0;
                int j3 = 0;
                while (j3 < 2) {
                    allBits = allBits << 6 | Base64.decodeDigit(data[dataIndex++]);
                    ++j3;
                }
                allBits <<= 6;
                allBits <<= 6;
                allBits >>>= 8;
                result[resultIndex] = (byte)((allBits >>>= 8) & 0xFF);
            }
        }
        return result;
    }

    static int decodeDigit(byte data) {
        char charData = (char)data;
        if (charData <= 'Z' && charData >= 'A') {
            return charData - 65;
        }
        if (charData <= 'z' && charData >= 'a') {
            return charData - 97 + 26;
        }
        if (charData <= '9' && charData >= '0') {
            return charData - 48 + 52;
        }
        switch (charData) {
            case '+': {
                return 62;
            }
            case '/': {
                return 63;
            }
        }
        throw new IllegalArgumentException("Invalid char to decode: " + data);
    }

    public static byte[] encode(byte[] data) {
        int sourceChunks = data.length / 3;
        int len = (data.length + 2) / 3 * 4;
        byte[] result = new byte[len];
        int extraBytes = data.length - sourceChunks * 3;
        int dataIndex = 0;
        int resultIndex = 0;
        int allBits = 0;
        int i2 = 0;
        while (i2 < sourceChunks) {
            allBits = 0;
            int j2 = 0;
            while (j2 < 3) {
                allBits = allBits << 8 | data[dataIndex++] & 0xFF;
                ++j2;
            }
            j2 = resultIndex + 3;
            while (j2 >= resultIndex) {
                result[j2] = (byte)digits[allBits & 0x3F];
                allBits >>>= 6;
                --j2;
            }
            resultIndex += 4;
            ++i2;
        }
        switch (extraBytes) {
            case 1: {
                allBits = data[dataIndex++];
                allBits <<= 8;
                allBits <<= 8;
                int j3 = resultIndex + 3;
                while (j3 >= resultIndex) {
                    result[j3] = (byte)digits[allBits & 0x3F];
                    allBits >>>= 6;
                    --j3;
                }
                result[result.length - 1] = 61;
                result[result.length - 2] = 61;
                break;
            }
            case 2: {
                allBits = data[dataIndex++];
                allBits = allBits << 8 | data[dataIndex++] & 0xFF;
                allBits <<= 8;
                int j3 = resultIndex + 3;
                while (j3 >= resultIndex) {
                    result[j3] = (byte)digits[allBits & 0x3F];
                    allBits >>>= 6;
                    --j3;
                }
                result[result.length - 1] = 61;
            }
        }
        return result;
    }
}

