/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.jobs.ImplicitJobs;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobChangeEvent;
import org.eclipse.core.internal.jobs.JobListeners;
import org.eclipse.core.internal.jobs.JobQueue;
import org.eclipse.core.internal.jobs.JobStatus;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.jobs.Semaphore;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.jobs.WorkerPool;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.LockListener;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.osgi.util.NLS;

public class JobManager
implements IJobManager {
    private static final String OPTION_DEADLOCK_ERROR = "org.eclipse.core.runtime/jobs/errorondeadlock";
    private static final String OPTION_DEBUG_BEGIN_END = "org.eclipse.core.runtime/jobs/beginend";
    private static final String OPTION_DEBUG_JOBS = "org.eclipse.core.runtime/jobs";
    private static final String OPTION_DEBUG_JOBS_TIMING = "org.eclipse.core.runtime/jobs/timing";
    private static final String OPTION_LOCKS = "org.eclipse.core.runtime/jobs/locks";
    static final boolean DEBUG = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption("org.eclipse.core.runtime/jobs"));
    static final boolean DEBUG_BEGIN_END = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption("org.eclipse.core.runtime/jobs/beginend"));
    static final boolean DEBUG_DEADLOCK = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption("org.eclipse.core.runtime/jobs/errorondeadlock"));
    private static DateFormat DEBUG_FORMAT;
    static final boolean DEBUG_LOCKS;
    static final boolean DEBUG_TIMING;
    private static JobManager instance;
    private static final ISchedulingRule nullRule;
    private volatile boolean active = true;
    final ImplicitJobs implicitJobs = new ImplicitJobs(this);
    private final JobListeners jobListeners = new JobListeners();
    private final Object lock = new Object();
    private final LockManager lockManager = new LockManager();
    private WorkerPool pool;
    private ProgressProvider progressProvider = null;
    private final HashSet running;
    private final JobQueue sleeping;
    private boolean suspended = false;
    private final JobQueue waiting;

    static {
        DEBUG_LOCKS = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption(OPTION_LOCKS));
        DEBUG_TIMING = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption(OPTION_DEBUG_JOBS_TIMING));
        nullRule = new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        };
    }

    public static void debug(String msg) {
        StringBuffer msgBuf = new StringBuffer(msg.length() + 40);
        if (DEBUG_TIMING) {
            if (DEBUG_FORMAT == null) {
                DEBUG_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
            }
            DEBUG_FORMAT.format(new Date(), msgBuf, new FieldPosition(0));
            msgBuf.append('-');
        }
        msgBuf.append('[').append(Thread.currentThread()).append(']').append(msg);
        System.out.println(msgBuf.toString());
    }

    public static synchronized JobManager getInstance() {
        if (instance == null) {
            new JobManager();
        }
        return instance;
    }

    public static String printState(int state) {
        switch (state) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "WAITING";
            }
            case 1: {
                return "SLEEPING";
            }
            case 4: {
                return "RUNNING";
            }
            case 8: {
                return "BLOCKED";
            }
            case 16: {
                return "ABOUT_TO_RUN";
            }
            case 32: {
                return "ABOUT_TO_SCHEDULE";
            }
        }
        return "UNKNOWN";
    }

    public static void shutdown() {
        if (instance != null) {
            instance.doShutdown();
            instance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobManager() {
        instance = this;
        Object object = this.lock;
        synchronized (object) {
            this.waiting = new JobQueue(false);
            this.sleeping = new JobQueue(true);
            this.running = new HashSet(10);
            this.pool = new WorkerPool(this);
        }
    }

    public void addJobChangeListener(IJobChangeListener listener) {
        this.jobListeners.add(listener);
    }

    public void beginRule(ISchedulingRule rule, IProgressMonitor monitor) {
        this.validateRule(rule);
        this.implicitJobs.begin(rule, this.monitorFor(monitor), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean cancel(InternalJob job) {
        IProgressMonitor monitor = null;
        Object object = this.lock;
        synchronized (object) {
            switch (job.getState()) {
                case 0: {
                    return true;
                }
                case 4: {
                    if (job.internalGetState() == 4) {
                        monitor = job.getProgressMonitor();
                        break;
                    }
                }
                default: {
                    this.changeState(job, 0);
                }
            }
        }
        if (monitor == null) {
            this.jobListeners.done((Job)job, Status.CANCEL_STATUS, false);
            return true;
        }
        if (!monitor.isCanceled()) {
            monitor.setCanceled(true);
        }
        return false;
    }

    public void cancel(Object family) {
        Iterator it = this.select(family).iterator();
        while (it.hasNext()) {
            this.cancel((Job)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(InternalJob job, int newState) {
        Object object = this.lock;
        synchronized (object) {
            int oldState = job.internalGetState();
            switch (oldState) {
                case 0: 
                case 32: {
                    break;
                }
                case 8: {
                    job.remove();
                    break;
                }
                case 2: {
                    try {
                        this.waiting.remove(job);
                    }
                    catch (RuntimeException runtimeException) {
                        Assert.isLegal(false, "Tried to remove a job that wasn't in the queue");
                    }
                    break;
                }
                case 1: {
                    try {
                        this.sleeping.remove(job);
                    }
                    catch (RuntimeException runtimeException) {
                        Assert.isLegal(false, "Tried to remove a job that wasn't in the queue");
                    }
                    break;
                }
                case 4: 
                case 16: {
                    this.running.remove(job);
                    break;
                }
                default: {
                    Assert.isLegal(false, "Invalid job state: " + job + ", state: " + oldState);
                }
            }
            job.internalSetState(newState);
            switch (newState) {
                case 0: {
                    job.setStartTime(-1L);
                }
                case 8: {
                    break;
                }
                case 2: {
                    this.waiting.enqueue(job);
                    break;
                }
                case 1: {
                    this.sleeping.enqueue(job);
                    break;
                }
                case 4: 
                case 16: {
                    job.setStartTime(-1L);
                    this.running.add(job);
                    break;
                }
                case 32: {
                    break;
                }
                default: {
                    Assert.isLegal(false, "Invalid job state: " + job + ", state: " + newState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProgressMonitor createMonitor(InternalJob job, IProgressMonitor group, int ticks) {
        Object object = this.lock;
        synchronized (object) {
            if (job.getState() != 0) {
                return null;
            }
            IProgressMonitor monitor = null;
            if (this.progressProvider != null) {
                monitor = this.progressProvider.createMonitor((Job)job, group, ticks);
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            return monitor;
        }
    }

    private IProgressMonitor createMonitor(Job job) {
        IProgressMonitor monitor = null;
        if (this.progressProvider != null) {
            monitor = this.progressProvider.createMonitor(job);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    public IProgressMonitor createProgressGroup() {
        if (this.progressProvider != null) {
            return this.progressProvider.createProgressGroup();
        }
        return new NullProgressMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job currentJob() {
        Thread current = Thread.currentThread();
        if (current instanceof Worker) {
            return ((Worker)current).currentJob();
        }
        Object object = this.lock;
        synchronized (object) {
            Iterator it = this.running.iterator();
            while (it.hasNext()) {
                Job job = (Job)it.next();
                if (job.getThread() != current) continue;
                return job;
            }
        }
        return null;
    }

    private long delayFor(int priority) {
        switch (priority) {
            case 10: {
                return 0L;
            }
            case 20: {
                return 50L;
            }
            case 30: {
                return 100L;
            }
            case 40: {
                return 500L;
            }
            case 50: {
                return 1000L;
            }
        }
        Assert.isTrue(false, "Job has invalid priority: " + priority);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSchedule(InternalJob job, long delay) {
        Object object = this.lock;
        synchronized (object) {
            if (job.getPriority() == 50) {
                long minDelay = this.running.size() * 100;
                delay = Math.max(delay, minDelay);
            }
            if (delay > 0L) {
                job.setStartTime(System.currentTimeMillis() + delay);
                this.changeState(job, 1);
            } else {
                job.setStartTime(System.currentTimeMillis() + this.delayFor(job.getPriority()));
                this.changeState(job, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() {
        Job[] toCancel = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                toCancel = this.running.toArray(new Job[this.running.size()]);
                this.sleeping.clear();
                this.waiting.clear();
                this.running.clear();
            }
        }
        if (toCancel != null) {
            int i2 = 0;
            while (i2 < toCancel.length) {
                Job realJob;
                Job job = toCancel[i2];
                this.cancel(job);
                String jobName = job instanceof ThreadJob ? ((realJob = ((ThreadJob)job).realJob) != null ? realJob.getClass().getName() : "ThreadJob on rule: " + job.getRule()) : job.getClass().getName();
                String msg = "Job found still running after platform shutdown.  Jobs should be canceled by the plugin that scheduled them during shutdown: " + jobName;
                InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 2, msg, null));
                ++i2;
            }
            this.pool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endJob(InternalJob job, IStatus result, boolean notify) {
        boolean reschedule;
        InternalJob blocked = null;
        int blockedJobCount = 0;
        long rescheduleDelay = -1L;
        Object object = this.lock;
        synchronized (object) {
            if (result == Job.ASYNC_FINISH) {
                return;
            }
            if (job.getState() == 0) {
                return;
            }
            if (DEBUG && notify) {
                JobManager.debug("Ending job: " + job);
            }
            job.setResult(result);
            job.setProgressMonitor(null);
            job.setThread(null);
            rescheduleDelay = job.getStartTime();
            this.changeState(job, 0);
            blocked = job.previous();
            job.setPrevious(null);
            while (blocked != null) {
                InternalJob previous = blocked.previous();
                this.changeState(blocked, 2);
                ++blockedJobCount;
                blocked = previous;
            }
        }
        int i2 = 0;
        while (i2 < blockedJobCount) {
            this.pool.jobQueued(blocked);
            ++i2;
        }
        boolean bl = reschedule = this.active && rescheduleDelay > -1L && job.shouldSchedule();
        if (notify) {
            this.jobListeners.done((Job)job, result, reschedule);
        }
        if (reschedule) {
            this.schedule(job, rescheduleDelay, reschedule);
        }
    }

    public void endRule(ISchedulingRule rule) {
        this.implicitJobs.end(rule, false);
    }

    public Job[] find(Object family) {
        List members = this.select(family);
        return members.toArray(new Job[members.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalJob findBlockingJob(InternalJob waitingJob) {
        if (waitingJob.getRule() == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            InternalJob job;
            if (this.running.isEmpty()) {
                return null;
            }
            boolean hasBlockedJobs = false;
            Iterator it = this.running.iterator();
            while (it.hasNext()) {
                job = (InternalJob)it.next();
                if (waitingJob.isConflicting(job)) {
                    return job;
                }
                if (hasBlockedJobs) continue;
                boolean bl = hasBlockedJobs = job.previous() != null;
            }
            if (!hasBlockedJobs) {
                return null;
            }
            it = this.running.iterator();
            while (it.hasNext()) {
                job = (InternalJob)it.next();
                while ((job = job.previous()) != null) {
                    if (!waitingJob.isConflicting(job)) continue;
                    return job;
                }
            }
        }
        return null;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    protected boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isBlocking(InternalJob runningJob) {
        Object object = this.lock;
        synchronized (object) {
            if (runningJob.getState() != 4) {
                return false;
            }
            InternalJob previous = runningJob.previous();
            while (true) {
                if (previous == null) {
                    return false;
                }
                if (!previous.isSystem()) {
                    return true;
                }
                if (previous instanceof ThreadJob && ((ThreadJob)previous).shouldInterrupt()) {
                    return true;
                }
                previous = previous.previous();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        Object object = this.lock;
        synchronized (object) {
            return this.running.isEmpty() && this.waiting.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void join(InternalJob job) {
        JobChangeAdapter listener;
        Semaphore barrier;
        Object object = this.lock;
        synchronized (object) {
            int state = job.getState();
            if (state == 0) {
                return;
            }
            if (this.suspended && state != 4) {
                return;
            }
            barrier = new Semaphore(null);
            listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    barrier.release();
                }
            };
            job.addJobChangeListener(listener);
        }
        try {
            while (true) {
                this.lockManager.aboutToWait(job.getThread());
                try {
                    if (!barrier.acquire(Long.MAX_VALUE)) continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            object = null;
            this.lockManager.aboutToRelease();
            job.removeJobChangeListener(listener);
            throw throwable;
        }
        {
            object = null;
            this.lockManager.aboutToRelease();
            job.removeJobChangeListener(listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void join(final Object family, IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        int jobCount;
        Set jobs;
        monitor = this.monitorFor(monitor);
        JobChangeAdapter listener = null;
        Job blocking = null;
        Object object = this.lock;
        synchronized (object) {
            int states = this.suspended ? 4 : 7;
            jobs = Collections.synchronizedSet(new HashSet(this.select(family, states)));
            jobCount = jobs.size();
            if (jobCount == 0) {
                return;
            }
            if (jobCount == 1) {
                blocking = (Job)jobs.iterator().next();
            }
            listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (!((JobChangeEvent)event).reschedule) {
                        jobs.remove(event.getJob());
                    }
                }

                public void scheduled(IJobChangeEvent event) {
                    if (((JobChangeEvent)event).reschedule) {
                        return;
                    }
                    Job job = event.getJob();
                    if (job.belongsTo(family)) {
                        jobs.add(job);
                    }
                }
            };
            this.addJobChangeListener(listener);
        }
        try {
            int jobsLeft;
            monitor.beginTask(Messages.jobs_blocked0, jobCount);
            monitor.subTask(NLS.bind(Messages.jobs_waitFamSub, Integer.toString(jobCount)));
            this.reportBlocked(monitor, blocking);
            int reportedWorkDone = 0;
            while ((jobsLeft = jobs.size()) > 0) {
                int actualWorkDone = Math.max(0, jobCount - jobsLeft);
                if (reportedWorkDone < actualWorkDone) {
                    monitor.worked(actualWorkDone - reportedWorkDone);
                    reportedWorkDone = actualWorkDone;
                    monitor.subTask(NLS.bind(Messages.jobs_waitFamSub, Integer.toString(jobsLeft)));
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.lockManager.aboutToWait(null);
                Thread.sleep(100L);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.removeJobChangeListener(listener);
            this.reportUnblocked(monitor);
            monitor.done();
            throw throwable;
        }
        {
            Object var10_13 = null;
            this.removeJobChangeListener(listener);
            this.reportUnblocked(monitor);
            monitor.done();
            return;
        }
    }

    private IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if ((monitor == null || monitor instanceof NullProgressMonitor) && this.progressProvider != null) {
            try {
                monitor = this.progressProvider.getDefaultMonitor();
            }
            catch (Exception e2) {
                String msg = NLS.bind(Messages.meta_pluginProblems, "org.eclipse.core.runtime");
                InternalPlatform.getDefault().log(new Status(4, "org.eclipse.core.runtime", 2, msg, e2));
            }
        }
        return Policy.monitorFor(monitor);
    }

    public ILock newLock() {
        return this.lockManager.newLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job nextJob() {
        Object object = this.lock;
        synchronized (object) {
            if (this.suspended) {
                return null;
            }
            long now = System.currentTimeMillis();
            InternalJob job = this.sleeping.peek();
            while (job != null && job.getStartTime() < now) {
                job.setStartTime(now + this.delayFor(job.getPriority()));
                this.changeState(job, 2);
                job = this.sleeping.peek();
            }
            while ((job = this.waiting.peek()) != null) {
                InternalJob blocker = this.findBlockingJob(job);
                if (blocker == null) break;
                this.changeState(job, 8);
                Assert.isTrue(job.next() == null);
                Assert.isTrue(job.previous() == null);
                blocker.addLast(job);
            }
            if (job != null) {
                this.changeState(job, 16);
                if (DEBUG) {
                    JobManager.debug("Starting job: " + job);
                }
            }
            return (Job)job;
        }
    }

    public void removeJobChangeListener(IJobChangeListener listener) {
        this.jobListeners.remove(listener);
    }

    final void reportBlocked(IProgressMonitor monitor, InternalJob blockingJob) {
        Status reason;
        if (!(monitor instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        if (blockingJob == null || blockingJob instanceof ThreadJob || blockingJob.isSystem()) {
            reason = new Status(1, "org.eclipse.core.runtime", 1, Messages.jobs_blocked0, null);
        } else {
            String msg = NLS.bind(Messages.jobs_blocked1, blockingJob.getName());
            reason = new JobStatus(1, (Job)blockingJob, msg);
        }
        ((IProgressMonitorWithBlocking)monitor).setBlocked(reason);
    }

    final void reportUnblocked(IProgressMonitor monitor) {
        if (monitor instanceof IProgressMonitorWithBlocking) {
            ((IProgressMonitorWithBlocking)monitor).clearBlocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.suspended = false;
            this.pool.jobQueued(null);
        }
    }

    public final void resume(ISchedulingRule rule) {
        this.implicitJobs.resume(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runNow(InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.findBlockingJob(job) == null) break block4;
                return false;
            }
            this.changeState(job, 4);
            job.setProgressMonitor(new NullProgressMonitor());
            job.run(null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(InternalJob job, long delay, boolean reschedule) {
        if (!this.active) {
            throw new IllegalStateException("Job manager has been shut down.");
        }
        Assert.isNotNull(job, "Job is null");
        Assert.isLegal(delay >= 0L, "Scheduling delay is negative");
        Object object = this.lock;
        synchronized (object) {
            if (job.getState() == 4) {
                job.setStartTime(delay);
                return;
            }
            if (job.internalGetState() != 0) {
                return;
            }
            if (DEBUG) {
                JobManager.debug("Scheduling job: " + job);
            }
            this.changeState(job, 32);
        }
        this.jobListeners.scheduled((Job)job, delay, reschedule);
        this.doSchedule(job, delay);
        this.pool.jobQueued(job);
    }

    private void select(List members, Object family, InternalJob firstJob, int stateMask) {
        if (firstJob == null) {
            return;
        }
        InternalJob job = firstJob;
        do {
            if (family != null && !job.belongsTo(family) || (job.getState() & stateMask) == 0) continue;
            members.add(job);
        } while ((job = job.previous()) != null && job != firstJob);
    }

    private List select(Object family) {
        return this.select(family, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List select(Object family, int stateMask) {
        ArrayList members = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            if ((stateMask & 4) != 0) {
                Iterator it = this.running.iterator();
                while (it.hasNext()) {
                    this.select(members, family, (InternalJob)it.next(), stateMask);
                }
            }
            if ((stateMask & 2) != 0) {
                this.select(members, family, this.waiting.peek(), stateMask);
            }
            if ((stateMask & 1) != 0) {
                this.select(members, family, this.sleeping.peek(), stateMask);
            }
        }
        return members;
    }

    public void setLockListener(LockListener listener) {
        this.lockManager.setLockListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPriority(InternalJob job, int newPriority) {
        Object object = this.lock;
        synchronized (object) {
            int oldPriority = job.getPriority();
            if (oldPriority == newPriority) {
                return;
            }
            job.internalSetPriority(newPriority);
            if (job.getState() == 2) {
                long oldStart = job.getStartTime();
                job.setStartTime(oldStart + (this.delayFor(newPriority) - this.delayFor(oldPriority)));
                this.waiting.resort(job);
            }
        }
    }

    public void setProgressProvider(ProgressProvider provider) {
        this.progressProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRule(InternalJob job, ISchedulingRule rule) {
        Object object = this.lock;
        synchronized (object) {
            Assert.isLegal(job.getState() == 0);
            this.validateRule(rule);
            job.internalSetRule(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sleep(InternalJob job) {
        Object object = this.lock;
        synchronized (object) {
            switch (job.getState()) {
                case 4: {
                    if (job.internalGetState() != 4) break;
                    return false;
                }
                case 1: {
                    job.setStartTime(Long.MAX_VALUE);
                    this.changeState(job, 1);
                    return true;
                }
                case 0: {
                    return true;
                }
            }
            job.setStartTime(Long.MAX_VALUE);
            this.changeState(job, 1);
        }
        this.jobListeners.sleeping((Job)job);
        return true;
    }

    public void sleep(Object family) {
        Iterator it = this.select(family).iterator();
        while (it.hasNext()) {
            this.sleep((InternalJob)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long sleepHint() {
        Object object = this.lock;
        synchronized (object) {
            InternalJob next;
            block8: {
                block7: {
                    block6: {
                        if (!this.suspended) break block6;
                        return Long.MAX_VALUE;
                    }
                    if (this.waiting.isEmpty()) break block7;
                    return 0L;
                }
                next = this.sleeping.peek();
                if (next != null) break block8;
                return Long.MAX_VALUE;
            }
            return next.getStartTime() - System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Job startJob() {
        Job job = null;
        while (true) {
            if ((job = this.nextJob()) == null) {
                return null;
            }
            if (job.shouldRun()) {
                this.jobListeners.aboutToRun(job);
                Object object = this.lock;
                synchronized (object) {
                    if (job.getState() == 4) {
                        Job internal = job;
                        if (internal.getProgressMonitor() == null) {
                            internal.setProgressMonitor(this.createMonitor(job));
                        }
                        internal.internalSetState(4);
                        break;
                    }
                }
            }
            if (job.getState() == 1) continue;
            this.endJob(job, Status.CANCEL_STATUS, true);
        }
        this.jobListeners.running(job);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        Object object = this.lock;
        synchronized (object) {
            this.suspended = true;
        }
    }

    public final void suspend(ISchedulingRule rule, IProgressMonitor monitor) {
        Assert.isNotNull(rule);
        this.implicitJobs.suspend(rule, this.monitorFor(monitor));
    }

    public void transferRule(ISchedulingRule rule, Thread destinationThread) {
        this.implicitJobs.transfer(rule, destinationThread);
    }

    private void validateRule(ISchedulingRule rule) {
        if (rule == null) {
            return;
        }
        Assert.isLegal(rule.contains(rule));
        Assert.isLegal(!rule.contains(nullRule));
        Assert.isLegal(rule.isConflicting(rule));
        Assert.isLegal(!rule.isConflicting(nullRule));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeUp(InternalJob job, long delay) {
        Assert.isLegal(delay >= 0L, "Scheduling delay is negative");
        Object object = this.lock;
        synchronized (object) {
            if (job.getState() != 1) {
                return;
            }
            this.doSchedule(job, delay);
        }
        this.pool.jobQueued(job);
        if (delay == 0L) {
            this.jobListeners.awake((Job)job);
        }
    }

    public void wakeUp(Object family) {
        Iterator it = this.select(family).iterator();
        while (it.hasNext()) {
            this.wakeUp((InternalJob)it.next(), 0L);
        }
    }
}

