/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.events.NodeIDMap;
import org.eclipse.core.internal.events.ResourceDeltaInfo;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public class ResourceDelta
extends PlatformObject
implements IResourceDelta {
    protected IPath path;
    protected ResourceDeltaInfo deltaInfo;
    protected int status;
    protected ResourceInfo oldInfo;
    protected ResourceInfo newInfo;
    protected ResourceDelta[] children;
    protected IResource cachedResource;
    protected static int KIND_MASK = 255;
    private static IMarkerDelta[] EMPTY_MARKER_DELTAS = new IMarkerDelta[0];

    protected ResourceDelta(IPath path, ResourceDeltaInfo deltaInfo) {
        this.path = path;
        this.deltaInfo = deltaInfo;
    }

    public void accept(IResourceDeltaVisitor visitor) throws CoreException {
        this.accept(visitor, 0);
    }

    public void accept(IResourceDeltaVisitor visitor, boolean includePhantoms) throws CoreException {
        this.accept(visitor, includePhantoms ? 1 : 0);
    }

    public void accept(IResourceDeltaVisitor visitor, int memberFlags) throws CoreException {
        int mask;
        boolean includePhantoms = (memberFlags & 1) != 0;
        boolean includeTeamPrivate = (memberFlags & 2) != 0;
        int n2 = mask = includePhantoms ? 31 : 7;
        if ((this.getKind() & mask) == 0) {
            return;
        }
        if (!visitor.visit(this)) {
            return;
        }
        int i2 = 0;
        while (i2 < this.children.length) {
            ResourceDelta childDelta = this.children[i2];
            if (!(!includeTeamPrivate && childDelta.isTeamPrivate() || !includePhantoms && childDelta.isPhantom())) {
                childDelta.accept(visitor, memberFlags);
            }
            ++i2;
        }
    }

    protected void checkForMarkerDeltas() {
        MarkerSet changes;
        if (this.deltaInfo.getMarkerDeltas() == null) {
            return;
        }
        int kind = this.getKind();
        if ((this.path.isRoot() || kind == 1 || kind == 2) && (changes = (MarkerSet)this.deltaInfo.getMarkerDeltas().get(this.path)) != null && changes.size() > 0) {
            this.status |= 0x20000;
            if (kind == 0) {
                this.status |= 4;
            }
        }
    }

    public IResourceDelta findMember(IPath path) {
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return this;
        }
        ResourceDelta current = this;
        int i2 = 0;
        while (i2 < segmentCount) {
            int j2;
            ResourceDelta[] currentChildren;
            block4: {
                currentChildren = current.children;
                j2 = 0;
                int jmax = currentChildren.length;
                while (j2 < jmax) {
                    if (!currentChildren[j2].getFullPath().lastSegment().equals(path.segment(i2))) {
                        ++j2;
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            current = currentChildren[j2];
            ++i2;
        }
        return current;
    }

    protected void fixMovesAndMarkers(ElementTree oldTree) {
        NodeIDMap nodeIDMap = this.deltaInfo.getNodeIDMap();
        if (!this.path.isRoot() && !nodeIDMap.isEmpty()) {
            int kind = this.getKind();
            switch (kind) {
                case 1: 
                case 4: {
                    IPath oldPath = nodeIDMap.getOldPath(this.newInfo.getNodeId());
                    if (oldPath == null || oldPath.equals(this.path)) break;
                    ResourceInfo actualOldInfo = (ResourceInfo)oldTree.getElementData(oldPath);
                    this.status = this.status & KIND_MASK | this.deltaInfo.getComparator().compare(actualOldInfo, this.newInfo) & ~KIND_MASK;
                    this.status |= 0x1000;
                    if (kind == 4) {
                        this.status = this.status | 0x40000 | 0x100;
                    }
                    if (this.oldInfo == null || this.newInfo == null || this.oldInfo.getType() == this.newInfo.getType()) break;
                    this.status |= 0x8000;
                }
            }
            switch (kind) {
                case 2: 
                case 4: {
                    IPath newPath = nodeIDMap.getNewPath(this.oldInfo.getNodeId());
                    if (newPath == null || newPath.equals(this.path)) break;
                    this.status |= 0x2000;
                    if (kind != 4) break;
                    this.status = this.status | 0x40000 | 0x100;
                }
            }
        }
        this.checkForMarkerDeltas();
        int i2 = 0;
        while (i2 < this.children.length) {
            this.children[i2].fixMovesAndMarkers(oldTree);
            ++i2;
        }
    }

    public IResourceDelta[] getAffectedChildren() {
        return this.getAffectedChildren(7, 0);
    }

    public IResourceDelta[] getAffectedChildren(int kindMask) {
        return this.getAffectedChildren(kindMask, 0);
    }

    public IResourceDelta[] getAffectedChildren(int kindMask, int memberFlags) {
        boolean includeTeamPrivate;
        int numChildren = this.children.length;
        if (numChildren == 0) {
            return this.children;
        }
        boolean includePhantoms = (memberFlags & 1) != 0;
        boolean bl = includeTeamPrivate = (memberFlags & 2) != 0;
        if (includePhantoms) {
            kindMask |= 0x18;
        }
        int matching = 0;
        int i2 = 0;
        while (i2 < numChildren) {
            if (!((this.children[i2].getKind() & kindMask) == 0 || !includePhantoms && this.children[i2].isPhantom() || !includeTeamPrivate && this.children[i2].isTeamPrivate())) {
                ++matching;
            }
            ++i2;
        }
        if (matching == numChildren) {
            IResourceDelta[] result = new IResourceDelta[this.children.length];
            System.arraycopy(this.children, 0, result, 0, this.children.length);
            return result;
        }
        IResourceDelta[] result = new IResourceDelta[matching];
        int nextPosition = 0;
        int i3 = 0;
        while (i3 < numChildren) {
            if (!((this.children[i3].getKind() & kindMask) == 0 || !includePhantoms && this.children[i3].isPhantom() || !includeTeamPrivate && this.children[i3].isTeamPrivate())) {
                result[nextPosition++] = this.children[i3];
            }
            ++i3;
        }
        return result;
    }

    protected ResourceDeltaInfo getDeltaInfo() {
        return this.deltaInfo;
    }

    public int getFlags() {
        return this.status & ~KIND_MASK;
    }

    public IPath getFullPath() {
        return this.path;
    }

    public int getKind() {
        return this.status & KIND_MASK;
    }

    public IMarkerDelta[] getMarkerDeltas() {
        MarkerSet changes;
        Map markerDeltas = this.deltaInfo.getMarkerDeltas();
        if (markerDeltas == null) {
            return EMPTY_MARKER_DELTAS;
        }
        if (this.path == null) {
            this.path = Path.ROOT;
        }
        if ((changes = (MarkerSet)markerDeltas.get(this.path)) == null) {
            return EMPTY_MARKER_DELTAS;
        }
        IMarkerSetElement[] elements = changes.elements();
        IMarkerDelta[] result = new IMarkerDelta[elements.length];
        int i2 = 0;
        while (i2 < elements.length) {
            result[i2] = (IMarkerDelta)((Object)elements[i2]);
            ++i2;
        }
        return result;
    }

    public IPath getMovedFromPath() {
        if ((this.status & 0x1000) != 0) {
            return this.deltaInfo.getNodeIDMap().getOldPath(this.newInfo.getNodeId());
        }
        return null;
    }

    public IPath getMovedToPath() {
        if ((this.status & 0x2000) != 0) {
            return this.deltaInfo.getNodeIDMap().getNewPath(this.oldInfo.getNodeId());
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        IPath full = this.getFullPath();
        int count = full.segmentCount();
        if (count < 0) {
            return null;
        }
        if (count <= 1) {
            return Path.EMPTY;
        }
        return full.removeFirstSegments(1);
    }

    public IResource getResource() {
        if (this.cachedResource != null) {
            return this.cachedResource;
        }
        if (this.path.segmentCount() == 0) {
            return this.deltaInfo.getWorkspace().getRoot();
        }
        ResourceInfo info = null;
        info = (this.getKind() & 0x12) != 0 ? this.oldInfo : this.newInfo;
        if (info == null) {
            Assert.isNotNull(null, "Do not have resource info for resource in delta: " + this.path);
        }
        this.cachedResource = this.deltaInfo.getWorkspace().newResource(this.path, info.getType());
        return this.cachedResource;
    }

    protected boolean isPhantom() {
        if ((this.status & 0x12) != 0) {
            return ResourceInfo.isSet(this.oldInfo.getFlags(), 8);
        }
        return ResourceInfo.isSet(this.newInfo.getFlags(), 8);
    }

    protected boolean isTeamPrivate() {
        if ((this.status & 0x12) != 0) {
            return ResourceInfo.isSet(this.oldInfo.getFlags(), 32768);
        }
        return ResourceInfo.isSet(this.newInfo.getFlags(), 32768);
    }

    protected void setChildren(ResourceDelta[] children) {
        this.children = children;
    }

    protected void setNewInfo(ResourceInfo newInfo) {
        this.newInfo = newInfo;
    }

    protected void setOldInfo(ResourceInfo oldInfo) {
        this.oldInfo = oldInfo;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.writeDebugString(buffer);
        return buffer.toString();
    }

    public String toDeepDebugString() {
        StringBuffer buffer = new StringBuffer("\n");
        this.writeDebugString(buffer);
        int i2 = 0;
        while (i2 < this.children.length) {
            buffer.append(this.children[i2].toDeepDebugString());
            ++i2;
        }
        return buffer.toString();
    }

    public String toString() {
        return "ResourceDelta(" + this.path + ")";
    }

    public void updateMarkers(Map markers) {
        this.deltaInfo.setMarkerDeltas(markers);
    }

    public void writeDebugString(StringBuffer buffer) {
        buffer.append(this.getFullPath());
        buffer.append('[');
        switch (this.getKind()) {
            case 1: {
                buffer.append('+');
                break;
            }
            case 8: {
                buffer.append('>');
                break;
            }
            case 2: {
                buffer.append('-');
                break;
            }
            case 16: {
                buffer.append('<');
                break;
            }
            case 4: {
                buffer.append('*');
                break;
            }
            case 0: {
                buffer.append('~');
                break;
            }
            default: {
                buffer.append('?');
            }
        }
        buffer.append("]: {");
        int changeFlags = this.getFlags();
        boolean prev = false;
        if ((changeFlags & 0x100) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((changeFlags & 0x1000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_FROM(" + this.getMovedFromPath() + ")");
            prev = true;
        }
        if ((changeFlags & 0x2000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_TO(" + this.getMovedToPath() + ")");
            prev = true;
        }
        if ((changeFlags & 0x4000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("OPEN");
            prev = true;
        }
        if ((changeFlags & 0x8000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("TYPE");
            prev = true;
        }
        if ((changeFlags & 0x10000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SYNC");
            prev = true;
        }
        if ((changeFlags & 0x20000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MARKERS");
            this.writeMarkerDebugString(buffer);
            prev = true;
        }
        if ((changeFlags & 0x40000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REPLACED");
            prev = true;
        }
        if ((changeFlags & 0x80000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("DESCRIPTION");
            prev = true;
        }
        if ((changeFlags & 0x100000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ENCODING");
            prev = true;
        }
        buffer.append("}");
        if (this.isTeamPrivate()) {
            buffer.append(" (team private)");
        }
    }

    public void writeMarkerDebugString(StringBuffer buffer) {
        buffer.append('[');
        Iterator e2 = this.deltaInfo.getMarkerDeltas().keySet().iterator();
        while (e2.hasNext()) {
            IPath key = (IPath)e2.next();
            if (!this.getResource().getFullPath().equals(key)) continue;
            IMarkerSetElement[] deltas = ((MarkerSet)this.deltaInfo.getMarkerDeltas().get(key)).elements();
            boolean addComma = false;
            int i2 = 0;
            while (i2 < deltas.length) {
                IMarkerDelta delta = (IMarkerDelta)((Object)deltas[i2]);
                if (addComma) {
                    buffer.append(',');
                }
                switch (delta.getKind()) {
                    case 1: {
                        buffer.append('+');
                        break;
                    }
                    case 2: {
                        buffer.append('-');
                        break;
                    }
                    case 4: {
                        buffer.append('*');
                    }
                }
                buffer.append(delta.getId());
                addComma = true;
                ++i2;
            }
        }
        buffer.append(']');
    }
}

