/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.resources.IResourceChangeListener;

public class ResourceChangeListenerList {
    private static final ListenerEntry[] EMPTY_ARRAY = new ListenerEntry[0];
    private int count1 = 0;
    private int count2 = 0;
    private int count4 = 0;
    private int count8 = 0;
    private int count16 = 0;
    private volatile ListenerEntry[] listeners = EMPTY_ARRAY;

    public synchronized void add(IResourceChangeListener listener, int mask) {
        Assert.isNotNull(listener);
        if (mask == 0) {
            this.remove(listener);
            return;
        }
        ListenerEntry entry = new ListenerEntry(listener, mask);
        int oldSize = this.listeners.length;
        int i2 = 0;
        while (i2 < oldSize) {
            if (this.listeners[i2].listener == listener) {
                this.removing(this.listeners[i2].eventMask);
                this.adding(mask);
                this.listeners[i2] = entry;
                return;
            }
            ++i2;
        }
        this.adding(mask);
        ListenerEntry[] newListeners = new ListenerEntry[oldSize + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = entry;
        this.listeners = newListeners;
    }

    private void adding(int mask) {
        if ((mask & 1) != 0) {
            ++this.count1;
        }
        if ((mask & 2) != 0) {
            ++this.count2;
        }
        if ((mask & 4) != 0) {
            ++this.count4;
        }
        if ((mask & 8) != 0) {
            ++this.count8;
        }
        if ((mask & 0x10) != 0) {
            ++this.count16;
        }
    }

    public ListenerEntry[] getListeners() {
        return this.listeners;
    }

    public boolean hasListenerFor(int event) {
        if (event == 1) {
            return this.count1 > 0;
        }
        if (event == 2) {
            return this.count2 > 0;
        }
        if (event == 4) {
            return this.count4 > 0;
        }
        if (event == 8) {
            return this.count8 > 0;
        }
        if (event == 16) {
            return this.count16 > 0;
        }
        return false;
    }

    public synchronized void remove(IResourceChangeListener listener) {
        Assert.isNotNull(listener);
        int oldSize = this.listeners.length;
        int i2 = 0;
        while (i2 < oldSize) {
            if (this.listeners[i2].listener == listener) {
                this.removing(this.listeners[i2].eventMask);
                if (oldSize == 1) {
                    this.listeners = EMPTY_ARRAY;
                } else {
                    ListenerEntry[] newListeners = new ListenerEntry[oldSize - 1];
                    System.arraycopy(this.listeners, 0, newListeners, 0, i2);
                    System.arraycopy(this.listeners, i2 + 1, newListeners, i2, oldSize - i2 - 1);
                    this.listeners = newListeners;
                }
                return;
            }
            ++i2;
        }
    }

    private void removing(int mask) {
        if ((mask & 1) != 0) {
            --this.count1;
        }
        if ((mask & 2) != 0) {
            --this.count2;
        }
        if ((mask & 4) != 0) {
            --this.count4;
        }
        if ((mask & 8) != 0) {
            --this.count8;
        }
        if ((mask & 0x10) != 0) {
            --this.count16;
        }
    }

    static class ListenerEntry {
        int eventMask;
        IResourceChangeListener listener;

        ListenerEntry(IResourceChangeListener listener, int eventMask) {
            this.listener = listener;
            this.eventMask = eventMask;
        }
    }
}

