/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.aspectj.util.LangUtil;

public class LangUtilTest
extends TestCase {
    public LangUtilTest(String name) {
        super(name);
    }

    public void testExtractOptions() {
        ArrayList extracted = new ArrayList();
        String[] args = new String[]{"-d", "classes", "-classpath", "foo.jar", "-verbose", "Bar.java"};
        String[] validOptions = new String[]{"-classpath", "-d", "-verbose", "-help"};
        int[] optionArgs = new int[]{1, 1, 0, 0};
        String[] result = LangUtil.extractOptions(args, validOptions, optionArgs, extracted);
        String resultString = "" + Arrays.asList(result);
        String EXP = "[Bar.java]";
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        EXP = "[-d, classes, -classpath, foo.jar, -verbose]";
        resultString = "" + extracted;
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        extracted.clear();
        args = new String[]{};
        result = LangUtil.extractOptions(args, validOptions, optionArgs, extracted);
        resultString = "" + Arrays.asList(result);
        EXP = "[]";
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        resultString = "" + extracted;
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        extracted.clear();
        args = new String[]{"Bar.java"};
        result = LangUtil.extractOptions(args, validOptions, optionArgs, extracted);
        resultString = "" + Arrays.asList(result);
        EXP = "[Bar.java]";
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        EXP = "[]";
        resultString = "" + extracted;
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        extracted.clear();
        args = new String[]{"-verbose"};
        result = LangUtil.extractOptions(args, validOptions, optionArgs, extracted);
        resultString = "" + Arrays.asList(result);
        EXP = "[]";
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        EXP = "[-verbose]";
        resultString = "" + extracted;
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        validOptions = new String[]{"-help", "-verbose"};
        optionArgs = null;
        extracted.clear();
        args = new String[]{"-verbose"};
        result = LangUtil.extractOptions(args, validOptions, optionArgs, extracted);
        resultString = "" + Arrays.asList(result);
        EXP = "[]";
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        EXP = "[-verbose]";
        resultString = "" + extracted;
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        extracted.clear();
        args = new String[]{"Bar.java"};
        result = LangUtil.extractOptions(args, validOptions, optionArgs, extracted);
        resultString = "" + Arrays.asList(result);
        EXP = "[Bar.java]";
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        EXP = "[]";
        resultString = "" + extracted;
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
    }

    public void testExtractOptionsArrayCollector() {
        String[] args = new String[]{"-d", "classes", "-classpath", "foo.jar", "-verbose", "Bar.java"};
        String[][] OPTIONS2 = new String[][]{{"-classpath", null}, {"-d", null}, {"-verbose"}, {"-help"}};
        String[][] options = LangUtil.copyStrings(OPTIONS2);
        String[] result = LangUtil.extractOptions(args, options);
        String resultString = "" + Arrays.asList(result);
        String EXP = "[Bar.java]";
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        Assert.assertTrue((boolean)"-verbose".equals(options[2][0]));
        Assert.assertTrue((boolean)"foo.jar".equals(options[0][1]));
        Assert.assertTrue((boolean)"classes".equals(options[1][1]));
        Assert.assertTrue((boolean)"-classpath".equals(options[0][0]));
        Assert.assertTrue((boolean)"-d".equals(options[1][0]));
        Assert.assertTrue((null == options[3][0] ? 1 : 0) != 0);
        args = new String[]{"Bar.java"};
        options = LangUtil.copyStrings(OPTIONS2);
        result = LangUtil.extractOptions(args, options);
        resultString = "" + Arrays.asList(result);
        EXP = "[Bar.java]";
        Assert.assertTrue((String)(resultString + " != " + EXP), (boolean)resultString.equals(EXP));
        Assert.assertTrue((null == options[0][0] ? 1 : 0) != 0);
        Assert.assertTrue((null == options[1][0] ? 1 : 0) != 0);
        Assert.assertTrue((null == options[2][0] ? 1 : 0) != 0);
        Assert.assertTrue((null == options[3][0] ? 1 : 0) != 0);
    }

    public void testOptionVariants() {
        String[] NONE = new String[]{};
        String[] one = new String[]{"-1"};
        String[] two = new String[]{"-2"};
        String[] three = new String[]{"-3"};
        String[] both = new String[]{"-1", "-2"};
        String[] oneB = new String[]{"-1-"};
        String[] bothB = new String[]{"-1-", "-2-"};
        String[] onetwoB = new String[]{"-1", "-2-"};
        String[] oneBtwo = new String[]{"-1-", "-2"};
        String[] threeB = new String[]{"-1-", "-2-", "-3-"};
        String[] athreeB = new String[]{"a", "-1-", "-2-", "-3-"};
        String[] threeaB = new String[]{"-1-", "a", "-2-", "-3-"};
        this.checkOptionVariants(NONE, new String[][]{NONE});
        this.checkOptionVariants(one, new String[][]{one});
        this.checkOptionVariants(both, new String[][]{both});
        this.checkOptionVariants(oneB, new String[][]{NONE, one});
        this.checkOptionVariants(bothB, new String[][]{NONE, one, {"-2"}, both});
        this.checkOptionVariants(onetwoB, new String[][]{one, {"-1", "-2"}});
        this.checkOptionVariants(oneBtwo, new String[][]{two, {"-1", "-2"}});
        this.checkOptionVariants(threeB, new String[][]{NONE, one, two, {"-1", "-2"}, three, {"-1", "-3"}, {"-2", "-3"}, {"-1", "-2", "-3"}});
        this.checkOptionVariants(athreeB, new String[][]{{"a"}, {"a", "-1"}, {"a", "-2"}, {"a", "-1", "-2"}, {"a", "-3"}, {"a", "-1", "-3"}, {"a", "-2", "-3"}, {"a", "-1", "-2", "-3"}});
        this.checkOptionVariants(threeaB, new String[][]{{"a"}, {"-1", "a"}, {"a", "-2"}, {"-1", "a", "-2"}, {"a", "-3"}, {"-1", "a", "-3"}, {"a", "-2", "-3"}, {"-1", "a", "-2", "-3"}});
    }

    void checkOptionVariants(String[] options, String[][] expected) {
        String[][] result = LangUtil.optionVariants(options);
        if (expected.length != result.length) {
            Assert.assertTrue((String)("exp=" + expected.length + " actual=" + result.length), (boolean)false);
        }
        for (int i2 = 0; i2 < expected.length; ++i2) {
            Assert.assertEquals((String)("" + i2), (String)("" + Arrays.asList(expected[i2])), (String)("" + Arrays.asList(result[i2])));
        }
    }

    public void testCommaSplit() {
        this.checkCommaSplit("", new String[]{""});
        this.checkCommaSplit("1", new String[]{"1"});
        this.checkCommaSplit(" 1 2 ", new String[]{"1 2"});
        this.checkCommaSplit(" 1 , 2 ", new String[]{"1", "2"});
        this.checkCommaSplit("1,2,3,4", new String[]{"1", "2", "3", "4"});
    }

    void checkCommaSplit(String input, String[] expected) {
        List actual = LangUtil.commaSplit(input);
        String a2 = "" + actual;
        String e2 = "" + Arrays.asList(expected);
        Assert.assertTrue((String)(e2 + "==" + a2), (boolean)e2.equals(a2));
    }

    public void testElideEndingLines() {
        StringBuffer stackBuffer = LangUtil.stackToString(new RuntimeException(""), true);
        LangUtil.elideEndingLines(LangUtil.StringChecker.TEST_PACKAGES, stackBuffer, 10);
        String result = stackBuffer.toString();
        if (-1 == result.indexOf("(... ")) {
            String m2 = "when running under eclipse or Ant, expecting (... in trace: ";
            Assert.assertTrue((String)(m2 + result), (boolean)false);
        }
        stackBuffer = new StringBuffer("java.lang.RuntimeException: unimplemented\n at org.aspectj.ajdt.internal.core.builder.EclipseUnwovenClassFile.writeWovenBytes(EclipseUnwovenClassFile.java:59)\n at org.aspectj.weaver.bcel.BcelWeaver.dump(BcelWeaver.java:271)\n at org.aspectj.weaver.bcel.BcelWeaver.weave(BcelWeaver.java:233)\n at org.aspectj.weaver.bcel.BcelWeaver.weave(BcelWeaver.java:198)\n at org.aspectj.ajdt.internal.core.builder.AjBuildManager.weaveAndGenerateClassFiles(AjBuildanager.java:230)\n at org.aspectj.ajdt.internal.core.builder.AjBuildManager.batchBuild(AjBuildManager.java:50)\n at org.aspectj.ajdt.ajc.AjdtCommand.runCommand(AjdtCommand.java:42)\n at org.aspectj.testing.harness.bridge.CompilerRun.run(CompilerRun.java:222)\n at org.aspectj.testing.run.Runner.runPrivate(Runner.java:363)\n at org.aspectj.testing.run.Runner.runChild(Runner.java:167)\n at org.aspectj.testing.run.Runner.runChild(Runner.java:126)\n at org.aspectj.testing.run.Runner$IteratorWrapper.run(Runner.java:441)\n at org.aspectj.testing.run.Runner.runPrivate(Runner.java:363)\n at org.aspectj.testing.run.Runner.runChild(Runner.java:167)\n at org.aspectj.testing.run.Runner.runChild(Runner.java:126)\n at org.aspectj.testing.run.Runner$IteratorWrapper.run(Runner.java:441)\n at org.aspectj.testing.run.Runner.runPrivate(Runner.java:363)\n at org.aspectj.testing.run.Runner.run(Runner.java:114)\n at org.aspectj.testing.run.Runner.run(Runner.java:105)\n at org.aspectj.testing.run.Runner.runIterator(Runner.java:228)\n at org.aspectj.testing.drivers.Harness.run(Harness.java:254)\n at org.aspectj.testing.drivers.Harness.runMain(Harness.java:217)\n at org.aspectj.testing.drivers.Harness.main(Harness.java:99)\n at org.aspectj.testing.Harness.main(Harness.java:37)\n clip me");
        LangUtil.elideEndingLines(LangUtil.StringChecker.TEST_PACKAGES, stackBuffer, 25);
        result = stackBuffer.toString();
        Assert.assertTrue((String)result, (-1 != result.indexOf("(... ") ? 1 : 0) != 0);
        Assert.assertTrue((String)result, (-1 == result.indexOf("org.aspectj.testing") ? 1 : 0) != 0);
    }
}

