/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.util.FileUtil;

public class LangUtil {
    private static final Map VM_CLASSES;
    public static final String EOL;
    private static boolean is13VMOrGreater;
    private static boolean is14VMOrGreater;
    private static boolean is15VMOrGreater;
    static /* synthetic */ Class class$java$lang$Object;

    public static final boolean supportsJava(String version) {
        LangUtil.throwIaxIfNull(version, "version");
        String className = (String)VM_CLASSES.get(version);
        if (null == className) {
            throw new IllegalArgumentException("unknown version: " + version);
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public static boolean is13VMOrGreater() {
        return is13VMOrGreater;
    }

    public static boolean is14VMOrGreater() {
        return is14VMOrGreater;
    }

    public static boolean is15VMOrGreater() {
        return is15VMOrGreater;
    }

    public static final void throwIaxIfNull(Object o2, String name) {
        if (null == o2) {
            String message = "null " + (null == name ? "input" : name);
            throw new IllegalArgumentException(message);
        }
    }

    public static final void throwIaxIfNotAssignable(Object[] ra, Class c2, String name) {
        LangUtil.throwIaxIfNull(ra, name);
        String label = null == name ? "input" : name;
        for (int i2 = 0; i2 < ra.length; ++i2) {
            Class<?> actualClass;
            if (null == ra[i2]) {
                String m2 = " null " + label + "[" + i2 + "]";
                throw new IllegalArgumentException(m2);
            }
            if (null == c2 || c2.isAssignableFrom(actualClass = ra[i2].getClass())) continue;
            String message = label + " not assignable to " + c2.getName();
            throw new IllegalArgumentException(message);
        }
    }

    public static final void throwIaxIfNotAssignable(Object o2, Class c2, String name) {
        Class<?> actualClass;
        LangUtil.throwIaxIfNull(o2, name);
        if (null != c2 && !c2.isAssignableFrom(actualClass = o2.getClass())) {
            String message = name + " not assignable to " + c2.getName();
            throw new IllegalArgumentException(message);
        }
    }

    public static final void throwIaxIfNotAllAssignable(Collection collection, Class c2, String name) {
        LangUtil.throwIaxIfNull(collection, name);
        if (null != c2) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                LangUtil.throwIaxIfNotAssignable(iter.next(), c2, name);
            }
        }
    }

    public static final void throwIaxIfFalse(boolean test, String message) {
        if (!test) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isEmptyTrimmed(String s2) {
        return null == s2 || 0 == s2.length() || 0 == s2.trim().length();
    }

    public static boolean isEmpty(String s2) {
        return null == s2 || 0 == s2.length();
    }

    public static boolean isEmpty(Object[] ra) {
        return null == ra || 0 == ra.length;
    }

    public static boolean isEmpty(Collection collection) {
        return null == collection || 0 == collection.size();
    }

    public static String[] split(String text) {
        return LangUtil.strings(text).toArray(new String[0]);
    }

    public static List commaSplit(String input) {
        return LangUtil.anySplit(input, ",");
    }

    public static String[] splitClasspath(String classpath) {
        if (LangUtil.isEmpty(classpath)) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<String> result = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (LangUtil.isEmpty(entry)) continue;
            result.add(entry);
        }
        return result.toArray(new String[0]);
    }

    public static boolean getBoolean(String propertyName, boolean defaultValue) {
        if (null != propertyName) {
            try {
                String value = System.getProperty(propertyName);
                if (null != value) {
                    return Boolean.valueOf(value);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static List anySplit(String input, String delim) {
        if (null == input) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (LangUtil.isEmpty(delim) || -1 == input.indexOf(delim)) {
            result.add(input.trim());
        } else {
            StringTokenizer st = new StringTokenizer(input, delim);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    public static List strings(String text) {
        if (LangUtil.isEmpty(text)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(text);
        while (tok.hasMoreTokens()) {
            strings.add(tok.nextToken());
        }
        return strings;
    }

    public static List safeList(List list) {
        return null == list ? Collections.EMPTY_LIST : Collections.unmodifiableList(list);
    }

    public static String[] endsWith(String[] inputs, String[] suffixes, boolean ignoreCase) {
        int i2;
        if (LangUtil.isEmpty(inputs) || LangUtil.isEmpty(suffixes)) {
            return new String[0];
        }
        if (ignoreCase) {
            String[] temp = new String[suffixes.length];
            for (i2 = 0; i2 < temp.length; ++i2) {
                String suff = suffixes[i2];
                temp[i2] = null == suff ? null : suff.toLowerCase();
            }
            suffixes = temp;
        }
        ArrayList<String> result = new ArrayList<String>();
        block1: for (i2 = 0; i2 < inputs.length; ++i2) {
            String input = inputs[i2];
            if (null == input) continue;
            if (!ignoreCase) {
                input = input.toLowerCase();
            }
            for (int j2 = 0; j2 < suffixes.length; ++j2) {
                String suffix = suffixes[j2];
                if (null == suffix || !input.endsWith(suffix)) continue;
                result.add(input);
                continue block1;
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] selectDirectories(String[] inputs, File baseDir) {
        if (LangUtil.isEmpty(inputs)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            File inputFile;
            String input = inputs[i2];
            if (null == input || !(inputFile = new File(baseDir, input)).canRead() || !inputFile.isDirectory()) continue;
            result.add(input);
        }
        return result.toArray(new String[0]);
    }

    public static String[][] copyStrings(String[][] in) {
        String[][] out = new String[in.length][];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = new String[in[i2].length];
            System.arraycopy(in[i2], 0, out[i2], 0, out[i2].length);
        }
        return out;
    }

    public static String[] extractOptions(String[] args, String[][] options) {
        if (LangUtil.isEmpty(args) || LangUtil.isEmpty((Object[])options)) {
            return args;
        }
        BitSet foundSet = new BitSet();
        String[] result = new String[args.length];
        int resultIndex = 0;
        for (int j2 = 0; j2 < args.length; ++j2) {
            boolean found = false;
            for (int i2 = 0; !found && i2 < options.length; ++i2) {
                Object[] option = options[i2];
                LangUtil.throwIaxIfFalse(!LangUtil.isEmpty(option), "options");
                Object sought = option[0];
                found = ((String)sought).equals(args[j2]);
                if (!found) continue;
                foundSet.set(i2);
                int doMore = option.length - 1;
                if (0 >= doMore) continue;
                int MAX = j2 + doMore;
                if (MAX >= args.length) {
                    String s2 = "expecting " + doMore + " args after ";
                    throw new IllegalArgumentException(s2 + args[j2]);
                }
                for (int k2 = 1; k2 < option.length; ++k2) {
                    option[k2] = args[++j2];
                }
            }
            if (found) continue;
            result[resultIndex++] = args[j2];
        }
        for (int i3 = 0; i3 < options.length; ++i3) {
            if (foundSet.get(i3)) continue;
            options[i3][0] = null;
        }
        if (resultIndex < args.length) {
            String[] temp = new String[resultIndex];
            System.arraycopy(result, 0, temp, 0, resultIndex);
            args = temp;
        }
        return args;
    }

    public static String[] extractOptions(String[] args, String[] validOptions, int[] optionArgs, List extracted) {
        if (LangUtil.isEmpty(args) || LangUtil.isEmpty(validOptions)) {
            return args;
        }
        if (null != optionArgs && optionArgs.length != validOptions.length) {
            throw new IllegalArgumentException("args must match options");
        }
        String[] result = new String[args.length];
        int resultIndex = 0;
        for (int j2 = 0; j2 < args.length; ++j2) {
            boolean found = false;
            for (int i2 = 0; !found && i2 < validOptions.length; ++i2) {
                int doMore;
                String sought = validOptions[i2];
                int n2 = doMore = null == optionArgs ? 0 : optionArgs[i2];
                if (LangUtil.isEmpty(sought) || !(found = sought.equals(args[j2]))) continue;
                if (null != extracted) {
                    extracted.add(sought);
                }
                if (0 >= doMore) break;
                int MAX = j2 + doMore;
                if (MAX >= args.length) {
                    String s2 = "expecting " + doMore + " args after ";
                    throw new IllegalArgumentException(s2 + args[j2]);
                }
                if (null != extracted) {
                    while (j2 < MAX) {
                        extracted.add(args[++j2]);
                    }
                    break;
                }
                j2 = MAX;
                break;
            }
            if (found) continue;
            result[resultIndex++] = args[j2];
        }
        if (resultIndex < args.length) {
            String[] temp = new String[resultIndex];
            System.arraycopy(result, 0, temp, 0, resultIndex);
            args = temp;
        }
        return args;
    }

    public static String[] selectOptions(String[] args, String[] validOptions) {
        if (LangUtil.isEmpty(args) || LangUtil.isEmpty(validOptions)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        block0: for (int i2 = 0; i2 < validOptions.length; ++i2) {
            String sought = validOptions[i2];
            if (LangUtil.isEmpty(sought)) continue;
            for (int j2 = 0; j2 < args.length; ++j2) {
                if (!sought.equals(args[j2])) continue;
                result.add(sought);
                continue block0;
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[] selectOptions(List args, String[] validOptions) {
        if (LangUtil.isEmpty(args) || LangUtil.isEmpty(validOptions)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        block0: for (int i2 = 0; i2 < validOptions.length; ++i2) {
            String sought = validOptions[i2];
            if (LangUtil.isEmpty(sought)) continue;
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                String arg = (String)iter.next();
                if (!sought.equals(arg)) continue;
                result.add(sought);
                continue block0;
            }
        }
        return result.toArray(new String[0]);
    }

    public static String[][] optionVariants(String[] options) {
        if (null == options || 0 == options.length) {
            return new String[][]{new String[0]};
        }
        String[] temp = new String[options.length];
        System.arraycopy(options, 0, temp, 0, temp.length);
        options = temp;
        boolean[] dup = new boolean[options.length];
        int numDups = 0;
        for (int i2 = 0; i2 < options.length; ++i2) {
            String option = options[i2];
            if (LangUtil.isEmpty(option)) {
                throw new IllegalArgumentException("empty option at " + i2);
            }
            if (!option.endsWith("-")) continue;
            options[i2] = option.substring(0, option.length() - 1);
            dup[i2] = true;
            ++numDups;
        }
        String[] NONE = new String[]{};
        int variants = LangUtil.exp(2, numDups);
        String[][] result = new String[variants][];
        for (int variant = 0; variant < variants; ++variant) {
            ArrayList<String> next = new ArrayList<String>();
            int nextOption = 0;
            for (int k2 = 0; k2 < options.length; ++k2) {
                if (dup[k2] && 0 == (variant & 1 << nextOption++)) continue;
                next.add(options[k2]);
            }
            result[variant] = next.toArray(NONE);
        }
        return result;
    }

    private static int exp(int base, int power) {
        if (0 > power) {
            throw new IllegalArgumentException("negative power: " + power);
        }
        int result = 1;
        while (0 < power--) {
            result *= base;
        }
        return result;
    }

    public static final Object[] copy(Object[] source) {
        LangUtil.throwIaxIfNull(source, "source");
        Class<?> c2 = source.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(c2, source.length);
        System.arraycopy(source, 0, result, 0, result.length);
        return result;
    }

    public static Object[] safeCopy(Object[] source, Object[] sink) {
        int resultSize;
        Class clazz = null == sink ? (class$java$lang$Object == null ? (class$java$lang$Object = LangUtil.class$("java.lang.Object")) : class$java$lang$Object) : sink.getClass().getComponentType();
        Class sinkType = clazz;
        int sourceLength = null == source ? 0 : source.length;
        int sinkLength = null == sink ? 0 : sink.length;
        ArrayList<Object> result = null;
        if (0 == sourceLength) {
            resultSize = 0;
        } else {
            result = new ArrayList<Object>(sourceLength);
            for (int i2 = 0; i2 < sourceLength; ++i2) {
                if (null == source[i2] || !sinkType.isAssignableFrom(source[i2].getClass())) continue;
                result.add(source[i2]);
            }
            resultSize = result.size();
        }
        if (resultSize != sinkLength) {
            sink = (Object[])Array.newInstance(sinkType, result.size());
        }
        if (0 < resultSize) {
            sink = result.toArray(sink);
        }
        return sink;
    }

    public static String unqualifiedClassName(Class c2) {
        if (null == c2) {
            return "null";
        }
        String name = c2.getName();
        int loc = name.lastIndexOf(".");
        if (-1 != loc) {
            name = name.substring(1 + loc);
        }
        return name;
    }

    public static String unqualifiedClassName(Object o2) {
        return LangUtil.unqualifiedClassName(null == o2 ? null : o2.getClass());
    }

    public static String replace(String in, String sought, String replace) {
        int loc;
        if (LangUtil.isEmpty(in) || LangUtil.isEmpty(sought)) {
            return in;
        }
        StringBuffer result = new StringBuffer();
        int len = sought.length();
        int start = 0;
        while (-1 != (loc = in.indexOf(sought, start))) {
            result.append(in.substring(start, loc));
            if (!LangUtil.isEmpty(replace)) {
                result.append(in.substring(start, loc));
            }
            start = loc + len;
        }
        result.append(in.substring(start));
        return result.toString();
    }

    public static String toSizedString(long i2, int width) {
        String result = "" + i2;
        int size = result.length();
        if (width > size) {
            String pad = "                                              ";
            int padLength = "                                              ".length();
            if (width > padLength) {
                width = padLength;
            }
            int topad = width - size;
            result = "                                              ".substring(0, topad) + result;
        }
        return result;
    }

    static String clipBuffer(StringBuffer buffer, int maxLines) {
        if (null == buffer || 1 > buffer.length()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int j2 = 0;
        int MAX = maxLines;
        int N = buffer.length();
        int i2 = 0;
        int srcBegin = 0;
        while (i2 < MAX) {
            char[] chars = new char[128];
            int srcEnd = srcBegin + chars.length;
            if (srcEnd >= N) {
                srcEnd = N - 1;
            }
            if (srcBegin == srcEnd) break;
            buffer.getChars(srcBegin, srcEnd, chars, 0);
            for (j2 = 0; j2 < srcEnd - srcBegin; ++j2) {
                char c2 = chars[j2];
                if (c2 != '\n') continue;
                ++i2;
                ++j2;
                break;
            }
            try {
                result.append(chars, 0, j2);
            }
            catch (Throwable t2) {
                // empty catch block
            }
            srcBegin += j2;
        }
        return result.toString();
    }

    public static String renderExceptionShort(Throwable e2) {
        if (null == e2) {
            return "(Throwable) null";
        }
        return "(" + LangUtil.unqualifiedClassName(e2) + ") " + e2.getMessage();
    }

    public static String renderException(Throwable t2) {
        return LangUtil.renderException(t2, true);
    }

    public static String renderException(Throwable t2, boolean elide) {
        if (null == t2) {
            return "null throwable";
        }
        t2 = LangUtil.unwrapException(t2);
        StringBuffer stack = LangUtil.stackToString(t2, false);
        if (elide) {
            LangUtil.elideEndingLines(StringChecker.TEST_PACKAGES, stack, 100);
        }
        return stack.toString();
    }

    static void elideEndingLines(StringChecker checker, StringBuffer stack, int maxLines) {
        String line;
        if (null == checker || null == stack || 0 == stack.length()) {
            return;
        }
        LinkedList<String> lines = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(stack.toString(), "\n\r");
        while (st.hasMoreTokens() && 0 < --maxLines) {
            lines.add(st.nextToken());
        }
        st = null;
        int elided = 0;
        while (!lines.isEmpty() && checker.acceptString(line = (String)lines.getLast())) {
            ++elided;
            lines.removeLast();
        }
        if (elided > 0 || maxLines < 1) {
            int EOL_LEN = EOL.length();
            int totalLength = 0;
            while (!lines.isEmpty()) {
                totalLength += EOL_LEN + ((String)lines.getFirst()).length();
                lines.removeFirst();
            }
            if (stack.length() > totalLength) {
                stack.setLength(totalLength);
                if (elided > 0) {
                    stack.append("    (... " + elided + " lines...)");
                }
            }
        }
    }

    public static StringBuffer stackToString(Throwable throwable, boolean skipMessage) {
        if (null == throwable) {
            return new StringBuffer();
        }
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        if (!skipMessage) {
            writer.println(throwable.getMessage());
        }
        throwable.printStackTrace(writer);
        try {
            buf.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return buf.getBuffer();
    }

    public static Throwable unwrapException(Throwable t2) {
        Throwable current = t2;
        Throwable next = null;
        while (current != null) {
            if (current instanceof InvocationTargetException) {
                next = ((InvocationTargetException)current).getTargetException();
            } else if (current instanceof ClassNotFoundException) {
                next = ((ClassNotFoundException)current).getException();
            } else if (current instanceof ExceptionInInitializerError) {
                next = ((ExceptionInInitializerError)current).getException();
            } else if (current instanceof PrivilegedActionException) {
                next = ((PrivilegedActionException)current).getException();
            } else if (current instanceof SQLException) {
                next = ((SQLException)current).getNextException();
            }
            if (null == next) break;
            current = next;
            next = null;
        }
        return current;
    }

    public static List arrayAsList(Object[] array) {
        if (null == array || 1 > array.length) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(array));
        return list;
    }

    public static String makeClasspath(String bootclasspath, String classpath, String classesDir, String outputJar) {
        StringBuffer sb = new StringBuffer();
        LangUtil.addIfNotEmpty(bootclasspath, sb, File.pathSeparator);
        LangUtil.addIfNotEmpty(classpath, sb, File.pathSeparator);
        if (!LangUtil.addIfNotEmpty(classesDir, sb, File.pathSeparator)) {
            LangUtil.addIfNotEmpty(outputJar, sb, File.pathSeparator);
        }
        return sb.toString();
    }

    private static boolean addIfNotEmpty(String input, StringBuffer sink, String delimiter) {
        if (LangUtil.isEmpty(input) || null == sink) {
            return false;
        }
        sink.append(input);
        if (!LangUtil.isEmpty(delimiter)) {
            sink.append(delimiter);
        }
        return true;
    }

    public static ProcessController makeProcess(ProcessController controller, String classpath, String mainClass, String[] args) {
        File java = LangUtil.getJavaExecutable();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java.getAbsolutePath());
        cmd.add("-classpath");
        cmd.add(classpath);
        cmd.add(mainClass);
        if (!LangUtil.isEmpty(args)) {
            cmd.addAll(Arrays.asList(args));
        }
        String[] command = cmd.toArray(new String[0]);
        if (null == controller) {
            controller = new ProcessController();
        }
        controller.init(command, mainClass);
        return controller;
    }

    public static ProcessController makeProcess(ProcessController controller, String[] command, String label) {
        if (null == controller) {
            controller = new ProcessController();
        }
        controller.init(command, label);
        return controller;
    }

    public static File getJavaExecutable() {
        File binDir;
        String javaHome = null;
        File result = null;
        try {
            javaHome = System.getProperty("java.home");
        }
        catch (Throwable t2) {
            // empty catch block
        }
        if (null != javaHome && (binDir = new File(javaHome, "bin")).isDirectory() && binDir.canRead()) {
            String[] execs = new String[]{"java", "java.exe"};
            for (int i2 = 0; i2 < execs.length && !(result = new File(binDir, execs[i2])).canRead(); ++i2) {
            }
        }
        return result;
    }

    public static boolean sleep(long milliseconds) {
        if (milliseconds == 0L) {
            return true;
        }
        if (milliseconds < 0L) {
            throw new IllegalArgumentException("negative: " + milliseconds);
        }
        return LangUtil.sleepUntil(milliseconds + System.currentTimeMillis());
    }

    public static boolean sleepUntil(long time) {
        if (time == 0L) {
            return true;
        }
        if (time < 0L) {
            throw new IllegalArgumentException("negative: " + time);
        }
        long curTime = System.currentTimeMillis();
        for (int i2 = 0; i2 < 100 && curTime < time; ++i2) {
            try {
                Thread.sleep(time - curTime);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            curTime = System.currentTimeMillis();
        }
        return curTime >= time;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        writer.println("");
        String eol = "\n";
        try {
            buf.close();
            StringBuffer sb = buf.getBuffer();
            if (null != sb || 0 < sb.length()) {
                eol = buf.toString();
            }
        }
        catch (Throwable t2) {
            // empty catch block
        }
        EOL = eol;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1.2", "java.lang.ref.Reference");
        map.put("1.3", "java.lang.reflect.Proxy");
        map.put("1.4", "java.nio.Buffer");
        map.put("1.5", "java.lang.annotation.Annotation");
        VM_CLASSES = Collections.unmodifiableMap(map);
        is13VMOrGreater = true;
        is14VMOrGreater = true;
        is15VMOrGreater = false;
        String vm = System.getProperty("java.runtime.version");
        if (vm == null) {
            vm = System.getProperty("java.vm.version");
        }
        if (vm.startsWith("1.3")) {
            is14VMOrGreater = false;
        } else if (vm.startsWith("1.5")) {
            is15VMOrGreater = true;
        }
    }

    public static class ProcessController {
        private String[] command;
        private String[] envp;
        private String label;
        private boolean init;
        private boolean started;
        private boolean completed;
        private boolean userStopped;
        private Process process;
        private FileUtil.Pipe errStream;
        private FileUtil.Pipe outStream;
        private FileUtil.Pipe inStream;
        private ByteArrayOutputStream errSnoop;
        private ByteArrayOutputStream outSnoop;
        private int result;
        private Thrown thrown;

        public final void reinit() {
            if (!this.init) {
                throw new IllegalStateException("must init(..) before reinit()");
            }
            if (this.started && !this.completed) {
                throw new IllegalStateException("not completed - do stop()");
            }
            this.started = false;
            this.completed = false;
            this.result = Integer.MIN_VALUE;
            this.thrown = null;
            this.process = null;
            this.errStream = null;
            this.outStream = null;
            this.inStream = null;
        }

        public final void init(String classpath, String mainClass, String[] args) {
            this.init(LangUtil.getJavaExecutable(), classpath, mainClass, args);
        }

        public final void init(File java, String classpath, String mainClass, String[] args) {
            LangUtil.throwIaxIfNull(java, "java");
            LangUtil.throwIaxIfNull(mainClass, "mainClass");
            LangUtil.throwIaxIfNull(args, "args");
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(java.getAbsolutePath());
            cmd.add("-classpath");
            cmd.add(classpath);
            cmd.add(mainClass);
            if (!LangUtil.isEmpty(args)) {
                cmd.addAll(Arrays.asList(args));
            }
            this.init(cmd.toArray(new String[0]), mainClass);
        }

        public final void init(String[] command, String label) {
            this.command = (String[])LangUtil.safeCopy(command, new String[0]);
            if (1 > this.command.length) {
                throw new IllegalArgumentException("empty command");
            }
            this.label = LangUtil.isEmpty(label) ? command[0] : label;
            this.init = true;
            this.reinit();
        }

        public final void setEnvp(String[] envp) {
            this.envp = (String[])LangUtil.safeCopy(envp, new String[0]);
            if (1 > this.envp.length) {
                throw new IllegalArgumentException("empty envp");
            }
        }

        public final void setErrSnoop(ByteArrayOutputStream snoop) {
            this.errSnoop = snoop;
            if (null != this.errStream) {
                this.errStream.setSnoop(this.errSnoop);
            }
        }

        public final void setOutSnoop(ByteArrayOutputStream snoop) {
            this.outSnoop = snoop;
            if (null != this.outStream) {
                this.outStream.setSnoop(this.outSnoop);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Thread start() {
            if (!this.init) {
                throw new IllegalStateException("not initialized");
            }
            ProcessController processController = this;
            synchronized (processController) {
                if (this.started) {
                    throw new IllegalStateException("already started");
                }
                this.started = true;
            }
            try {
                this.process = Runtime.getRuntime().exec(this.command);
            }
            catch (IOException e2) {
                this.stop(e2, Integer.MIN_VALUE);
                return null;
            }
            this.errStream = new FileUtil.Pipe(this.process.getErrorStream(), System.err);
            if (null != this.errSnoop) {
                this.errStream.setSnoop(this.errSnoop);
            }
            this.outStream = new FileUtil.Pipe(this.process.getInputStream(), System.out);
            if (null != this.outSnoop) {
                this.outStream.setSnoop(this.outSnoop);
            }
            this.inStream = new FileUtil.Pipe(System.in, this.process.getOutputStream());
            Runnable processRunner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Throwable thrown = null;
                    int result = Integer.MIN_VALUE;
                    try {
                        new Thread(ProcessController.this.errStream).start();
                        new Thread(ProcessController.this.outStream).start();
                        new Thread(ProcessController.this.inStream).start();
                        ProcessController.this.process.waitFor();
                        result = ProcessController.this.process.exitValue();
                    }
                    catch (Throwable e2) {
                        thrown = e2;
                    }
                    finally {
                        ProcessController.this.stop(thrown, result);
                    }
                }
            };
            Thread result = new Thread(processRunner, this.label);
            result.start();
            return result;
        }

        public final synchronized void stop() {
            if (this.completed) {
                return;
            }
            this.userStopped = true;
            this.stop(null, Integer.MIN_VALUE);
        }

        public final String[] getCommand() {
            Object[] toCopy = this.command;
            if (LangUtil.isEmpty(toCopy)) {
                return new String[0];
            }
            String[] result = new String[toCopy.length];
            System.arraycopy(toCopy, 0, result, 0, result.length);
            return result;
        }

        public final boolean completed() {
            return this.completed;
        }

        public final boolean started() {
            return this.started;
        }

        public final boolean userStopped() {
            return this.userStopped;
        }

        public final Thrown getThrown() {
            return this.makeThrown(null);
        }

        public final int getResult() {
            return this.result;
        }

        protected void doCompleting(Thrown thrown, int result) {
        }

        private final synchronized void stop(Throwable thrown, int result) {
            if (this.completed) {
                throw new IllegalStateException("already completed");
            }
            if (null != this.thrown) {
                throw new IllegalStateException("already set thrown: " + thrown);
            }
            this.thrown = this.makeThrown(thrown);
            if (null != this.process) {
                this.process.destroy();
            }
            if (null != this.inStream) {
                this.inStream.halt(false, true);
                this.inStream = null;
            }
            if (null != this.outStream) {
                this.outStream.halt(true, true);
                this.outStream = null;
            }
            if (null != this.errStream) {
                this.errStream.halt(true, true);
                this.errStream = null;
            }
            if (Integer.MIN_VALUE != result) {
                this.result = result;
            }
            this.completed = true;
            this.doCompleting(this.thrown, result);
        }

        private final synchronized Thrown makeThrown(Throwable processThrown) {
            if (null != this.thrown) {
                return this.thrown;
            }
            return new Thrown(processThrown, null == this.outStream ? null : this.outStream.getThrown(), null == this.errStream ? null : this.errStream.getThrown(), null == this.inStream ? null : this.inStream.getThrown());
        }

        public static class Thrown {
            public final Throwable fromProcess;
            public final Throwable fromErrPipe;
            public final Throwable fromOutPipe;
            public final Throwable fromInPipe;
            public final boolean thrown;

            private Thrown(Throwable fromProcess, Throwable fromOutPipe, Throwable fromErrPipe, Throwable fromInPipe) {
                this.fromProcess = fromProcess;
                this.fromErrPipe = fromErrPipe;
                this.fromOutPipe = fromOutPipe;
                this.fromInPipe = fromInPipe;
                this.thrown = null != fromProcess || null != fromInPipe || null != fromOutPipe || null != fromErrPipe;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                this.append(sb, this.fromProcess, "process");
                this.append(sb, this.fromOutPipe, " stdout");
                this.append(sb, this.fromErrPipe, " stderr");
                this.append(sb, this.fromInPipe, "  stdin");
                if (0 == sb.length()) {
                    return "Thrown (none)";
                }
                return sb.toString();
            }

            private void append(StringBuffer sb, Throwable thrown, String label) {
                if (null != thrown) {
                    sb.append("from " + label + ": ");
                    sb.append(LangUtil.renderExceptionShort(thrown));
                    sb.append(EOL);
                }
            }
        }
    }

    public static class StringChecker {
        static StringChecker TEST_PACKAGES = new StringChecker(new String[]{"org.aspectj.testing", "org.eclipse.jdt.internal.junit", "junit.framework.", "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner"});
        String[] infixes;

        StringChecker(String[] infixes) {
            this.infixes = infixes;
        }

        public boolean acceptString(String input) {
            boolean result = false;
            if (!LangUtil.isEmpty(input)) {
                for (int i2 = 0; !result && i2 < this.infixes.length; ++i2) {
                    result = -1 != input.indexOf(this.infixes[i2]);
                }
            }
            return result;
        }
    }
}

