/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.testing.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jdiff.text.FileLine;
import jdiff.util.Diff;
import jdiff.util.DiffNormalOutput;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.TestCaseClassLoader;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.aspectj.util.Reflection;

public final class TestUtil {
    private static final boolean JAVA_5_VM;
    private static final String ASPECTJRT_KEY = "aspectjrt";
    private static final String TESTING_CLIENT_KEY = "testing-client";
    public static final URL BAD_URL;
    private static final File LIB_DIR;
    private static final Properties LIB_RPATHS;
    private static final Map LIB_ENTRIES;
    private static File ASPECTJRT_PATH;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$PrintStream;

    private static boolean isLibDir(File lib) {
        return new File(lib, "test" + File.separator + "aspectjrt.jar").exists();
    }

    private TestUtil() {
    }

    public static boolean is15VMOrGreater() {
        return JAVA_5_VM;
    }

    public static File aspectjrtPath() {
        return ASPECTJRT_PATH;
    }

    public static URL fileToURL(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException e2) {
            return null;
        }
    }

    public static String filesToPath(File[] entries) {
        return TestUtil.toPath(entries);
    }

    public static String urlsToPath(URL[] entries) {
        return TestUtil.toPath(entries);
    }

    public static String filesOrurlsToPath(Object[] entries) {
        return TestUtil.toPath(entries);
    }

    private static String toPath(Object[] entries) {
        if (null == entries || 0 == entries.length) {
            return "";
        }
        StringBuffer path = new StringBuffer();
        boolean started = false;
        for (int i2 = 0; i2 < entries.length; ++i2) {
            if (null == entries[i2]) continue;
            if (started) {
                path.append(File.pathSeparator);
            } else {
                started = true;
            }
            path.append(entries[i2].toString());
        }
        return path.toString();
    }

    public static boolean parseBoolean(String input) {
        return TestUtil.parseBoolean(input, true);
    }

    public static boolean parseBoolean(String input, boolean iaxOnError) {
        String syntax = ": [on|off|true|false]";
        if (null == input) {
            return false;
        }
        String lc = input.trim().toLowerCase();
        boolean result = false;
        boolean valid = false;
        switch (lc.length()) {
            case 2: {
                valid = "on".equals(lc);
                if (!valid) break;
                result = true;
                break;
            }
            case 3: {
                valid = "off".equals(lc);
                break;
            }
            case 4: {
                valid = "true".equals(lc);
                if (!valid) break;
                result = true;
                break;
            }
            case 5: {
                valid = "false".equals(lc);
            }
        }
        if (iaxOnError && !valid) {
            throw new IllegalArgumentException(input + ": [on|off|true|false]");
        }
        return result;
    }

    public static File aspectjrtJarFile() {
        return (File)LIB_ENTRIES.get("aspectjrt.file");
    }

    public static URL aspectjrtJarURL() {
        return (URL)LIB_ENTRIES.get("aspectjrt.url");
    }

    public static File testingClientJarFile() {
        return (File)LIB_ENTRIES.get("testing-client.file");
    }

    public static URL testingClientJarURL() {
        return (URL)LIB_ENTRIES.get("testing-client.url");
    }

    public static File libFile(String rpath) {
        if (null == rpath || 0 == rpath.length()) {
            throw new IllegalArgumentException("no input");
        }
        File result = new File(LIB_DIR, rpath = rpath.replace('/', File.separatorChar));
        if (result.exists()) {
            return result;
        }
        throw new IllegalArgumentException("not in " + LIB_DIR + ": " + rpath);
    }

    public static URL libURL(String rpath) {
        File file = TestUtil.libFile(rpath);
        try {
            return file.toURL();
        }
        catch (MalformedURLException e2) {
            throw new IllegalArgumentException("bad URL from: " + file);
        }
    }

    public static void assertArrayEquals(String msg, Object[] expected, Object[] found) {
        Assert.assertEquals((String)msg, Arrays.asList(expected), Arrays.asList(found));
    }

    public static void assertSetEquals(Collection expected, Collection found) {
        TestUtil.assertSetEquals(null, expected, found);
    }

    public static void assertSetEquals(String msg, Object[] expected, Object[] found) {
        TestUtil.assertSetEquals(msg, Arrays.asList(expected), Arrays.asList(found));
    }

    public static void assertSetEquals(String msg, Collection expected, Collection found) {
        msg = msg == null ? "" : msg + ": ";
        HashSet results1 = new HashSet(found);
        results1.removeAll(expected);
        HashSet results2 = new HashSet(expected);
        results2.removeAll(found);
        if (results1.isEmpty()) {
            Assert.assertTrue((String)(msg + "Expected but didn't find: " + ((Object)results2).toString()), (boolean)results2.isEmpty());
        } else if (results2.isEmpty()) {
            Assert.assertTrue((String)(msg + "Didn't expect: " + ((Object)results1).toString()), (boolean)results1.isEmpty());
        } else {
            Assert.assertTrue((String)(msg + "Expected but didn't find: " + ((Object)results2).toString() + "\nDidn't expect: " + ((Object)results1).toString()), (boolean)false);
        }
    }

    public static void assertCommutativeEquals(Object a2, Object b2, boolean should) {
        Assert.assertEquals((String)(a2 + " equals " + b2), (boolean)should, (boolean)a2.equals(b2));
        Assert.assertEquals((String)(b2 + " equals " + a2), (boolean)should, (boolean)b2.equals(a2));
        TestUtil.assertHashEquals(a2, b2, should);
    }

    private static void assertHashEquals(Object s2, Object t2, boolean should) {
        if (should) {
            Assert.assertTrue((String)(s2 + " does not hash to same as " + t2), (s2.hashCode() == t2.hashCode() ? 1 : 0) != 0);
        } else if (s2.hashCode() == t2.hashCode()) {
            System.err.println("warning: hash collision with hash = " + t2.hashCode());
            System.err.println("  for " + s2);
            System.err.println("  and " + t2);
        }
    }

    public static void runMain(String classPath, String className) {
        TestUtil.runMethod(classPath, className, "main", new Object[]{new String[0]});
    }

    public static Object runMethod(String classPath, String className, String methodName, Object[] args) {
        classPath = classPath + File.pathSeparator + System.getProperty("java.class.path");
        TestCaseClassLoader loader = new TestCaseClassLoader(classPath);
        Class<?> c2 = null;
        try {
            c2 = loader.loadClass(className);
        }
        catch (ClassNotFoundException e2) {
            Assert.assertTrue((String)("unexpected exception: " + e2), (boolean)false);
        }
        return Reflection.invokestaticN(c2, methodName, args);
    }

    public static void assertMultiLineStringEquals(String message, String s1, String s2) {
        try {
            String l2;
            String l1;
            BufferedReader r1 = new BufferedReader(new StringReader(s1));
            BufferedReader r2 = new BufferedReader(new StringReader(s2));
            ArrayList<String> lines = new ArrayList<String>();
            int index = 1;
            while (true) {
                l1 = TestUtil.readNonBlankLine(r1);
                l2 = TestUtil.readNonBlankLine(r2);
                if (l1 == null || l2 == null) break;
                if (l1.equals(l2)) {
                    lines.add(l1);
                } else {
                    TestUtil.showContext(lines);
                    Assert.assertEquals((String)(message + "(line " + index + ")"), (String)l1, (String)l2);
                }
                ++index;
            }
            if (l1 != null) {
                TestUtil.showContext(lines);
            }
            Assert.assertTrue((String)(message + ": unexpected " + l1), (l1 == null ? 1 : 0) != 0);
            if (l2 != null) {
                TestUtil.showContext(lines);
            }
            Assert.assertTrue((String)(message + ": unexpected " + l2), (l2 == null ? 1 : 0) != 0);
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)(message + ": caught " + ioe.getMessage()), (boolean)false);
        }
    }

    private static void showContext(List lines) {
        int n2 = lines.size();
        for (int i2 = Math.max(0, n2 - 8); i2 < n2; ++i2) {
            System.err.println(lines.get(i2));
        }
    }

    private static String readNonBlankLine(BufferedReader r2) throws IOException {
        String l2 = r2.readLine();
        if (l2 == null) {
            return null;
        }
        int commentLoc = (l2 = l2.trim()).indexOf("//");
        if (-1 != commentLoc) {
            l2 = l2.substring(0, commentLoc).trim();
        }
        if ("".equals(l2)) {
            return TestUtil.readNonBlankLine(r2);
        }
        return l2;
    }

    public static boolean sameDirectoryContents(IMessageHandler handler, File expectedBaseDir, File actualBaseDir, boolean fastFail) {
        LangUtil.throwIaxIfNull(handler, "handler");
        if (!FileUtil.canReadDir(expectedBaseDir)) {
            MessageUtil.fail(handler, " expected dir not found: " + expectedBaseDir);
            return false;
        }
        if (!FileUtil.canReadDir(actualBaseDir)) {
            MessageUtil.fail(handler, " actual dir not found: " + actualBaseDir);
            return false;
        }
        String[] paths = FileUtil.listFiles(expectedBaseDir);
        boolean result = true;
        for (int i2 = 0; i2 < paths.length; ++i2) {
            if (-1 != paths[i2].indexOf("CVS") || TestUtil.sameFiles(handler, expectedBaseDir, actualBaseDir, paths[i2]) || !result) continue;
            result = false;
            if (fastFail) break;
        }
        return result;
    }

    public static boolean sameFiles(IMessageHandler handler, File expectedFile, File actualFile) {
        return TestUtil.doSameFile(handler, null, null, expectedFile, actualFile);
    }

    public static boolean sameFiles(IMessageHandler handler, File expectedBaseDir, File actualBaseDir, String path) {
        File actualFile = new File(actualBaseDir, path);
        File expectedFile = new File(expectedBaseDir, path);
        return TestUtil.doSameFile(handler, expectedBaseDir, actualBaseDir, expectedFile, actualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doSameFile(IMessageHandler handler, File expectedBaseDir, File actualBaseDir, File expectedFile, File actualFile) {
        String path = expectedFile.getPath();
        ILineator lineator = ILineator.TEXT;
        if (path.endsWith(".class")) {
            if (ClassLineator.haveDisassembler()) {
                lineator = ILineator.CLASS;
            } else {
                MessageUtil.abort(handler, "skipping - dissassembler not available");
                return false;
            }
        }
        Object[] actualLines = null;
        Object[] expectedLines = null;
        try {
            actualLines = lineator.getLines(handler, actualFile, actualBaseDir);
            expectedLines = lineator.getLines(handler, expectedFile, expectedBaseDir);
        }
        catch (IOException e2) {
            MessageUtil.fail(handler, "rendering lines ", e2);
            return false;
        }
        if (!LangUtil.isEmpty(actualLines) && !LangUtil.isEmpty(expectedLines)) {
            CanonicalLine[][] clines = new CanonicalLine[][]{expectedLines, actualLines};
            FileLine[][] flines = new FileLine[2][];
            for (int i2 = 0; i2 < clines.length; ++i2) {
                CanonicalLine[] cline = clines[i2];
                FileLine[] fline = new FileLine[cline.length];
                for (int j2 = 0; j2 < fline.length; ++j2) {
                    fline[j2] = new FileLine(cline[j2].canonical, cline[j2].line);
                }
                flines[i2] = fline;
            }
            Diff.change edits = new Diff(flines[0], flines[1]).diff_2(false);
            if (null == edits || 0 == edits.inserted + edits.deleted) {
                return true;
            }
            StringWriter writer = new StringWriter();
            DiffNormalOutput out = new DiffNormalOutput(flines[0], flines[1]);
            out.setOut(writer);
            out.setLineSeparator(LangUtil.EOL);
            try {
                out.writeScript(edits);
            }
            catch (IOException e3) {
                MessageUtil.fail(handler, "rendering edits", e3);
            }
            finally {
                if (null != writer) {
                    try {
                        writer.close();
                    }
                    catch (IOException e4) {
                        MessageUtil.fail(handler, "closing after rendering edits", e4);
                    }
                }
            }
            String message = "diff between " + path + " in expected dir " + expectedBaseDir + " and actual dir " + actualBaseDir + LangUtil.EOL + writer.toString();
            MessageUtil.fail(handler, message);
        }
        return false;
    }

    public static String cleanTestName(String name) {
        name = name.replace(' ', '_');
        return name;
    }

    public static Test skipTest(String tests) {
        System.err.println("skipping tests " + tests);
        return TestUtil.testNamed("skipping tests " + tests);
    }

    public static Test testNamed(String named) {
        final String name = TestUtil.cleanTestName(named);
        return new Test(){

            public int countTestCases() {
                return 1;
            }

            public void run(TestResult r2) {
                r2.startTest((Test)this);
                r2.endTest((Test)this);
            }

            public String toString() {
                return name;
            }
        };
    }

    public static void loadTestsReflectively(TestSuite sink, String sourceName, boolean ignoreError) {
        Exception thrown = null;
        try {
            ClassLoader loader = sink.getClass().getClassLoader();
            Class<?> sourceClass = loader.loadClass(sourceName);
            if (!Modifier.isPublic(sourceClass.getModifiers())) {
                TestUtil.errorSuite(sink, sourceName, "not public class");
                return;
            }
            Method suiteMethod = sourceClass.getMethod("suite", new Class[0]);
            int mods = suiteMethod.getModifiers();
            if (!Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
                TestUtil.errorSuite(sink, sourceName, "not static method");
                return;
            }
            if (!Modifier.isPublic(mods)) {
                TestUtil.errorSuite(sink, sourceName, "not public method");
                return;
            }
            if (!(class$junit$framework$Test == null ? (class$junit$framework$Test = TestUtil.class$("junit.framework.Test")) : class$junit$framework$Test).isAssignableFrom(suiteMethod.getReturnType())) {
                TestUtil.errorSuite(sink, sourceName, "suite() does not return Test");
                return;
            }
            Object result = suiteMethod.invoke(null, new Object[0]);
            Test test = (Test)result;
            if (!(test instanceof TestSuite)) {
                sink.addTest(test);
            } else {
                TestSuite source = (TestSuite)test;
                Enumeration tests = source.tests();
                while (tests.hasMoreElements()) {
                    sink.addTest((Test)tests.nextElement());
                }
            }
        }
        catch (ClassNotFoundException e2) {
            thrown = e2;
        }
        catch (SecurityException e3) {
            thrown = e3;
        }
        catch (NoSuchMethodException e4) {
            thrown = e4;
        }
        catch (IllegalArgumentException e5) {
            thrown = e5;
        }
        catch (IllegalAccessException e6) {
            thrown = e6;
        }
        catch (InvocationTargetException e7) {
            thrown = e7;
        }
        if (null != thrown) {
            if (ignoreError) {
                System.err.println("Error loading " + sourceName);
                thrown.printStackTrace(System.err);
            } else {
                TestUtil.errorSuite(sink, sourceName, thrown);
            }
        }
    }

    private static void errorSuite(TestSuite sink, String sourceName, Throwable thrown) {
        sink.addTest((Test)new ErrorTest(sourceName, thrown));
    }

    private static void errorSuite(TestSuite sink, String sourceName, String err) {
        String message = "bad " + sourceName + ": " + err;
        sink.addTest((Test)new ErrorTest(message));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String[] paths = new String[]{"sp:aspectjrt.path", "sp:aspectjrt.jar", "../lib/test/aspectjrt.jar", "../aj-build/jars/aspectj5rt-all.jar", "../aj-build/jars/runtime.jar", "../runtime/bin"};
        ASPECTJRT_PATH = FileUtil.getBestFile(paths);
        boolean j5 = false;
        try {
            Class.forName("java.lang.annotation.Annotation");
            j5 = true;
        }
        catch (Throwable t2) {
            // empty catch block
        }
        JAVA_5_VM = j5;
        URL url = null;
        try {
            url = new URL("http://eclipse.org/BADURL");
        }
        catch (MalformedURLException e2) {
            // empty catch block
        }
        BAD_URL = url;
        File file = new File("lib");
        if (!TestUtil.isLibDir(file)) {
            File parent;
            File cur = new File(".").getAbsoluteFile();
            for (parent = cur.getParentFile(); null != parent && !TestUtil.isLibDir(file = new File(parent, "lib")); parent = parent.getParentFile()) {
            }
            if (null == parent) {
                file = new File("NOT IN ASPECTJ TREE");
            }
        }
        LIB_DIR = file;
        LIB_RPATHS = new Properties();
        LIB_RPATHS.setProperty(ASPECTJRT_KEY, "tests/aspectjrt.jar");
        LIB_RPATHS.setProperty(TESTING_CLIENT_KEY, "tests/testing-client.jar");
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        Iterator iter = ((Hashtable)LIB_RPATHS).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String path = LIB_RPATHS.getProperty(key);
            File file2 = null;
            URL url2 = null;
            try {
                file2 = TestUtil.libFile(path);
                url2 = TestUtil.libURL(path);
            }
            catch (IllegalArgumentException e3) {
                file2 = new File(path + " not found");
                url2 = BAD_URL;
            }
            finally {
                map.put(key + ".file", file2);
                map.put(key + ".url", url2);
            }
        }
        LIB_ENTRIES = Collections.unmodifiableMap(map);
    }

    public static class LineStream
    extends PrintStream {
        StringBuffer sb = new StringBuffer();
        ByteArrayOutputStream missed;
        ArrayList sink = new ArrayList();

        public LineStream() {
            super(new ByteArrayOutputStream());
            this.missed = (ByteArrayOutputStream)this.out;
        }

        public String getMissed() {
            return this.missed.toString();
        }

        public void clear() {
            this.sink.clear();
        }

        public String[] getLines() {
            return this.sink.toArray(new String[0]);
        }

        public void println(Object x2) {
            this.println(x2.toString());
        }

        public void print(Object obj) {
            this.print(obj.toString());
        }

        public void println(char c2) {
            this.sb.append(c2);
            this.println();
        }

        public void println(char[] c2) {
            this.sb.append(c2);
            this.println();
        }

        public void print(char c2) {
            this.sb.append(c2);
        }

        public void print(char[] c2) {
            this.sb.append(c2);
        }

        public void println(String s2) {
            this.print(s2);
            this.println();
        }

        public void print(String s2) {
            this.sb.append(s2);
        }

        public void println() {
            String line = this.sb.toString();
            this.sink.add(line);
            this.sb.setLength(0);
        }
    }

    public static class ClassLineator
    extends Lineator {
        protected void lineate(PrintStream sink, IMessageHandler handler, File basedir, File file) throws IOException {
            String name = FileUtil.fileToClassName(basedir, file);
            ClassLineator.disassemble(handler, basedir, name, sink);
        }

        public static boolean haveDisassembler() {
            try {
                return null != Class.forName("org.aspectj.weaver.bcel.LazyClassGen");
            }
            catch (ClassNotFoundException e2) {
                return false;
            }
        }

        private static void disassemble(IMessageHandler handler, File basedir, String name, PrintStream out) throws IOException {
            Throwable thrown = null;
            String basedirPath = FileUtil.normalizedPath(basedir);
            try {
                Class<?> c2 = Class.forName("org.aspectj.weaver.bcel.LazyClassGen");
                Method m2 = c2.getMethod("disassemble", class$java$lang$String == null ? (class$java$lang$String = TestUtil.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TestUtil.class$("java.lang.String")) : class$java$lang$String, class$java$io$PrintStream == null ? (class$java$io$PrintStream = TestUtil.class$("java.io.PrintStream")) : class$java$io$PrintStream);
                m2.invoke(null, basedirPath, name, out);
            }
            catch (ClassNotFoundException e2) {
                thrown = e2;
            }
            catch (NoSuchMethodException e3) {
                thrown = e3;
            }
            catch (IllegalAccessException e4) {
                thrown = e4;
            }
            catch (InvocationTargetException e5) {
                Throwable t2 = e5.getTargetException();
                if (t2 instanceof IOException) {
                    throw (IOException)t2;
                }
                thrown = t2;
            }
            if (null != thrown) {
                MessageUtil.fail(handler, "disassembling " + name + " path: " + basedirPath, thrown);
            }
        }
    }

    private static class TextLineator
    extends Lineator {
        private TextLineator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void lineate(PrintStream sink, IMessageHandler handler, File basedir, File file) throws IOException {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                FileUtil.copyStream(new DataInputStream(in), sink);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e2) {}
            }
        }
    }

    private static abstract class Lineator
    implements ILineator {
        private Lineator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CanonicalLine[] getLines(IMessageHandler handler, File file, File basedir) throws IOException {
            if (!file.canRead() || !file.isFile()) {
                MessageUtil.error(handler, "not readable file: " + basedir + " - " + file);
                return null;
            }
            InputStream in = null;
            FileUtil.normalizedPath(file, basedir);
            LineStream capture = new LineStream();
            try {
                this.lineate(capture, handler, basedir, file);
            }
            catch (IOException e2) {
                MessageUtil.fail(handler, "NormalizedCompareFiles IOException reading " + file, e2);
                CanonicalLine[] canonicalLineArray = null;
                return canonicalLineArray;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {}
                }
                capture.flush();
                capture.close();
            }
            String missed = capture.getMissed();
            if (!LangUtil.isEmpty(missed)) {
                MessageUtil.warn(handler, "NormalizedCompareFiles missed input: " + missed);
                return null;
            }
            String[] lines = capture.getLines();
            CanonicalLine[] result = new CanonicalLine[lines.length];
            for (int i2 = 0; i2 < lines.length; ++i2) {
                result[i2] = new CanonicalLine(lines[i2], lines[i2]);
            }
            return result;
        }

        protected abstract void lineate(PrintStream var1, IMessageHandler var2, File var3, File var4) throws IOException;
    }

    public static class CanonicalLine {
        public static final CanonicalLine[] NO_LINES = new CanonicalLine[0];
        public final String canonical;
        public final String line;

        public CanonicalLine(String canonical, String line) {
            this.canonical = canonical;
            this.line = line;
        }

        public String toString() {
            return this.line;
        }
    }

    public static interface ILineator {
        public static final ILineator TEXT = new TextLineator();
        public static final ILineator CLASS = new ClassLineator();

        public CanonicalLine[] getLines(IMessageHandler var1, File var2, File var3) throws IOException;
    }

    public static class TestError
    extends Error {
        private Throwable thrown;

        public TestError(String message) {
            super(message);
        }

        public TestError(String message, Throwable thrown) {
            super(message);
            this.thrown = thrown;
        }

        public Throwable getCause() {
            return this.thrown;
        }

        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        public void printStackTrace(PrintStream ps) {
            this.printStackTrace(new PrintWriter(ps));
        }

        public void printStackTrace(PrintWriter pw) {
            super.printStackTrace(pw);
            if (null != this.thrown) {
                pw.print("Caused by: ");
                this.thrown.printStackTrace(pw);
            }
        }
    }

    public static class ErrorTest
    implements Test {
        private final Throwable thrown;

        public ErrorTest(Throwable thrown) {
            this.thrown = thrown;
        }

        public ErrorTest(String message) {
            this.thrown = new Error(message);
        }

        public ErrorTest(String message, Throwable thrown) {
            this(new TestError(message, thrown));
        }

        public int countTestCases() {
            return 1;
        }

        public void run(TestResult result) {
            result.startTest((Test)this);
            result.addError((Test)this, this.thrown);
        }
    }
}

