/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import java.lang.reflect.Method;
import org.aspectj.lang.reflect.AdviceSignature;
import org.aspectj.runtime.reflect.CodeSignatureImpl;
import org.aspectj.runtime.reflect.StringMaker;

class AdviceSignatureImpl
extends CodeSignatureImpl
implements AdviceSignature {
    Class returnType;
    private Method adviceMethod = null;

    AdviceSignatureImpl(int modifiers, String name, Class declaringType, Class[] parameterTypes, String[] parameterNames, Class[] exceptionTypes, Class returnType) {
        super(modifiers, name, declaringType, parameterTypes, parameterNames, exceptionTypes);
        this.returnType = returnType;
    }

    AdviceSignatureImpl(String stringRep) {
        super(stringRep);
    }

    public Class getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.extractType(6);
        }
        return this.returnType;
    }

    protected String createToString(StringMaker sm) {
        StringBuffer buf = new StringBuffer("ADVICE: ");
        buf.append(sm.makeModifiersString(this.getModifiers()));
        if (sm.includeArgs) {
            buf.append(sm.makeTypeName(this.getReturnType()));
        }
        if (sm.includeArgs) {
            buf.append(" ");
        }
        buf.append(sm.makePrimaryTypeName(this.getDeclaringType(), this.getDeclaringTypeName()));
        buf.append(".");
        buf.append(this.getName());
        sm.addSignature(buf, this.getParameterTypes());
        sm.addThrows(buf, this.getExceptionTypes());
        return buf.toString();
    }

    public Method getAdvice() {
        if (this.adviceMethod == null) {
            try {
                this.adviceMethod = this.getDeclaringType().getDeclaredMethod(this.getName(), this.getParameterTypes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.adviceMethod;
    }
}

