/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.aspectj.bridge.IMessage;

class KindTest {
    static final IMessage.Kind[] KINDS = new IMessage.Kind[]{IMessage.ABORT, IMessage.DEBUG, IMessage.ERROR, IMessage.INFO, IMessage.WARNING, IMessage.FAIL};
    static final List KINDLIST = Arrays.asList(KINDS);
    static final BitSet UNSET = new BitSet(KINDS.length);
    final BitSet expected = new BitSet(KINDS.length);
    IMessage.Kind kind = IMessage.INFO;

    KindTest() {
    }

    public String testKindSet(IMessage m2, IMessage.Kind newKind) {
        IMessage.Kind oldKind = this.kind;
        String result = this.setKind(newKind);
        if (null == result) {
            result = this.checkKindSet(m2, newKind);
        }
        if (null == result) {
            result = this.checkExpectedKind(m2);
        }
        return null != result ? result : this.setKind(oldKind);
    }

    private String setKind(IMessage.Kind kind) {
        this.kind = kind;
        int index = KINDLIST.indexOf(kind);
        if (-1 == index) {
            return "unknown kind: " + kind;
        }
        this.expected.and(UNSET);
        this.expected.set(index);
        return null;
    }

    String checkExpectedKind(IMessage m2) {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < KINDS.length; ++i2) {
            if (this.expected.get(i2) == this.checkKindMethods(m2, i2)) continue;
            String s2 = "expected " + this.expected.get(i2) + " for is{Method} for " + KINDS[i2];
            result.append(s2 + "\n");
        }
        return 0 < result.length() ? result.toString() : null;
    }

    String checkKindSet(IMessage m2, IMessage.Kind kind) {
        if (kind != m2.getKind()) {
            return "expected kind " + kind + " got " + m2.getKind();
        }
        return null;
    }

    boolean checkKindMethods(IMessage m2, int index) {
        switch (index) {
            case 0: {
                return m2.isAbort();
            }
            case 1: {
                return m2.isDebug();
            }
            case 2: {
                return m2.isError();
            }
            case 3: {
                return m2.isInfo();
            }
            case 4: {
                return m2.isWarning();
            }
            case 5: {
                return m2.isFailed();
            }
        }
        throw new IllegalArgumentException("index=" + index);
    }
}

