/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.aspectj.bridge.IMessage;

public class AbortException
extends RuntimeException {
    private boolean isSilent = false;
    public static final String NO_MESSAGE_TEXT = "AbortException (no message)";
    private static final ArrayList porters = new ArrayList();
    protected IMessage message;
    protected boolean isPorter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbortException borrowPorter(IMessage message) {
        AbortException result;
        ArrayList arrayList = porters;
        synchronized (arrayList) {
            if (porters.size() > 0) {
                result = (AbortException)porters.get(0);
            } else {
                result = new AbortException();
                result.setIsSilent(false);
            }
        }
        result.setIMessage(message);
        result.isPorter = true;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void returnPorter(AbortException porter) {
        ArrayList arrayList = porters;
        synchronized (arrayList) {
            if (porters.contains(porter)) {
                throw new IllegalStateException("already have " + porter);
            }
            porters.add(porter);
        }
    }

    private static String extractMessage(IMessage message) {
        if (null == message) {
            return NO_MESSAGE_TEXT;
        }
        String m2 = message.getMessage();
        if (null == m2) {
            return NO_MESSAGE_TEXT;
        }
        return m2;
    }

    public AbortException() {
        this("ABORT");
        this.isSilent = true;
    }

    public AbortException(String s2) {
        super(null != s2 ? s2 : NO_MESSAGE_TEXT);
        this.message = null;
    }

    public AbortException(IMessage message) {
        super(AbortException.extractMessage(message));
        this.message = message;
    }

    public IMessage getIMessage() {
        return this.message;
    }

    public boolean isPorter() {
        return this.isPorter;
    }

    public Throwable getThrown() {
        Throwable result = null;
        IMessage m2 = this.getIMessage();
        if (null != m2 && (result = m2.getThrown()) instanceof AbortException) {
            return ((AbortException)result).getThrown();
        }
        return result;
    }

    private void setIMessage(IMessage message) {
        this.message = message;
    }

    public String getMessage() {
        String message = super.getMessage();
        if (null == message || NO_MESSAGE_TEXT == message) {
            Throwable thrown;
            IMessage m2 = this.getIMessage();
            if (null != m2 && null == (message = m2.getMessage()) && null != (thrown = m2.getThrown())) {
                message = thrown.getMessage();
            }
            if (null == message) {
                message = NO_MESSAGE_TEXT;
            }
        }
        return message;
    }

    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    public void printStackTrace(PrintStream s2) {
        Throwable thrown;
        IMessage m2 = this.getIMessage();
        Throwable throwable = thrown = null == m2 ? null : m2.getThrown();
        if (!this.isPorter() || null == thrown) {
            s2.println("Message: " + m2);
            super.printStackTrace(s2);
        } else {
            thrown.printStackTrace(s2);
        }
    }

    public void printStackTrace(PrintWriter s2) {
        Throwable thrown;
        IMessage m2 = this.getIMessage();
        Throwable throwable = thrown = null == m2 ? null : m2.getThrown();
        if (null == thrown) {
            if (this.isPorter()) {
                s2.println("(Warning porter AbortException without thrown)");
            }
            s2.println("Message: " + m2);
            super.printStackTrace(s2);
        } else {
            thrown.printStackTrace(s2);
        }
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public void setIsSilent(boolean isSilent) {
        this.isSilent = isSilent;
    }
}

