/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.util.ShortListImpl;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class Field {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;

    public Field(XPath xPath, IdentityConstraint identityConstraint) {
        this.fXPath = xPath;
        this.fIdentityConstraint = identityConstraint;
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator fieldActivator, ValueStore valueStore) {
        return new Matcher(this.fXPath, fieldActivator, valueStore);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    protected class Matcher
    extends XPathMatcher {
        protected FieldActivator fFieldActivator;
        protected ValueStore fStore;

        public Matcher(XPath xPath, FieldActivator fieldActivator, ValueStore valueStore) {
            super(xPath);
            this.fFieldActivator = fieldActivator;
            this.fStore = valueStore;
        }

        protected void matched(Object object, short s2, ShortList shortList, boolean bl) {
            super.matched(object, s2, shortList, bl);
            if (bl && Field.this.fIdentityConstraint.getCategory() == 1) {
                String string = "KeyMatchesNillable";
                this.fStore.reportError(string, new Object[]{Field.this.fIdentityConstraint.getElementName()});
            }
            this.fStore.addValue(Field.this, object, this.convertToPrimitiveKind(s2), this.convertToPrimitiveKind(shortList));
            this.fFieldActivator.setMayMatch(Field.this, Boolean.FALSE);
        }

        private short convertToPrimitiveKind(short s2) {
            if (s2 <= 20) {
                return s2;
            }
            if (s2 <= 29) {
                return 2;
            }
            if (s2 <= 42) {
                return 4;
            }
            return s2;
        }

        private ShortList convertToPrimitiveKind(ShortList shortList) {
            if (shortList != null) {
                int n2 = shortList.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    short s2 = shortList.item(n3);
                    if (s2 != this.convertToPrimitiveKind(s2)) break;
                    ++n3;
                }
                if (n3 != n2) {
                    short[] sArray = new short[n2];
                    int n4 = 0;
                    while (n4 < n3) {
                        sArray[n4] = shortList.item(n4);
                        ++n4;
                    }
                    while (n3 < n2) {
                        sArray[n3] = this.convertToPrimitiveKind(shortList.item(n3));
                        ++n3;
                    }
                    return new ShortListImpl(sArray, sArray.length);
                }
            }
            return shortList;
        }

        protected void handleContent(XSTypeDefinition xSTypeDefinition, boolean bl, Object object, short s2, ShortList shortList) {
            if (xSTypeDefinition == null || xSTypeDefinition.getTypeCategory() == 15 && ((XSComplexTypeDefinition)xSTypeDefinition).getContentType() != 1) {
                this.fStore.reportError("cvc-id.3", new Object[]{Field.this.fIdentityConstraint.getName(), Field.this.fIdentityConstraint.getElementName()});
            }
            this.fMatchedString = object;
            this.matched(this.fMatchedString, s2, shortList, bl);
        }
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        public XPath(String string, SymbolTable symbolTable, NamespaceContext namespaceContext) throws XPathException {
            super(string.trim().startsWith("/") || string.trim().startsWith(".") ? string : "./" + string, symbolTable, namespaceContext);
            int n2 = 0;
            while (n2 < this.fLocationPaths.length) {
                int n3 = 0;
                while (n3 < this.fLocationPaths[n2].steps.length) {
                    XPath.Axis axis = this.fLocationPaths[n2].steps[n3].axis;
                    if (axis.type == 2 && n3 < this.fLocationPaths[n2].steps.length - 1) {
                        throw new XPathException("c-fields-xpaths");
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }
}

