/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathEvaluator;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression {
    private Configuration config;
    private Expression expression;
    private NodeInfo contextNode;
    private SlotManager stackFrameMap;
    private XPathExpressionImpl sortKey = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$List;

    protected XPathExpressionImpl(Expression expression, Configuration configuration) {
        this.expression = expression;
        this.config = configuration;
    }

    protected void setStackFrameMap(SlotManager slotManager) {
        this.stackFrameMap = slotManager;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSortKey(XPathExpressionImpl xPathExpressionImpl) {
        this.sortKey = xPathExpressionImpl;
    }

    public void setContextNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        if (nodeInfo.getNamePool() != this.config.getNamePool()) {
            throw new IllegalArgumentException("Supplied node uses the wrong NamePool");
        }
        this.contextNode = nodeInfo;
    }

    public List evaluate() throws XPathException {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.contextNode, this.config);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContextMajor);
        SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
        return (List)sequenceExtent.convertToJava(class$java$lang$Object == null ? (class$java$lang$Object = XPathExpressionImpl.class$("java.lang.Object")) : class$java$lang$Object, xPathContextMajor);
    }

    public Object evaluateSingle() throws XPathException {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.contextNode, this.config);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContextMajor);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return Value.convert(item);
    }

    public SequenceIterator rawIterator() throws XPathException {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.contextNode, this.config);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContextMajor);
        if (this.sortKey != null) {
            Expression expression = this.sortKey.expression;
            if (expression.getItemType(this.config.getTypeHierarchy()) instanceof NodeTest) {
                expression = new Atomizer(expression, this.config);
            }
            FixedSortKeyDefinition[] fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[]{new FixedSortKeyDefinition()};
            fixedSortKeyDefinitionArray[0].setSortKey(expression);
            fixedSortKeyDefinitionArray[0].bindComparer(xPathContextMajor);
            sequenceIterator = new SortedIterator(xPathContextMajor, sequenceIterator, fixedSortKeyDefinitionArray);
            ((SortedIterator)sequenceIterator).setHostLanguage(54);
        }
        return sequenceIterator;
    }

    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        Object object2;
        Object object3;
        ExternalObjectModel externalObjectModel = null;
        if (object instanceof NodeInfo) {
            this.setContextNode((NodeInfo)object);
        } else {
            externalObjectModel = this.config.findExternalObjectModel(object);
            if (externalObjectModel == null) {
                throw new XPathExpressionException("Cannot locate an object model implementation for nodes of class " + object.getClass().getName());
            }
            object3 = externalObjectModel.wrapDocument(object, "", this.config);
            object2 = externalObjectModel.wrapNode((DocumentInfo)object3, object);
            this.setContextNode((NodeInfo)object2);
        }
        object3 = new XPathContextMajor(this.contextNode, this.config);
        ((XPathContextMajor)object3).openStackFrame(this.stackFrameMap);
        try {
            if (qName.equals(XPathConstants.BOOLEAN)) {
                return this.expression.effectiveBooleanValue((XPathContext)object3);
            }
            if (qName.equals(XPathConstants.STRING)) {
                object2 = this.expression.iterate((XPathContext)object3);
                Item item = object2.next();
                if (item == null) {
                    return "";
                }
                return item.getStringValue();
            }
            if (qName.equals(XPathConstants.NUMBER)) {
                object2 = new Atomizer(this.expression, this.config).iterate((XPathContext)object3);
                Item item = object2.next();
                if (item == null) {
                    return new Double(Double.NaN);
                }
                if (item instanceof NumericValue) {
                    return new Double(((NumericValue)item).getDoubleValue());
                }
                DoubleValue doubleValue = NumberFn.convert((AtomicValue)item);
                return new Double(doubleValue.getDoubleValue());
            }
            if (qName.equals(XPathConstants.NODE)) {
                object2 = this.expression.iterate((XPathContext)object3);
                Item item = object2.next();
                if (item instanceof VirtualNode) {
                    return ((VirtualNode)item).getUnderlyingNode();
                }
                if (item == null || item instanceof NodeInfo) {
                    return item;
                }
                throw new XPathExpressionException("Expression result is not a node");
            }
            if (qName.equals(XPathConstants.NODESET)) {
                Object object4;
                object2 = this.expression.iterate((XPathContext)object3);
                SequenceExtent sequenceExtent = new SequenceExtent((SequenceIterator)object2);
                if (externalObjectModel != null && (object4 = externalObjectModel.convertToNodeList(sequenceExtent)) != null) {
                    return object4;
                }
                return sequenceExtent.convertToJava(class$java$util$List == null ? (class$java$util$List = XPathExpressionImpl.class$("java.util.List")) : class$java$util$List, (XPathContext)object3);
            }
            throw new IllegalArgumentException("Unknown type for expected result");
        }
        catch (XPathException xPathException) {
            throw new XPathExpressionException(xPathException);
        }
    }

    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        try {
            NodeInfo nodeInfo = new XPathEvaluator().setSource(new SAXSource(inputSource));
            return this.evaluate(nodeInfo, qName);
        }
        catch (XPathException xPathException) {
            throw new XPathExpressionException(xPathException);
        }
    }

    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        try {
            NodeInfo nodeInfo = new XPathEvaluator().setSource(new SAXSource(inputSource));
            return (String)this.evaluate(nodeInfo, XPathConstants.STRING);
        }
        catch (XPathException xPathException) {
            throw new XPathExpressionException(xPathException);
        }
    }

    public Expression getInternalExpression() {
        return this.expression;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

