/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.tinytree.CompressedWhitespace;

public class Whitespace {
    public static final int PRESERVE = 0;
    public static final int REPLACE = 1;
    public static final int COLLAPSE = 2;
    public static final int NONE = 10;
    public static final int IGNORABLE = 11;
    public static final int ALL = 12;
    public static final int UNSPECIFIED = 13;
    private static boolean[] C0WHITE = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true};

    private Whitespace() {
    }

    public static boolean isWhitespace(int n2) {
        switch (n2) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static CharSequence applyWhitespaceNormalization(int n2, CharSequence charSequence) {
        switch (n2) {
            case 0: {
                return charSequence;
            }
            case 1: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
                for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                    char c2 = charSequence.charAt(i2);
                    switch (c2) {
                        case '\t': 
                        case '\n': 
                        case '\r': {
                            fastStringBuffer.append(' ');
                        }
                    }
                    fastStringBuffer.append(c2);
                }
                return fastStringBuffer;
            }
            case 2: {
                return NormalizeSpace.normalize(charSequence);
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }

    public static CharSequence removeAllWhitespace(CharSequence charSequence) {
        if (Whitespace.containsWhitespace(charSequence)) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                char c2 = charSequence.charAt(i2);
                if (c2 <= ' ' && C0WHITE[c2]) continue;
                fastStringBuffer.append(c2);
            }
            return fastStringBuffer;
        }
        return charSequence;
    }

    public static CharSequence removeLeadingWhitespace(CharSequence charSequence) {
        int n2 = 0;
        int n3 = charSequence.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 <= ' ' && C0WHITE[c2]) continue;
            n2 = i2;
            break;
        }
        if (n2 == 0) {
            return charSequence;
        }
        if (n2 == n3 - 1) {
            return "";
        }
        return charSequence.subSequence(n2, n3);
    }

    public static boolean containsWhitespace(CharSequence charSequence) {
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2;
            if ((c2 = charSequence.charAt(n3++)) > ' ' || !C0WHITE[c2]) continue;
            return true;
        }
        return false;
    }

    public static final boolean isWhite(CharSequence charSequence) {
        if (charSequence instanceof CompressedWhitespace) {
            return true;
        }
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2;
            if ((c2 = charSequence.charAt(n3++)) <= ' ' && C0WHITE[c2]) continue;
            return false;
        }
        return true;
    }
}

