/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.List;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public final class ShareableSequence
extends Value {
    private List list;
    private int end;
    private ItemType itemType = null;

    public ShareableSequence(List list) {
        this.list = list;
        this.end = list.size();
    }

    public boolean isShareable() {
        return this.list.size() == this.end;
    }

    public List getList() {
        return this.list;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public Value simplify() {
        int n2 = this.getLength();
        if (n2 == 0) {
            return EmptySequence.getInstance();
        }
        if (n2 == 1) {
            return Value.asValue(this.itemAt(0));
        }
        return this;
    }

    public Value reduce() {
        return this.simplify();
    }

    public int getLength() {
        return this.end;
    }

    public int getCardinality() {
        switch (this.end) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.end == 0) {
            this.itemType = AnyItemType.getInstance();
        } else {
            this.itemType = Type.getItemType(this.itemAt(0));
            for (int i2 = 1; i2 < this.end; ++i2) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, Type.getItemType(this.itemAt(i2)), typeHierarchy);
            }
        }
        return this.itemType;
    }

    public Item itemAt(int n2) {
        if (n2 < 0 || n2 >= this.getLength()) {
            return null;
        }
        return (Item)this.list.get(n2);
    }

    public SequenceIterator iterate(XPathContext xPathContext) {
        return new ListIterator(this.list, this.end);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        int n2 = this.getLength();
        if (n2 == 0) {
            return false;
        }
        if (this.itemAt(0) instanceof NodeInfo) {
            return true;
        }
        if (n2 > 1) {
            return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
        }
        return ((AtomicValue)this.itemAt(0)).effectiveBooleanValue(xPathContext);
    }
}

