/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ReverseArrayIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public final class SequenceExtent
extends Value {
    private Item[] value;
    private int start = 0;
    private int end;
    private ItemType itemType = null;

    public SequenceExtent(Item[] itemArray) {
        this.value = itemArray;
        this.end = itemArray.length;
    }

    public SequenceExtent(Item[] itemArray, int n2, int n3) {
        this.value = itemArray;
        this.start = n2;
        this.end = this.start + n3;
    }

    public SequenceExtent(SequenceExtent sequenceExtent, int n2, int n3) {
        this.value = sequenceExtent.value;
        this.start = sequenceExtent.start + n2;
        this.end = this.start + n3;
    }

    public SequenceExtent(List list) {
        this.copyList(list);
    }

    private void copyList(List list) {
        this.value = new Item[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.value[i2] = (Item)list.get(i2);
        }
        this.end = list.size();
    }

    public SequenceExtent(SequenceIterator sequenceIterator) throws XPathException {
        if ((sequenceIterator.getProperties() & 2) == 0) {
            Item item;
            ArrayList<Item> arrayList = new ArrayList<Item>(20);
            while ((item = sequenceIterator.next()) != null) {
                arrayList.add(item);
            }
            this.copyList(arrayList);
        } else {
            Item item;
            this.end = ((LastPositionFinder)sequenceIterator).getLastPosition();
            this.value = new Item[this.end];
            int n2 = 0;
            while ((item = sequenceIterator.next()) != null) {
                this.value[n2++] = item;
            }
        }
    }

    public static Value makeSequenceExtent(SequenceIterator sequenceIterator) throws XPathException {
        if ((sequenceIterator.getProperties() & 1) != 0) {
            return ((GroundedIterator)sequenceIterator).materialize();
        }
        return new SequenceExtent(sequenceIterator);
    }

    public int getImplementationMethod() {
        return 2;
    }

    public Value simplify() {
        int n2 = this.getLength();
        if (n2 == 0) {
            return EmptySequence.getInstance();
        }
        if (n2 == 1) {
            return Value.asValue(this.itemAt(0));
        }
        return this;
    }

    public Value reduce() {
        return this.simplify();
    }

    public int getLength() {
        return this.end - this.start;
    }

    public int getCardinality() {
        switch (this.end - this.start) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.end == this.start) {
            this.itemType = AnyItemType.getInstance();
        } else {
            this.itemType = Type.getItemType(this.value[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, Type.getItemType(this.value[i2]), typeHierarchy);
            }
        }
        return this.itemType;
    }

    public Item itemAt(int n2) {
        if (n2 < 0 || n2 >= this.getLength()) {
            return null;
        }
        return this.value[this.start + n2];
    }

    public void swap(int n2, int n3) {
        Item item = this.value[this.start + n2];
        this.value[this.start + n2] = this.value[this.start + n3];
        this.value[this.start + n3] = item;
    }

    public SequenceIterator iterate(XPathContext xPathContext) {
        return new ArrayIterator(this.value, this.start, this.end);
    }

    public AxisIterator reverseIterate() {
        return new ReverseArrayIterator(this.value, this.start, this.end);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        int n2 = this.getLength();
        if (n2 == 0) {
            return false;
        }
        if (this.value[0] instanceof NodeInfo) {
            return true;
        }
        if (n2 > 1) {
            return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
        }
        return ((AtomicValue)this.value[0]).effectiveBooleanValue(xPathContext);
    }
}

