/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;

public final class SecondsDurationValue
extends DurationValue
implements Comparable {
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    private SecondsDurationValue() {
    }

    public SecondsDurationValue(CharSequence charSequence) throws XPathException {
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)SecondsDurationValue.trimWhitespace(charSequence)).toString(), "-+.PDTHMS", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                this.badDuration("+ sign not allowed in a duration", charSequence);
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n3 = 0;
            block9: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if ("T".equals(string)) {
                    n3 = 4;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDuration("T must be followed by time components", charSequence);
                    }
                    string = (String)stringTokenizer.nextElement();
                }
                int n4 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c2 = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c2) {
                    case 'D': {
                        if (n3 > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n4;
                        ++n2;
                        n3 = 3;
                        continue block9;
                    }
                    case 'H': {
                        if (n3 != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n4;
                        ++n2;
                        n3 = 5;
                        continue block9;
                    }
                    case 'M': {
                        if (n3 < 4 || n3 > 5) {
                            this.badDuration("M is out of sequence", charSequence);
                        }
                        this.minutes = n4;
                        ++n2;
                        n3 = 6;
                        continue block9;
                    }
                    case '.': {
                        if (n3 < 4 || n3 > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n4;
                        ++n2;
                        n3 = 7;
                        continue block9;
                    }
                    case 'S': {
                        if (n3 < 4 || n3 > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n3 == 7) {
                            while (string.length() < 6) {
                                string = string + "0";
                            }
                            if (string.length() > 6) {
                                string = string.substring(0, 6);
                            }
                            this.microseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n4;
                        }
                        ++n2;
                        n3 = 8;
                        continue block9;
                    }
                }
                this.badDuration("misplaced " + c2, charSequence);
            }
            if (n2 == 0) {
                this.badDuration("Duration specifies no components", charSequence);
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric or out-of-range component", charSequence);
        }
    }

    public SecondsDurationValue(int n2, int n3, int n4, int n5, int n6, int n7) throws ValidationException {
        this.negative = n2 < 0;
        this.years = 0;
        this.months = 0;
        this.days = n3;
        this.hours = n4;
        this.minutes = n5;
        this.seconds = n6;
        this.microseconds = n7;
        this.normalize();
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append('P');
        if (this.days != 0) {
            fastStringBuffer.append(this.days + "D");
        }
        if (this.days == 0 || this.hours != 0 || this.minutes != 0 || this.seconds != 0 || this.microseconds != 0) {
            fastStringBuffer.append('T');
        }
        if (this.hours != 0) {
            fastStringBuffer.append(this.hours + "H");
        }
        if (this.minutes != 0) {
            fastStringBuffer.append(this.minutes + "M");
        }
        if (this.seconds != 0 || this.microseconds != 0 || this.days == 0 && this.minutes == 0 && this.hours == 0) {
            if (this.microseconds == 0) {
                fastStringBuffer.append(this.seconds + "S");
            } else {
                long l2 = this.seconds * 1000000 + this.microseconds;
                String string = l2 + "";
                if (this.seconds == 0) {
                    string = "0000000" + string;
                    string = string.substring(string.length() - 7);
                }
                fastStringBuffer.append(string.substring(0, string.length() - 6));
                fastStringBuffer.append('.');
                int n2 = string.length() - 1;
                while (string.charAt(n2) == '0') {
                    --n2;
                }
                fastStringBuffer.append(string.substring(string.length() - 6, n2 + 1));
                fastStringBuffer.append('S');
            }
        }
        return fastStringBuffer;
    }

    public void normalize() throws ValidationException {
        long l2 = this.seconds;
        long l3 = this.minutes;
        long l4 = this.hours;
        long l5 = this.days;
        if (this.microseconds >= 1000000) {
            l2 += (long)(this.microseconds / 1000000);
            this.microseconds %= 1000000;
        }
        if (this.seconds >= 60) {
            l3 += l2 / 60L;
            l2 = (int)(l2 % 60L);
        }
        if (l3 >= 60L) {
            l4 += l3 / 60L;
            l3 = (int)(l3 % 60L);
        }
        if (l4 >= 24L) {
            if ((l5 += l4 / 24L) > Integer.MAX_VALUE || l5 < Integer.MIN_VALUE) {
                throw new ValidationException("Duration exceeds implementation-defined limits");
            }
            l4 = (int)(l4 % 24L);
        }
        this.days = (int)l5;
        this.hours = (int)l4;
        this.minutes = (int)l3;
        this.seconds = (int)l2;
        this.normalizeZeroDuration();
    }

    public double getLengthInSeconds() {
        double d2 = this.days;
        d2 = d2 * 24.0 + (double)this.hours;
        d2 = d2 * 60.0 + (double)this.minutes;
        d2 = d2 * 60.0 + (double)this.seconds;
        return this.negative ? -d2 : (d2 += (double)this.microseconds / 1000000.0);
    }

    public long getLengthInMilliseconds() {
        long l2 = this.days;
        l2 = l2 * 24L + (long)this.hours;
        l2 = l2 * 60L + (long)this.minutes;
        l2 = l2 * 60L + (long)this.seconds;
        l2 = l2 * 1000L + (long)(this.microseconds / 1000);
        return this.negative ? -l2 : l2;
    }

    public long getLengthInMicroseconds() {
        long l2 = this.days;
        l2 = l2 * 24L + (long)this.hours;
        l2 = l2 * 60L + (long)this.minutes;
        l2 = l2 * 60L + (long)this.seconds;
        l2 = l2 * 1000000L + (long)this.microseconds;
        return this.negative ? -l2 : l2;
    }

    public static SecondsDurationValue fromSeconds(BigDecimal bigDecimal) throws XPathException {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        boolean bl = secondsDurationValue.negative = bigDecimal.signum() < 0;
        if (secondsDurationValue.negative) {
            bigDecimal = bigDecimal.negate();
        }
        BigDecimal bigDecimal2 = bigDecimal.multiply(DecimalValue.ONE_MILLION);
        BigInteger bigInteger = bigDecimal2.toBigInteger();
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.valueOf(1000000L));
        long l2 = bigIntegerArray[0].longValue();
        secondsDurationValue.days = (int)(l2 / 86400L);
        secondsDurationValue.seconds = (int)(l2 % 86400L);
        secondsDurationValue.microseconds = bigIntegerArray[1].intValue();
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public static SecondsDurationValue fromMilliseconds(long l2) throws XPathException {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        secondsDurationValue.negative = l2 < 0L;
        l2 = Math.abs(l2);
        long l3 = l2 / 1000L;
        secondsDurationValue.days = (int)(l3 / 86400L);
        secondsDurationValue.seconds = (int)(l3 % 86400L);
        secondsDurationValue.microseconds = (int)(l2 % 1000L) * 1000;
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public static SecondsDurationValue fromMicroseconds(long l2) throws XPathException {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        secondsDurationValue.negative = l2 < 0L;
        l2 = Math.abs(l2);
        long l3 = l2 / 1000000L;
        secondsDurationValue.days = (int)(l3 / 86400L);
        secondsDurationValue.seconds = (int)(l3 % 86400L);
        secondsDurationValue.microseconds = (int)(l2 % 1000000L);
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public DurationValue multiply(double d2, XPathContext xPathContext) throws XPathException {
        if (Double.isNaN(d2)) {
            DynamicError dynamicError = new DynamicError("Cannot multiply/divide a duration by NaN");
            dynamicError.setErrorCode("FOCA0005");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        double d3 = this.getLengthInMicroseconds();
        double d4 = d2 * d3;
        if (Double.isInfinite(d4) || Double.isNaN(d4) || d4 > 9.223372036854776E18 || d4 < -9.223372036854776E18) {
            DynamicError dynamicError = new DynamicError("Overflow when multiplying/dividing a duration by a number");
            dynamicError.setErrorCode("FODT0002");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        return SecondsDurationValue.fromMicroseconds((long)d4);
    }

    public DecimalValue divide(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            BigDecimal bigDecimal = BigDecimal.valueOf(this.getLengthInMicroseconds());
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((SecondsDurationValue)durationValue).getLengthInMicroseconds());
            if (bigDecimal2.signum() == 0) {
                DynamicError dynamicError = new DynamicError("Divide by zero (durations)");
                dynamicError.setErrorCode("FOAR0001");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            return new DecimalValue(bigDecimal.divide(bigDecimal2, 20, 6));
        }
        throw new DynamicError("Cannot divide two durations of different type");
    }

    public DurationValue add(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            return SecondsDurationValue.fromMicroseconds(this.getLengthInMicroseconds() + ((SecondsDurationValue)durationValue).getLengthInMicroseconds());
        }
        throw new DynamicError("Cannot add two durations of different type");
    }

    public DurationValue subtract(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            return SecondsDurationValue.fromMicroseconds(this.getLengthInMicroseconds() - ((SecondsDurationValue)durationValue).getLengthInMicroseconds());
        }
        throw new DynamicError("Cannot add two durations of different type");
    }

    public int compareTo(Object object) {
        if (object instanceof SecondsDurationValue) {
            long l2 = this.getLengthInMicroseconds() - ((SecondsDurationValue)object).getLengthInMicroseconds();
            if (l2 < 0L) {
                return -1;
            }
            if (l2 > 0L) {
                return 1;
            }
            return 0;
        }
        throw new ClassCastException("Cannot compare a dayTimeDuration to an object of class " + object.getClass());
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.DAY_TIME_DURATION_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = SecondsDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SecondsDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = SecondsDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SecondsDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new DynamicError("Conversion of dayTimeDuration to " + clazz.getName() + " is not supported");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

