/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class MemoClosure
extends Closure {
    private Item[] reservoir = null;
    private int used;
    protected int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                this.inputIterator = this.expression.iterate(this.savedXPathContext);
                if (this.inputIterator instanceof EmptyIterator) {
                    this.state = 5;
                    return this.inputIterator;
                }
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                return new ArrayIterator(this.reservoir, 0, this.used);
            }
            case 4: {
                throw new DynamicError("Attempt to access a lazily-evaluated variable while it is being evaluated");
            }
            case 5: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public void process(XPathContext xPathContext) throws XPathException {
        if (this.state == 5) {
            return;
        }
        if (this.reservoir != null) {
            Item item;
            SequenceIterator sequenceIterator = this.iterate(xPathContext);
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            while ((item = sequenceIterator.next()) != null) {
                sequenceReceiver.append(item, 0, 2);
            }
        } else {
            Controller controller = xPathContext.getController();
            XPathContextMinor xPathContextMinor = this.savedXPathContext.newMinorContext();
            SequenceOutputter sequenceOutputter = controller.allocateSequenceOutputter(20);
            sequenceOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            sequenceOutputter.open();
            TeeOutputter teeOutputter = new TeeOutputter(xPathContext.getReceiver(), sequenceOutputter);
            teeOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            xPathContextMinor.setTemporaryReceiver(teeOutputter);
            this.expression.process(xPathContextMinor);
            sequenceOutputter.close();
            ArrayList arrayList = sequenceOutputter.getList();
            if (arrayList.size() == 0) {
                this.state = 5;
            } else {
                this.reservoir = new Item[arrayList.size()];
                this.reservoir = arrayList.toArray(this.reservoir);
                this.used = arrayList.size();
                this.state = 3;
            }
            this.savedXPathContext = null;
            sequenceOutputter.reset();
        }
    }

    public Item itemAt(int n2) throws XPathException {
        if (n2 < 0) {
            return null;
        }
        if (this.reservoir != null && n2 < this.used) {
            return this.reservoir[n2];
        }
        if (this.state == 3 || this.state == 5) {
            return null;
        }
        if (this.state == 0) {
            return super.itemAt(n2);
        }
        int n3 = n2 - this.used + 1;
        while (n3-- > 0) {
            Item item = this.inputIterator.next();
            if (item == null) {
                this.state = 3;
                this.condense();
                return this.itemAt(n2);
            }
            this.append(item);
            this.state = 1;
        }
        return this.reservoir[n2];
    }

    public int getLength() throws XPathException {
        if (this.state == 3) {
            return this.used;
        }
        if (this.state == 5) {
            return 0;
        }
        return super.getLength();
    }

    private void append(Item item) {
        if (this.used >= this.reservoir.length) {
            Item[] itemArray = new Item[this.used * 2];
            System.arraycopy(this.reservoir, 0, itemArray, 0, this.used);
            this.reservoir = itemArray;
        }
        this.reservoir[this.used++] = item;
    }

    private void condense() {
        if (this.reservoir.length - this.used > 30) {
            Item[] itemArray = new Item[this.used];
            System.arraycopy(this.reservoir, 0, itemArray, 0, this.used);
            this.reservoir = itemArray;
        }
        this.savedXPathContext = null;
    }

    public boolean isFullyRead() {
        return this.state == 5 || this.state == 3;
    }

    public Value materialize() throws XPathException {
        if (this.state == 3) {
            return new SequenceExtent(this.reservoir, 0, this.used);
        }
        if (this.state == 5) {
            return EmptySequence.getInstance();
        }
        return new SequenceExtent(this.iterate(null));
    }

    public final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        int position = -1;

        public Item next() throws XPathException {
            if (this.position == -2) {
                return null;
            }
            if (++this.position < MemoClosure.this.used) {
                return MemoClosure.this.reservoir[this.position];
            }
            Item item = MemoClosure.this.inputIterator.next();
            if (item == null) {
                MemoClosure.this.state = 3;
                MemoClosure.this.condense();
                this.position = -2;
                return null;
            }
            this.position = MemoClosure.this.used;
            MemoClosure.this.append(item);
            MemoClosure.this.state = 1;
            return item;
        }

        public Item current() {
            if (this.position < 0) {
                return null;
            }
            return MemoClosure.this.reservoir[this.position];
        }

        public int position() {
            return this.position + 1;
        }

        public SequenceIterator getAnother() {
            return new ProgressiveIterator();
        }

        public int getLastPosition() throws XPathException {
            Item item;
            if (MemoClosure.this.state == 3) {
                return MemoClosure.this.used;
            }
            if (MemoClosure.this.state == 5) {
                return 0;
            }
            int n2 = this.position;
            while ((item = this.next()) != null) {
            }
            this.position = n2;
            return MemoClosure.this.used;
        }

        public Value materialize() throws XPathException {
            if (MemoClosure.this.state == 3) {
                return new SequenceExtent(MemoClosure.this.reservoir);
            }
            if (MemoClosure.this.state == 5) {
                return EmptySequence.getInstance();
            }
            return new SequenceExtent(MemoClosure.this.iterate(null));
        }

        public int getProperties() {
            if (MemoClosure.this.state == 5 || MemoClosure.this.state == 3) {
                return 3;
            }
            return 0;
        }
    }
}

