/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class GYearMonthValue
extends DateValue {
    private static Pattern regex = Pattern.compile("(-?[0-9]+-[0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    public GYearMonthValue() {
    }

    public GYearMonthValue(CharSequence charSequence) throws XPathException {
        Matcher matcher = regex.matcher(GYearMonthValue.trimWhitespace(charSequence));
        if (!matcher.matches()) {
            throw new DynamicError("Cannot convert '" + charSequence + "' to a gYearMonth");
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = string + "-01" + (string2 == null ? "" : string2);
        this.setLexicalValue(string3);
    }

    public GYearMonthValue(int n2, byte by, int n3) {
        this.year = n2;
        this.month = by;
        this.day = 1;
        this.setTimezoneInMinutes(n3);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.G_YEAR_MONTH_TYPE;
    }

    public CalendarValue copy() {
        return new GYearMonthValue(this.year, this.month, this.getTimezoneInMinutes());
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 522: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert gYearMonth to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n2 = this.year;
        if (this.year < 0) {
            fastStringBuffer.append('-');
            n2 = -n2 + 1;
        }
        GYearMonthValue.appendString(fastStringBuffer, n2, n2 > 9999 ? (n2 + "").length() : 4);
        fastStringBuffer.append('-');
        GYearMonthValue.appendTwoDigits(fastStringBuffer, this.month);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }
}

